/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_7094;
import net.minecraft.class_8046;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.PinkSaltShard;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.init.GEnchantments;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class PinkSaltPillar
extends class_1297
implements class_8046 {
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(PinkSaltPillar.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> ACTIVE = class_2945.method_12791(PinkSaltPillar.class, (class_2941)class_2943.field_13323);
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUUID;
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    public static final float DEFAULT_DAMAGE = 3.0f;
    private float damage = 3.0f;
    public class_7094 emergeAnimationState = new class_7094();
    public class_7094 retractAnimationState = new class_7094();

    public PinkSaltPillar(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PinkSaltPillar(class_1937 level, double d, double e, double f, float g, int warmupDelayTicks, float damage, class_1309 livingEntity) {
        this(GEntityTypes.PINK_SALT_PILLAR, level);
        this.warmupDelayTicks = warmupDelayTicks;
        this.damage = damage;
        this.setOwner(livingEntity);
        this.method_36456(g * 57.295776f);
        this.method_5814(d, e, f);
    }

    public PinkSaltPillar(class_1937 level, double d, double e, double f, float g, int warmupDelayTicks, float damage, class_1309 livingEntity, class_1799 itemStack) {
        this(GEntityTypes.PINK_SALT_PILLAR, level);
        this.warmupDelayTicks = warmupDelayTicks;
        this.damage = damage;
        this.setOwner(livingEntity);
        this.method_36456(g * 57.295776f);
        this.method_5814(d, e, f);
        this.field_6011.method_12778(ITEM, (Object)itemStack.method_7972());
        this.lifeTicks = 22 * (class_1890.method_8225((class_1887)GEnchantments.SUSTAIN, (class_1799)itemStack) / 2 + 1);
    }

    protected void method_5693() {
        this.field_6011.method_12784(ACTIVE, (Object)false);
        this.field_6011.method_12784(ITEM, (Object)class_1799.field_8037);
    }

    public void setOwner(@Nullable class_1309 livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.method_5667();
    }

    @Nullable
    public class_1309 getOwner() {
        class_1297 entity;
        if (this.owner == null && this.ownerUUID != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUUID)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    protected void method_5749(class_2487 compoundTag) {
        this.warmupDelayTicks = compoundTag.method_10550("Warmup");
        this.lifeTicks = compoundTag.method_10550("LifeTicks");
        this.damage = compoundTag.method_10583("Damage");
        this.setActive(compoundTag.method_10577("Active"));
        class_1799 itemStack = class_1799.method_7915((class_2487)compoundTag.method_10562("TabletItem"));
        if (!itemStack.method_7960()) {
            this.field_6011.method_12778(ITEM, (Object)itemStack);
        }
        if (compoundTag.method_25928("Owner")) {
            this.ownerUUID = compoundTag.method_25926("Owner");
        }
    }

    protected void method_5652(class_2487 compoundTag) {
        compoundTag.method_10569("Warmup", this.warmupDelayTicks);
        compoundTag.method_10569("LifeTicks", this.lifeTicks);
        compoundTag.method_10548("Damage", this.damage);
        compoundTag.method_10556("Active", this.isActive());
        class_1799 itemStack = (class_1799)this.field_6011.method_12789(ITEM);
        if (!itemStack.method_7960()) {
            compoundTag.method_10566("TabletItem", (class_2520)itemStack.method_7953(new class_2487()));
        }
        if (this.ownerUUID != null) {
            compoundTag.method_25927("Owner", this.ownerUUID);
        }
    }

    private void setActive(boolean active) {
        this.field_6011.method_12778(ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.field_6011.method_12789(ACTIVE);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            class_1937 stack;
            List arrows = this.method_37908().method_18467(class_1667.class, this.method_5829().method_1014(1.2));
            for (Object arrow : arrows) {
                class_243 selfPos = this.method_19538().method_1031(0.0, (double)1.6f, 0.0);
                class_243 enemyPos = arrow.method_33571().method_1020(selfPos);
                class_243 normalizedDirection = enemyPos.method_1029();
                double knockbackX = 0.15;
                double knockbackY = 0.15;
                arrow.method_18799(arrow.method_18798().method_1031(normalizedDirection.method_10216() * knockbackY, normalizedDirection.method_10214() * knockbackX, normalizedDirection.method_10215() * knockbackY));
            }
            if (--this.warmupDelayTicks < 0) {
                int ruptureLevel;
                boolean fracture;
                List list = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1009(0.2, 0.0, 0.2));
                for (class_1309 livingEntity : list) {
                    if (this.getOwner() instanceof Berserker && livingEntity instanceof Preserved) continue;
                    this.dealDamageTo(livingEntity);
                }
                if (!this.sentSpikeEvent) {
                    this.setActive(true);
                    this.method_37908().method_8421((class_1297)this, (byte)4);
                    this.sentSpikeEvent = true;
                }
                boolean bl = fracture = (ruptureLevel = class_1890.method_8225((class_1887)GEnchantments.RUPTURE, (class_1799)(stack = (class_1799)this.field_6011.method_12789(ITEM)))) > 0;
                if (!fracture) {
                    if (this.lifeTicks == 4) {
                        this.method_37908().method_8421((class_1297)this, (byte)6);
                    }
                    if (--this.lifeTicks < 0) {
                        this.method_31472();
                    }
                } else if (--this.lifeTicks < 0) {
                    for (int i = 0; i < ruptureLevel + 2; ++i) {
                        PinkSaltShard pinkSaltShard = new PinkSaltShard(this.getOwner(), this.method_37908());
                        pinkSaltShard.method_29495(class_243.method_24953((class_2382)this.method_24515()));
                        class_243 vec3 = new class_243(this.field_5974.method_43059(), this.field_5974.method_43059(), this.field_5974.method_43059()).method_1029();
                        class_243 vec31 = vec3.method_1021(0.75);
                        pinkSaltShard.method_18799(vec31);
                        this.method_37908().method_8649((class_1297)pinkSaltShard);
                    }
                    this.method_31472();
                }
            }
            if (this.warmupDelayTicks == 0 && (stack = this.method_37908()) instanceof class_3218) {
                class_3218 server = (class_3218)stack;
                class_243 pos = this.method_19538();
                server.method_14199((class_2394)new class_2388(class_2398.field_11217, server.method_8320(this.method_23312())), pos.field_1352, pos.field_1351, pos.field_1350, 12, 0.4, 0.0, 0.4, 0.1);
                if (this.method_5869()) {
                    server.method_14199((class_2394)class_2398.field_11238, pos.field_1352, pos.field_1351, pos.field_1350, 8, 0.3, 0.0, 0.3, 0.3);
                }
            }
        }
    }

    private void dealDamageTo(class_1309 livingEntity) {
        class_1309 livingEntity2 = this.getOwner();
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            if (livingEntity2 != null && player.method_5667().equals(livingEntity2.method_5667())) {
                return;
            }
        }
        if (!livingEntity.method_5805() || livingEntity.method_5655() || livingEntity == livingEntity2) {
            return;
        }
        if (livingEntity2 == null) {
            livingEntity.method_5643(this.method_48923().method_48831(), this.damage);
        } else {
            boolean slowness;
            if (livingEntity2.method_5722((class_1297)livingEntity)) {
                return;
            }
            livingEntity.method_5643(this.method_48923().method_48815((class_1297)this, (class_1297)livingEntity2), this.damage);
            class_1799 stack = (class_1799)this.field_6011.method_12789(ITEM);
            boolean bl = slowness = class_1890.method_8225((class_1887)GEnchantments.ENFEEBLE, (class_1799)stack) > 0;
            if (slowness) {
                livingEntity.method_6092(new class_1293(class_1294.field_5909, 100));
            }
        }
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        if (damageSource.method_5529() instanceof class_1667) {
            return false;
        }
        return super.method_5643(damageSource, f);
    }

    public void method_5711(byte b) {
        super.method_5711(b);
        if (b == 4) {
            this.emergeAnimationState.method_41322(this.field_6012);
            if (!this.method_5701()) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), GSoundEvents.PINK_SALT_PILLAR_EMERGE, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.2f + 0.85f, false);
            }
        } else if (b == 6) {
            this.retractAnimationState.method_41322(this.field_6012);
        }
    }
}

