/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1315;
import net.minecraft.class_1333;
import net.minecraft.class_1439;
import net.minecraft.class_1481;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_174;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_3988;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import net.minecraft.class_7094;
import net.orcinus.galosphere.entities.ai.BerserkerAi;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class Berserker
extends class_1588 {
    protected static final ImmutableList<? extends class_4149<? extends class_4148<? super Berserker>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_18469, GSensorTypes.BLIGHTED_ENTITY_SENSOR);
    protected static final ImmutableList<? extends class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18448, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_18446, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_22355, (Object)class_4140.field_22475, (Object)class_4140.field_22357, (Object[])new class_4140[]{class_4140.field_18451, class_4140.field_18452, class_4140.field_30243, GMemoryModuleTypes.IMPALING_COOLDOWN, GMemoryModuleTypes.IMPALING_COUNT, GMemoryModuleTypes.IS_SMASHING, GMemoryModuleTypes.IS_IMPALING, GMemoryModuleTypes.IS_SUMMONING, GMemoryModuleTypes.SUMMONING_COOLDOWN, GMemoryModuleTypes.SUMMON_COUNT, GMemoryModuleTypes.SMASHING_COOLDOWN, GMemoryModuleTypes.HURT_COUNT, GMemoryModuleTypes.RAMPAGE_TICKS, class_4140.field_38104, class_4140.field_38113, GMemoryModuleTypes.IS_SHAKING});
    private static final class_2940<String> PHASE = class_2945.method_12791(Berserker.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> STATIONARY_TICKS = class_2945.method_12791(Berserker.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SHEDDING = class_2945.method_12791(Berserker.class, (class_2941)class_2943.field_13323);
    private final List<class_1291> selectedEffects = (List)class_156.method_654((Object)Lists.newArrayList(), list -> {
        list.add(GMobEffects.BLOCK_BANE);
        list.add(class_1294.field_5901);
    });
    public class_7094 roarAnimationState = new class_7094();
    public class_7094 attackAnimationState = new class_7094();
    public class_7094 punchAnimationState = new class_7094();
    public class_7094 impalingAnimationState = new class_7094();
    public class_7094 summoningAnimationState = new class_7094();

    public Berserker(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6206 = new BerserkerLookControl((class_1308)this);
    }

    public boolean method_5679(class_1282 damageSource) {
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!player.method_31549().field_7477 && this.getStationaryTicks() > 0) {
                return true;
            }
        }
        return super.method_5679(damageSource);
    }

    public float method_49476() {
        return 1.0f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PHASE, (Object)Phase.IDLING.name());
        this.field_6011.method_12784(STATIONARY_TICKS, (Object)0);
        this.field_6011.method_12784(SHEDDING, (Object)false);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        String phase = compoundTag.method_10558("Phase");
        if (!phase.isEmpty()) {
            this.setPhase(Phase.valueOf(phase));
        }
        this.setStationaryTicks(compoundTag.method_10550("StationaryTicks"));
        this.setShedding(compoundTag.method_10577("Shedding"));
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10582("Phase", this.getPhase().name());
        compoundTag.method_10569("StationaryTicks", this.getStationaryTicks());
        compoundTag.method_10556("Shedding", this.isShedding());
    }

    public boolean shouldAttack() {
        return this.getPhase() == Phase.IDLING && !this.isStationary();
    }

    public int getStage() {
        float health = this.method_6032() / this.method_6063();
        if (this.isStationary()) {
            return 3;
        }
        if (health > 0.66f) {
            return 0;
        }
        if (health <= 0.66f && health > 0.33f) {
            return 1;
        }
        return 2;
    }

    public void setShedding(boolean shedding) {
        this.field_6011.method_12778(SHEDDING, (Object)shedding);
    }

    public boolean isShedding() {
        return (Boolean)this.field_6011.method_12789(SHEDDING);
    }

    public void setStationaryTicks(int stationaryTicks) {
        this.field_6011.method_12778(STATIONARY_TICKS, (Object)stationaryTicks);
    }

    public int getStationaryTicks() {
        return (Integer)this.field_6011.method_12789(STATIONARY_TICKS);
    }

    public void setPhase(Phase phase) {
        if (phase == Phase.IDLING) {
            this.method_18380(class_4050.field_18076);
        } else if (phase == Phase.SMASH) {
            this.method_37908().method_8421((class_1297)this, (byte)4);
        } else if (phase == Phase.UNDERMINE) {
            this.method_37908().method_8421((class_1297)this, (byte)6);
        } else if (phase == Phase.SUMMONING) {
            this.method_37908().method_8421((class_1297)this, (byte)7);
        }
        this.field_6011.method_12778(PHASE, (Object)phase.name());
    }

    public void method_5711(byte b) {
        if (b == 4) {
            this.attackAnimationState.method_41322(this.field_6012);
        } else if (b == 5) {
            this.punchAnimationState.method_41322(this.field_6012);
        } else if (b == 6) {
            this.impalingAnimationState.method_41322(this.field_6012);
        } else if (b == 7) {
            this.summoningAnimationState.method_41322(this.field_6012);
        } else if (b == 32) {
            class_2338 blockPos = this.method_23312();
            this.method_37908().method_8406((class_2394)GParticleTypes.IMPACT, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 1.15, (double)blockPos.method_10260() + 0.5, 0.0, 0.0, 0.0);
        } else {
            super.method_5711(b);
        }
    }

    public Phase getPhase() {
        String s = (String)this.field_6011.method_12789(PHASE);
        return Phase.valueOf(s);
    }

    public void method_6007() {
        super.method_6007();
        double range = 0.75;
        double threshold = range - 0.6;
        double increment = 0.2;
        if (!this.method_37908().field_9236) {
            int count = 250;
            boolean stationary = this.isStationary();
            boolean shedding = this.isShedding();
            if (this.method_6032() < this.method_6063() && this.field_6012 % count == 0) {
                this.method_6025(10.0f);
            }
            if (stationary) {
                this.method_18868().method_35058().keySet().stream().filter(memoryModuleType -> memoryModuleType.equals(class_4140.field_18445) || memoryModuleType.equals(class_4140.field_18446)).forEach(arg_0 -> this.method_18868().method_18875(arg_0));
                List<class_1657> list = this.method_37908().method_18467(class_1657.class, this.method_5829().method_1014(3.0)).stream().filter(p -> !p.method_7337() && p.method_5805()).toList();
                Optional player = list.stream().findAny();
                if (!shedding) {
                    player.ifPresent(this::setTarget);
                } else {
                    list.stream().filter(class_3222.class::isInstance).map(class_3222.class::cast).forEach(serverPlayer -> class_174.field_1182.method_9124(serverPlayer, (class_1297)this));
                    if (this.getStationaryTicks() == 32) {
                        this.method_18868().method_18878(GMemoryModuleTypes.IS_SHAKING, (Object)class_3902.field_17274);
                    }
                    this.setStationaryTicks(this.getStationaryTicks() - 1);
                    this.addParticles(range, increment, threshold);
                }
            } else if (shedding) {
                this.setShedding(false);
                this.method_5971();
            }
        }
    }

    private void addParticles(double range, double increment, double threshold) {
        if (this.field_6012 % 20 == 0) {
            for (double y = 0.0; y <= 1.95; y += 0.35) {
                for (double x = -range; x <= range; x += increment) {
                    for (double z = -range; z <= range; z += increment) {
                        if (x >= -threshold && x <= threshold || z >= -threshold && z <= threshold) continue;
                        ((class_3218)this.method_37908()).method_14199((class_2394)GParticleTypes.PINK_SALT_FALLING_DUST, this.method_23317() + x, this.method_23318() + y, this.method_23321() + z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public boolean isStationary() {
        return this.getStationaryTicks() > 0;
    }

    private void setTarget(class_1657 player) {
        class_4095<Berserker> brain = this.method_18868();
        brain.method_18878(class_4140.field_22355, (Object)player);
        this.setShedding(true);
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        if (mobSpawnType == class_3730.field_16474) {
            this.setStationaryTicks(200);
        }
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.isStationary() ? null : GSoundEvents.BERSERKER_IDLE;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return GSoundEvents.BERSERKER_HURT;
    }

    protected class_3414 method_6002() {
        return GSoundEvents.BERSERKER_DEATH;
    }

    protected class_3414 getStepSound() {
        return GSoundEvents.BERSERKER_STEP;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(this.getStepSound(), 1.0f, 1.0f);
    }

    public boolean canTargetEntity(@Nullable class_1297 entity) {
        class_1297 e2;
        class_1297 class_12972;
        if (!(entity instanceof class_1309)) {
            return false;
        }
        class_1309 livingEntity = (class_1309)entity;
        Predicate<class_1309> predicate = e -> e.method_5864().method_20210(GEntityTypeTags.BERSERKER_INVALID_TARGETS);
        if (livingEntity.method_5655() || livingEntity.method_29504() || predicate.test(livingEntity)) {
            return false;
        }
        class_1282 lastSource = this.method_6081();
        if (lastSource != null && (class_12972 = (e2 = lastSource.method_5529())) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            if (e2 == livingEntity && !predicate.test(living)) {
                return true;
            }
        }
        if (this.method_37908() != entity.method_37908() || !class_1301.field_6156.test(entity) || this.method_5722(entity) || !this.method_37908().method_8621().method_11966(livingEntity.method_5829())) {
            return false;
        }
        return livingEntity instanceof class_1657 || livingEntity instanceof class_3988 || livingEntity instanceof class_1439 || livingEntity instanceof class_1481;
    }

    protected void method_48565(float f) {
        float g = Math.min(f * 10.0f, 1.0f);
        this.field_42108.method_48568(g, 0.2f);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (field_18064.equals(entityDataAccessor) && this.method_18376() == class_4050.field_38099) {
            this.roarAnimationState.method_41322(this.field_6012);
        }
        super.method_5674(entityDataAccessor);
    }

    public boolean shouldUseMeleeAttack() {
        Optional memory = this.method_18868().method_18904(class_4140.field_22355);
        return memory.filter(livingEntity -> this.method_42150((class_1309)livingEntity) && this.getPhase() != Phase.SMASH && this.shouldAttack() && this.isInHardMode() && this.method_18868().method_18904(GMemoryModuleTypes.RAMPAGE_TICKS).isPresent() && (Integer)this.method_18868().method_18904(GMemoryModuleTypes.RAMPAGE_TICKS).get() > 0).isPresent();
    }

    public boolean isInHardMode() {
        return this.method_37908().method_8407() == class_1267.field_5807;
    }

    public boolean method_6121(class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_6092(new class_1293(class_1294.field_5909, 100));
            if (this.shouldUseMeleeAttack()) {
                class_243 start = this.method_19538().method_1031(0.0, (double)1.6f, 0.0);
                class_243 diff = entity.method_33571().method_1020(start);
                class_243 normalized = diff.method_1029();
                double knockbackX = 0.25 * (1.0 - livingEntity.method_26825(class_5134.field_23718));
                double knockbackY = 1.5 * (1.0 - livingEntity.method_26825(class_5134.field_23718));
                livingEntity.method_5762(normalized.method_10216() * knockbackY, normalized.method_10214() * knockbackX, normalized.method_10215() * knockbackY);
                this.method_37908().method_8421((class_1297)this, (byte)5);
                this.method_5783(GSoundEvents.BERSERKER_PUNCH, 1.0f, 1.0f);
            }
        }
        return super.method_6121(entity);
    }

    public boolean method_42149() {
        return true;
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        if (!this.method_37908().field_9236 && this.getPhase() != Phase.IDLING && this.isInHardMode()) {
            if (this.method_18868().method_18904(GMemoryModuleTypes.HURT_COUNT).isEmpty()) {
                this.method_18868().method_18878(GMemoryModuleTypes.HURT_COUNT, (Object)0);
            } else {
                int i = (Integer)this.method_18868().method_18904(GMemoryModuleTypes.HURT_COUNT).get() + 1;
                if (i > 2) {
                    i = 0;
                    this.method_18868().method_18878(GMemoryModuleTypes.RAMPAGE_TICKS, (Object)class_6019.method_35017((int)30, (int)150).method_35008(this.method_6051()));
                }
                this.method_18868().method_18878(GMemoryModuleTypes.HURT_COUNT, (Object)i);
            }
        }
        if (damageSource.method_5526() instanceof class_1665 && this.getPhase() != Phase.IDLING) {
            return false;
        }
        return super.method_5643(damageSource, f);
    }

    public static class_5132.class_5133 createAttributes() {
        return Berserker.method_26918().method_26868(class_5134.field_23716, 250.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23722, 1.5);
    }

    protected class_4095.class_5303<Berserker> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return BerserkerAi.makeBrain(this, (class_4095<Berserker>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Berserker> method_18868() {
        return super.method_18868();
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("blightedBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        BerserkerAi.updateActivity(this);
        super.method_5958();
        if ((this.field_6012 + this.method_5628()) % 1200 == 0) {
            this.selectedEffects.forEach(mobEffect -> {
                class_1293 mobEffectInstance = new class_1293(mobEffect, 6000, 2);
                class_1292.method_42143((class_3218)((class_3218)this.method_37908()), (class_1297)this, (class_243)this.method_19538(), (double)50.0, (class_1293)mobEffectInstance, (int)1200);
            });
        }
        if (this.method_18868().method_18904(class_4140.field_18452).isEmpty() && this.getPhase() != Phase.IDLING) {
            this.setPhase(Phase.IDLING);
        }
    }

    public void method_6091(class_243 vec3) {
        if (this.isStationary() && this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            vec3 = vec3.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(vec3);
    }

    public class BerserkerLookControl
    extends class_1333 {
        public BerserkerLookControl(class_1308 mob) {
            super(mob);
        }

        public void method_6231() {
            if (!Berserker.this.isStationary()) {
                super.method_6231();
            }
        }
    }

    public static enum Phase {
        IDLING,
        SMASH,
        UNDERMINE,
        SUMMONING;

    }
}

