/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.crafting;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import net.orcinus.galosphere.Galosphere;

public class LumiereReformingManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON_INSTANCE = new GsonBuilder().create();
    private static final Map<class_2248, class_2248> REFORMING_TABLE = Maps.newHashMap();

    public LumiereReformingManager() {
        super(GSON_INSTANCE, "loot_tables/gameplay");
    }

    protected void apply(Map<class_2960, JsonElement> pObject, class_3300 resourceManagerIn, class_3695 pProfiler) {
        class_2960 resourceLocation = Galosphere.id("loot_tables/gameplay/lumiere_reforming_table.json");
        try {
            for (class_3298 iResource : resourceManagerIn.method_14489(resourceLocation)) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(iResource.method_14482(), StandardCharsets.UTF_8));){
                    JsonObject jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    JsonArray entryList = jsonObject.get("entries").getAsJsonArray();
                    for (JsonElement entry : entryList) {
                        REFORMING_TABLE.put((class_2248)class_7923.field_41175.method_10223(new class_2960(entry.getAsJsonObject().get("accepted_block").getAsString())), (class_2248)class_7923.field_41175.method_10223(new class_2960(entry.getAsJsonObject().get("returned_block").getAsString())));
                    }
                }
                catch (IOException | RuntimeException exception) {
                    Galosphere.LOGGER.error("Couldn't read lumiere reforming table list {} in data pack {}", (Object)resourceLocation, (Object)iResource.method_14480(), (Object)exception);
                }
            }
        }
        catch (NoSuchElementException exception) {
            Galosphere.LOGGER.error("Couldn't read lumiere reforming table from {}", (Object)resourceLocation, (Object)exception);
        }
    }

    public static Map<class_2248, class_2248> getReformingTable() {
        return REFORMING_TABLE;
    }

    public class_2960 getFabricId() {
        return Galosphere.id("loot_tables/gameplay");
    }
}

