/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.block;

import java.util.BitSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5539;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_778;
import net.minecraft.class_827;
import net.orcinus.galosphere.blocks.ShadowFrameBlock;
import net.orcinus.galosphere.blocks.blockentities.ShadowFrameBlockEntity;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.mixin.access.AmbientOcclusionFaceAccessor;
import net.orcinus.galosphere.mixin.access.ModelBlockRendererAccessor;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ShadowFrameBlockRenderer
implements class_827<ShadowFrameBlockEntity> {
    static final class_2350[] DIRECTIONS = class_2350.values();
    private final class_776 blockRenderer;

    public ShadowFrameBlockRenderer(class_5614.class_5615 context) {
        this.blockRenderer = context.method_32141();
    }

    public void render(ShadowFrameBlockEntity blockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        class_2680 state = blockEntity.getCopiedState();
        if (state.method_26215()) {
            return;
        }
        this.tesselateBlock((class_1920)blockEntity.method_10997(), this.blockRenderer.method_3349(state), state, blockEntity.method_11016(), poseStack, multiBufferSource.getBuffer(class_4696.method_29359((class_2680)state)), false, class_5819.method_43047(), state.method_26190(blockEntity.method_11016()), class_4608.field_21444);
    }

    public void tesselateBlock(class_1920 blockAndTintGetter, class_1087 bakedModel, class_2680 blockState, class_2338 blockPos, class_4587 poseStack, class_4588 vertexConsumer, boolean bl, class_5819 randomSource, long l, int i) {
        boolean bl2 = class_310.method_1588() && blockState.method_26213() == 0 && bakedModel.method_4708();
        class_243 vec3 = blockState.method_26226((class_1922)blockAndTintGetter, blockPos);
        poseStack.method_22904(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        try {
            if (bl2) {
                this.tesselateWithAO(blockAndTintGetter, bakedModel, blockState, blockPos, poseStack, vertexConsumer, bl, randomSource, l, i);
            } else {
                this.tesselateWithoutAO(blockAndTintGetter, bakedModel, blockState, blockPos, poseStack, vertexConsumer, bl, randomSource, l, i);
            }
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tesselating block model");
            class_129 crashReportCategory = crashReport.method_562("Block model being tesselated");
            class_129.method_586((class_129)crashReportCategory, (class_5539)blockAndTintGetter, (class_2338)blockPos, (class_2680)blockState);
            crashReportCategory.method_578("Using AO", (Object)bl2);
            throw new class_148(crashReport);
        }
    }

    public void tesselateWithAO(class_1920 blockAndTintGetter, class_1087 bakedModel, class_2680 blockState, class_2338 blockPos, class_4587 poseStack, class_4588 vertexConsumer, boolean bl, class_5819 randomSource, long l, int i) {
        float[] fs = new float[DIRECTIONS.length * 2];
        BitSet bitSet = new BitSet(3);
        class_778.class_780 ambientOcclusionFace = new class_778.class_780();
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        for (class_2350 direction : DIRECTIONS) {
            randomSource.method_43052(l);
            List list = bakedModel.method_4707(blockState, direction, randomSource);
            if (list.isEmpty()) continue;
            mutableBlockPos.method_25505((class_2382)blockPos, direction);
            if (this.skipRendering(blockAndTintGetter, blockState, blockPos, bl, mutableBlockPos, direction)) continue;
            this.renderModelFaceAO(blockAndTintGetter, blockState, blockPos, poseStack, vertexConsumer, list, fs, bitSet, ambientOcclusionFace, i);
        }
        randomSource.method_43052(l);
        List list2 = bakedModel.method_4707(blockState, null, randomSource);
        if (!list2.isEmpty()) {
            this.renderModelFaceAO(blockAndTintGetter, blockState, blockPos, poseStack, vertexConsumer, list2, fs, bitSet, ambientOcclusionFace, i);
        }
    }

    public void tesselateWithoutAO(class_1920 blockAndTintGetter, class_1087 bakedModel, class_2680 blockState, class_2338 blockPos, class_4587 poseStack, class_4588 vertexConsumer, boolean bl, class_5819 randomSource, long l, int i) {
        BitSet bitSet = new BitSet(3);
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        for (class_2350 direction : DIRECTIONS) {
            randomSource.method_43052(l);
            List list = bakedModel.method_4707(blockState, direction, randomSource);
            if (list.isEmpty()) continue;
            mutableBlockPos.method_25505((class_2382)blockPos, direction);
            if (this.skipRendering(blockAndTintGetter, blockState, blockPos, bl, mutableBlockPos, direction)) continue;
            int j = class_761.method_23793((class_1920)blockAndTintGetter, (class_2680)blockState, (class_2338)mutableBlockPos);
            this.renderModelFaceFlat(blockAndTintGetter, blockState, blockPos, j, i, false, poseStack, vertexConsumer, list, bitSet);
        }
        randomSource.method_43052(l);
        List list2 = bakedModel.method_4707(blockState, null, randomSource);
        if (!list2.isEmpty()) {
            this.renderModelFaceFlat(blockAndTintGetter, blockState, blockPos, -1, i, true, poseStack, vertexConsumer, list2, bitSet);
        }
    }

    private boolean skipRendering(class_1920 blockAndTintGetter, class_2680 blockState, class_2338 blockPos, boolean bl, class_2338.class_2339 mutableBlockPos, class_2350 direction) {
        class_2680 relativeState = blockAndTintGetter.method_8320((class_2338)mutableBlockPos);
        if (relativeState.method_27852(GBlocks.SHADOW_FRAME) && ((Boolean)relativeState.method_11654((class_2769)ShadowFrameBlock.FILLED)).booleanValue()) {
            class_2586 class_25862 = blockAndTintGetter.method_8321((class_2338)mutableBlockPos);
            if (class_25862 instanceof ShadowFrameBlockEntity) {
                ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)class_25862;
                return shadowFrameBlockEntity.getCopiedState().method_26234((class_1922)blockAndTintGetter, (class_2338)mutableBlockPos);
            }
            return true;
        }
        return bl && !class_2248.method_9607((class_2680)blockState, (class_1922)blockAndTintGetter, (class_2338)blockPos, (class_2350)direction, (class_2338)mutableBlockPos);
    }

    private void renderModelFaceAO(class_1920 blockAndTintGetter, class_2680 blockState, class_2338 blockPos, class_4587 poseStack, class_4588 vertexConsumer, List<class_777> list, float[] fs, BitSet bitSet, class_778.class_780 ambientOcclusionFace, int i) {
        for (class_777 bakedQuad : list) {
            this.calculateShape(blockAndTintGetter, blockState, blockPos, bakedQuad.method_3357(), bakedQuad.method_3358(), fs, bitSet);
            ambientOcclusionFace.method_3388(blockAndTintGetter, blockState, blockPos, bakedQuad.method_3358(), fs, bitSet, bakedQuad.method_24874());
            this.putQuadData(blockAndTintGetter, blockState, blockPos, vertexConsumer, poseStack.method_23760(), bakedQuad, ((AmbientOcclusionFaceAccessor)ambientOcclusionFace).getBrightness()[0], ((AmbientOcclusionFaceAccessor)ambientOcclusionFace).getBrightness()[1], ((AmbientOcclusionFaceAccessor)ambientOcclusionFace).getBrightness()[2], ((AmbientOcclusionFaceAccessor)ambientOcclusionFace).getBrightness()[3], ((AmbientOcclusionFaceAccessor)ambientOcclusionFace).getLightmap()[0], ((AmbientOcclusionFaceAccessor)ambientOcclusionFace).getLightmap()[1], ((AmbientOcclusionFaceAccessor)ambientOcclusionFace).getLightmap()[2], ((AmbientOcclusionFaceAccessor)ambientOcclusionFace).getLightmap()[3], i);
        }
    }

    private void putQuadData(class_1920 blockAndTintGetter, class_2680 blockState, class_2338 blockPos, class_4588 vertexConsumer, class_4587.class_4665 pose, class_777 bakedQuad, float f, float g, float h, float i, int j, int k, int l, int m, int n) {
        float r;
        float q;
        float p;
        if (bakedQuad.method_3360()) {
            int o = ((ModelBlockRendererAccessor)this.blockRenderer.method_3350()).getBlockColors().method_1697(blockState, blockAndTintGetter, blockPos, bakedQuad.method_3359());
            p = (float)(o >> 16 & 0xFF) / 255.0f;
            q = (float)(o >> 8 & 0xFF) / 255.0f;
            r = (float)(o & 0xFF) / 255.0f;
        } else {
            p = 1.0f;
            q = 1.0f;
            r = 1.0f;
        }
        vertexConsumer.method_22920(pose, bakedQuad, new float[]{f, g, h, i}, p, q, r, new int[]{j, k, l, m}, n, true);
    }

    private void calculateShape(class_1920 blockAndTintGetter, class_2680 blockState, class_2338 blockPos, int[] is, class_2350 direction, @Nullable float[] fs, BitSet bitSet) {
        int l;
        float f = 32.0f;
        float g = 32.0f;
        float h = 32.0f;
        float i = -32.0f;
        float j = -32.0f;
        float k = -32.0f;
        for (l = 0; l < 4; ++l) {
            float m = Float.intBitsToFloat(is[l * 8]);
            float n = Float.intBitsToFloat(is[l * 8 + 1]);
            float o = Float.intBitsToFloat(is[l * 8 + 2]);
            f = Math.min(f, m);
            g = Math.min(g, n);
            h = Math.min(h, o);
            i = Math.max(i, m);
            j = Math.max(j, n);
            k = Math.max(k, o);
        }
        if (fs != null) {
            fs[class_2350.field_11039.method_10146()] = f;
            fs[class_2350.field_11034.method_10146()] = i;
            fs[class_2350.field_11033.method_10146()] = g;
            fs[class_2350.field_11036.method_10146()] = j;
            fs[class_2350.field_11043.method_10146()] = h;
            fs[class_2350.field_11035.method_10146()] = k;
            l = DIRECTIONS.length;
            fs[class_2350.field_11039.method_10146() + l] = 1.0f - f;
            fs[class_2350.field_11034.method_10146() + l] = 1.0f - i;
            fs[class_2350.field_11033.method_10146() + l] = 1.0f - g;
            fs[class_2350.field_11036.method_10146() + l] = 1.0f - j;
            fs[class_2350.field_11043.method_10146() + l] = 1.0f - h;
            fs[class_2350.field_11035.method_10146() + l] = 1.0f - k;
        }
        switch (direction) {
            case field_11033: {
                bitSet.set(1, f >= 1.0E-4f || h >= 1.0E-4f || i <= 0.9999f || k <= 0.9999f);
                bitSet.set(0, g == j && (g < 1.0E-4f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11036: {
                bitSet.set(1, f >= 1.0E-4f || h >= 1.0E-4f || i <= 0.9999f || k <= 0.9999f);
                bitSet.set(0, g == j && (j > 0.9999f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11043: {
                bitSet.set(1, f >= 1.0E-4f || g >= 1.0E-4f || i <= 0.9999f || j <= 0.9999f);
                bitSet.set(0, h == k && (h < 1.0E-4f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11035: {
                bitSet.set(1, f >= 1.0E-4f || g >= 1.0E-4f || i <= 0.9999f || j <= 0.9999f);
                bitSet.set(0, h == k && (k > 0.9999f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11039: {
                bitSet.set(1, g >= 1.0E-4f || h >= 1.0E-4f || j <= 0.9999f || k <= 0.9999f);
                bitSet.set(0, f == i && (f < 1.0E-4f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11034: {
                bitSet.set(1, g >= 1.0E-4f || h >= 1.0E-4f || j <= 0.9999f || k <= 0.9999f);
                bitSet.set(0, f == i && (i > 0.9999f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
            }
        }
    }

    private void renderModelFaceFlat(class_1920 blockAndTintGetter, class_2680 blockState, class_2338 blockPos, int i, int j, boolean bl, class_4587 poseStack, class_4588 vertexConsumer, List<class_777> list, BitSet bitSet) {
        for (class_777 bakedQuad : list) {
            if (bl) {
                this.calculateShape(blockAndTintGetter, blockState, blockPos, bakedQuad.method_3357(), bakedQuad.method_3358(), null, bitSet);
                class_2338 blockPos2 = bitSet.get(0) ? blockPos.method_10093(bakedQuad.method_3358()) : blockPos;
                i = class_761.method_23793((class_1920)blockAndTintGetter, (class_2680)blockState, (class_2338)blockPos2);
            }
            float f = blockAndTintGetter.method_24852(bakedQuad.method_3358(), bakedQuad.method_24874());
            this.putQuadData(blockAndTintGetter, blockState, blockPos, vertexConsumer, poseStack.method_23760(), bakedQuad, f, f, f, f, i, i, i, i, j);
        }
    }
}

