/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3483;
import net.minecraft.class_4538;
import net.orcinus.galosphere.blocks.MonstrometerBlock;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GParticleTypes;

public class MonstrometerBlockEntity
extends class_2586 {
    private int monsterCount;
    public int activeTicks = 0;

    public MonstrometerBlockEntity(class_2338 pos, class_2680 state) {
        super(GBlockEntityTypes.MONSTROMETER, pos, state);
    }

    public static void createParticles(class_1937 world, class_2338 origin) {
        Predicate<class_2338> predicate = pos -> world.method_22347(pos) && class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)world, (class_2338)pos, (class_1299)class_1299.field_6051);
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            MonstrometerBlock.getIndicatedBlocks(origin, predicate).forEach(pos -> {
                double x = (double)pos.method_10263() + 0.5;
                double y = (float)pos.method_10264() + 0.01f;
                double z = (double)pos.method_10260() + 0.5;
                serverLevel.method_14199((class_2394)GParticleTypes.AURA_RINGER_INDICATOR, x, y, z, 1, 0.0, 0.0, 0.0, 0.5);
            });
        }
    }

    public static void applyGlowing(class_1937 world, class_2338 origin) {
        List<class_1309> mobs = MonstrometerBlockEntity.getNearbyMonsters(world, origin);
        mobs.forEach(mob -> mob.method_6092(new class_1293(class_1294.field_5912, 60)));
    }

    private static List<class_1309> getNearbyMonsters(class_1937 world, class_2338 origin) {
        return world.method_8390(class_1309.class, new class_238(origin).method_1009(16.0, 6.0, 16.0), livingEntity -> livingEntity instanceof class_1588 && !livingEntity.method_5864().method_20210(class_3483.field_19168));
    }

    public static void tick(class_1937 world, class_2338 origin, class_2680 state, MonstrometerBlockEntity entity) {
        int size = MonstrometerBlockEntity.getNearbyMonsters(world, origin).size();
        if (size > 0 && size != entity.monsterCount) {
            entity.monsterCount = size;
            world.method_8452(origin, state.method_26204());
        }
        if (MonstrometerBlock.isActive(state)) {
            if (entity.activeTicks % 34 == 0) {
                MonstrometerBlockEntity.applyGlowing(world, origin);
                MonstrometerBlockEntity.createParticles(world, origin);
            }
            ++entity.activeTicks;
        } else {
            entity.activeTicks = 0;
        }
    }

    public int getRedstoneSignal() {
        return Math.max(Math.min(this.monsterCount, 15), 0);
    }
}

