/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.orcinus.galosphere.blocks.blockentities.MonstrometerBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class MonstrometerBlock
extends class_2237 {
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");
    public static final class_2746 CHARGED = class_2746.method_11825((String)"charged");

    public MonstrometerBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    public void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 blockPos2, boolean bl) {
        if (!level.field_9236) {
            boolean flag;
            boolean bl2 = flag = (Boolean)blockState.method_11654((class_2769)CHARGED) != false && (Boolean)blockState.method_11654((class_2769)ACTIVE) == false;
            if (flag == level.method_49803(blockPos)) {
                if (!flag) {
                    return;
                }
                MonstrometerBlock.activate(blockState, level, blockPos);
            }
        }
    }

    public boolean method_9498(class_2680 blockState) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        class_2586 class_25862;
        if (((Boolean)blockState.method_11654((class_2769)ACTIVE)).booleanValue() && (class_25862 = level.method_8321(blockPos)) instanceof MonstrometerBlockEntity) {
            MonstrometerBlockEntity monstrometerBlockEntity = (MonstrometerBlockEntity)class_25862;
            return monstrometerBlockEntity.getRedstoneSignal();
        }
        return 0;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ACTIVE}).method_11667(new class_2769[]{CHARGED});
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 getter, class_2338 pos) {
        float value = super.method_9594(state, player, getter, pos);
        return MonstrometerBlock.isActive(state) ? value / 25.0f : value;
    }

    public static boolean isActive(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)ACTIVE);
    }

    public static boolean isCharged(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)CHARGED);
    }

    public static boolean isUnsafe(class_1937 world, class_2338 pos) {
        return world.method_8314(class_1944.field_9282, pos) == 0;
    }

    public static List<class_2338> getIndicatedBlocks(class_2338 origin, Predicate<class_2338> predicate) {
        int radius = 16;
        int height = 6;
        ArrayList list = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -height; y <= height; ++y) {
                    if (x * x + z * z > radius * radius) continue;
                    list.add(origin.method_10069(x, y, z));
                }
            }
        }
        return list.stream().filter(predicate).toList();
    }

    public static int getParticleViewRange() {
        return 12;
    }

    public static void activate(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_39279(pos, state.method_26204(), 600);
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        world.method_8396(null, pos, GSoundEvents.MONSTROMETER_ACTIVATE, class_3419.field_15245, 1.0f, 1.0f);
        world.method_8452(pos, state.method_26204());
    }

    public static void deactivate(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(false)), 3);
        world.method_8396(null, pos, GSoundEvents.MONSTROMETER_DEACTIVATE, class_3419.field_15245, 1.0f, 1.0f);
    }

    public static void setCharged(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8652(pos, (class_2680)state.method_28493((class_2769)CHARGED), 2);
        world.method_8396(null, pos, GSoundEvents.MONSTROMETER_CHARGE, class_3419.field_15245, 1.0f, 1.0f);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(GBlocks.LUMIERE_BLOCK.method_8389())) {
            if (!MonstrometerBlock.isCharged(state)) {
                MonstrometerBlock.setCharged(state, world, pos);
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                world.method_33596((class_1297)player, class_5712.field_28733, pos);
                return class_1269.field_5812;
            }
        } else if (MonstrometerBlock.isCharged(state) && !MonstrometerBlock.isActive(state)) {
            MonstrometerBlock.activate(state, world, pos);
            world.method_33596((class_1297)player, class_5712.field_28733, pos);
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (MonstrometerBlock.isActive(state)) {
            MonstrometerBlock.deactivate(state, (class_1937)world, pos);
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MonstrometerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> te) {
        return !world.field_9236 ? MonstrometerBlock.method_31618(te, GBlockEntityTypes.MONSTROMETER, MonstrometerBlockEntity::tick) : null;
    }
}

