/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.model;

import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.model.DefaultedGeoModel;
import mod.azure.azurelib.model.data.EntityModelData;
import net.minecraft.class_2960;

public class DefaultedEntityGeoModel<T extends GeoAnimatable>
extends DefaultedGeoModel<T> {
    private final boolean turnsHead;

    public DefaultedEntityGeoModel(class_2960 assetSubpath) {
        this(assetSubpath, false);
    }

    public DefaultedEntityGeoModel(class_2960 assetSubpath, boolean turnsHead) {
        super(assetSubpath);
        this.turnsHead = turnsHead;
    }

    @Override
    protected String subtype() {
        return "entity";
    }

    @Override
    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        if (!this.turnsHead) {
            return;
        }
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltModel(class_2960 altPath) {
        return (DefaultedEntityGeoModel)super.withAltModel(altPath);
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltAnimations(class_2960 altPath) {
        return (DefaultedEntityGeoModel)super.withAltAnimations(altPath);
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltTexture(class_2960 altPath) {
        return (DefaultedEntityGeoModel)super.withAltTexture(altPath);
    }
}

