/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.spelunker.mixin;

import de.leximon.spelunker.SpelunkerMod;
import de.leximon.spelunker.SpelunkerModClient;
import de.leximon.spelunker.core.ChunkOres;
import de.leximon.spelunker.core.IWorld;
import de.leximon.spelunker.core.SpelunkerConfig;
import de.leximon.spelunker.core.SpelunkerEffectManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1937.class})
public abstract class WorldMixin
implements IWorld {
    private final Map<class_2382, ChunkOres> dirtySpelunkerChunks = new ConcurrentHashMap<class_2382, ChunkOres>();

    @Shadow
    public abstract boolean method_8608();

    @Shadow
    @Nullable
    public abstract MinecraftServer method_8503();

    @Inject(method={"onBlockChanged"}, at={@At(value="HEAD")})
    private void onBlockChangedInject(class_2338 pos, class_2680 oldBlock, class_2680 newBlock, CallbackInfo ci) {
        this.spelunkerUpdateBlock(pos, oldBlock, newBlock);
    }

    @Override
    public void spelunkerUpdateBlock(class_2338 pos, class_2680 oldBlock, class_2680 newBlock) {
        if (!SpelunkerConfig.isOreBlock(oldBlock.method_26204()) && !SpelunkerConfig.isOreBlock(newBlock.method_26204())) {
            return;
        }
        class_2382 chunkPos = new class_2382(class_4076.method_18675((int)pos.method_10263()), ((class_1937)this).method_31603(class_4076.method_18675((int)pos.method_10264())), class_4076.method_18675((int)pos.method_10260()));
        if (this.method_8608()) {
            this.spelunkerUpdateBlockClient(chunkPos, pos, newBlock);
            return;
        }
        this.dirtySpelunkerChunks.compute(chunkPos, (p, chunk) -> {
            if (chunk == null) {
                chunk = new ChunkOres(chunkPos);
            }
            chunk.put(ChunkOres.toLocalCoord((class_2382)pos), (SpelunkerConfig.ChunkBlockConfig)SpelunkerConfig.blockConfigs.getOrDefault((Object)newBlock.method_26204(), (Object)SpelunkerConfig.NONE_BLOCK_CONFIG));
            return chunk;
        });
    }

    @Environment(value=EnvType.CLIENT)
    private void spelunkerUpdateBlockClient(class_2382 chunkPos, class_2338 pos, class_2680 newBlock) {
        ChunkOres chunk;
        class_310 client = class_310.method_1551();
        if ((!SpelunkerConfig.serverValidating || client.method_1542()) && client.field_1724 != null && client.field_1724.method_6059(SpelunkerMod.STATUS_EFFECT_SPELUNKER) && (chunk = SpelunkerModClient.spelunkerEffectRenderer.get(chunkPos)) != null) {
            chunk.processConfig((class_2382)pos, (SpelunkerConfig.ChunkBlockConfig)SpelunkerConfig.blockConfigs.get((Object)newBlock.method_26204()), false);
        }
    }

    @Override
    public void spelunkerUpdateChunks() {
        if (this.dirtySpelunkerChunks.isEmpty()) {
            return;
        }
        if (!SpelunkerConfig.serverValidating) {
            return;
        }
        List<class_3222> players = PlayerLookup.all((MinecraftServer)this.method_8503()).stream().filter(p -> p.method_6059(SpelunkerMod.STATUS_EFFECT_SPELUNKER)).toList();
        if (players.size() == 0) {
            return;
        }
        class_2540 buf = SpelunkerEffectManager.writePacket((class_1937)this, false, Collections.emptyList(), this.dirtySpelunkerChunks.values());
        this.dirtySpelunkerChunks.clear();
        for (class_3222 p2 : players) {
            if (!p2.method_6059(SpelunkerMod.STATUS_EFFECT_SPELUNKER)) continue;
            ServerPlayNetworking.send((class_3222)p2, (class_2960)SpelunkerMod.PACKET_ORE_CHUNKS, (class_2540)buf);
        }
    }
}

