/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.spelunker.core;

import de.leximon.spelunker.core.ChunkOres;
import de.leximon.spelunker.core.SpelunkerConfig;
import de.leximon.spelunker.core.SpelunkerEffectRenderer;
import de.leximon.spelunker.mixin.server.ThreadedAnvilChunkStorageAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_7923;

public class SpelunkerEffectManager {
    public static ChunkOres findOresInChunk(class_1937 world, class_2382 sectionPos) {
        class_2791 chunk = null;
        if (world.method_8398().method_12123(sectionPos.method_10263(), sectionPos.method_10260())) {
            if (world instanceof class_3218) {
                class_3218 sw = (class_3218)world;
                class_3193 chunkHolder = ((ThreadedAnvilChunkStorageAccessor)sw.method_14178().field_17254).spelunkerGetChunkHolder(class_1923.method_8331((int)sectionPos.method_10263(), (int)sectionPos.method_10260()));
                if (chunkHolder != null) {
                    chunk = chunkHolder.method_16144();
                }
            } else {
                chunk = world.method_8402(sectionPos.method_10263(), sectionPos.method_10260(), class_2806.field_12803, false);
            }
        }
        if (chunk == null) {
            return ChunkOres.EMPTY;
        }
        class_2826 section = chunk.method_38259(sectionPos.method_10264());
        ChunkOres ores = new ChunkOres(sectionPos);
        class_2841 blockStates = section.method_12265();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    class_2248 block = ((class_2680)blockStates.method_12321(x, y, z)).method_26204();
                    if (!SpelunkerConfig.isOreBlock(block)) continue;
                    class_2382 blockPos = new class_2382(x, y, z);
                    ores.put(blockPos, (SpelunkerConfig.ChunkBlockConfig)SpelunkerConfig.blockConfigs.get((Object)block));
                }
            }
        }
        return ores;
    }

    public static HashMap<class_2382, class_2826> getSurroundingChunkSections(class_1937 world, class_243 playerPos) {
        int cx = class_4076.method_32204((double)playerPos.field_1352);
        int cy = world.method_31603(class_4076.method_32204((double)playerPos.field_1351));
        int cz = class_4076.method_32204((double)playerPos.field_1350);
        HashMap<class_2382, class_2826> sections = new HashMap<class_2382, class_2826>();
        for (int x = cx - SpelunkerConfig.chunkRadius; x < cx + SpelunkerConfig.chunkRadius + 1; ++x) {
            for (int z = cz - SpelunkerConfig.chunkRadius; z < cz + SpelunkerConfig.chunkRadius + 1; ++z) {
                for (int y = cy - SpelunkerConfig.chunkRadius; y < cy + SpelunkerConfig.chunkRadius + 1; ++y) {
                    class_2818 chunk = world.method_8497(x, z);
                    class_2826[] sectionArray = chunk.method_12006();
                    if (y < 0 || y >= sectionArray.length) continue;
                    sections.put(new class_2382(x, y, z), sectionArray[y]);
                }
            }
        }
        return sections;
    }

    public static class_2540 writePacket(class_1937 world, boolean overwrite, Collection<class_2382> remove, Collection<ChunkOres> add) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(overwrite);
        buf.method_10804(remove.size());
        for (class_2382 pos : remove) {
            buf.method_10804(pos.method_10263());
            buf.method_10804(pos.method_10264());
            buf.method_10804(pos.method_10260());
        }
        buf.method_10804(add.size());
        for (ChunkOres ores : add) {
            class_2382 pos = ores.getPos();
            buf.method_10804(pos.method_10263());
            buf.method_10804(pos.method_10264());
            buf.method_10804(pos.method_10260());
            buf.method_10804(ores.size());
            for (Map.Entry ore : ores.entrySet()) {
                class_2382 orePos = (class_2382)ore.getKey();
                buf.writeByte(orePos.method_10263());
                buf.writeByte(orePos.method_10264());
                buf.writeByte(orePos.method_10260());
                SpelunkerConfig.ChunkBlockConfig conf = (SpelunkerConfig.ChunkBlockConfig)ore.getValue();
                buf.method_10804(SpelunkerConfig.NONE_BLOCK_CONFIG == conf ? -1 : class_7923.field_41175.method_10206((Object)conf.getBlock()));
            }
        }
        if (overwrite) {
            buf.method_10804(world.method_32891());
        }
        return buf;
    }

    @Environment(value=EnvType.CLIENT)
    public static void readPacket(SpelunkerEffectRenderer renderer, class_2540 buf) {
        boolean overwrite = buf.readBoolean();
        int c = buf.method_10816();
        for (int i = 0; i < c; ++i) {
            renderer.removeChunk(new class_2382(buf.method_10816(), buf.method_10816(), buf.method_10816()));
        }
        c = buf.method_10816();
        ArrayList<ChunkOres> chunks = new ArrayList<ChunkOres>(c);
        for (int i = 0; i < c; ++i) {
            class_2382 pos = new class_2382(buf.method_10816(), buf.method_10816(), buf.method_10816());
            ChunkOres ores = overwrite ? new ChunkOres(pos) : renderer.get(pos);
            int cc = buf.method_10816();
            for (int j = 0; j < cc; ++j) {
                class_2382 orePos = new class_2382((int)buf.readByte(), (int)buf.readByte(), (int)buf.readByte());
                int blockId = buf.method_10816();
                if (ores == null) continue;
                ores.processConfig(orePos, blockId == -1 ? null : (SpelunkerConfig.ChunkBlockConfig)SpelunkerConfig.blockConfigs.get(class_7923.field_41175.method_10200(blockId)), true);
            }
            if (!overwrite) continue;
            chunks.add(ores);
        }
        if (overwrite) {
            int bottomSectionCord = buf.method_10816();
            renderer.addChunks(bottomSectionCord, chunks);
        }
    }
}

