/*
 * Decompiled with CFR 0.152.
 */
package de.leximon.spelunker.core;

import de.leximon.spelunker.SpelunkerMod;
import de.siphalor.tweed4.data.hjson.HjsonList;
import de.siphalor.tweed4.data.hjson.HjsonObject;
import de.siphalor.tweed4.data.hjson.HjsonSerializer;
import de.siphalor.tweed4.data.hjson.HjsonValue;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

public class SpelunkerConfig {
    private static final Map<String[], ChunkBlockConfig> DEFAULT_BLOCK_CONFIGS = new HashMap<String[], ChunkBlockConfig>();
    public static final ChunkBlockConfig NONE_BLOCK_CONFIG = new ChunkBlockConfig(0, false, 0);
    public static final List<LootTableEntry> LOOT_TABLES = new ArrayList<LootTableEntry>();
    public static boolean globalTransition = true;
    public static boolean serverValidating = true;
    public static boolean allowPotionBrewing = true;
    public static int chunkRadius = 1;
    public static int amethystChance = 10;
    public static int shortPotionDuration = 45;
    public static int longPotionDuration = 90;
    public static Object2ObjectMap<class_2248, ChunkBlockConfig> blockConfigs = new Object2ObjectOpenHashMap();
    private static Consumer<Void> blockConfigInitializer = v -> {};
    private static boolean blockHighlightInitialized = false;
    public static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "spelunker.hjson");

    public static void createDefaultConfig() throws IOException {
        HjsonObject obj;
        boolean rewrite = false;
        if (CONFIG_FILE.exists()) {
            FileInputStream in = new FileInputStream(CONFIG_FILE);
            obj = HjsonSerializer.INSTANCE.readValue((InputStream)in).asObject();
            ((InputStream)in).close();
        } else {
            obj = HjsonSerializer.INSTANCE.newObject();
            rewrite = true;
        }
        if (!obj.hasBoolean((Object)"server-validating")) {
            obj.set("server-validating", serverValidating).setComment("Checks serverside for blocks to be highlighted and sends them to the client\nrecommended if the server has an anti-xray mod\ndefault: true\n");
            rewrite = true;
        }
        if (!obj.hasBoolean((Object)"allow-potion-brewing")) {
            obj.set("allow-potion-brewing", allowPotionBrewing).setComment("Sets whether or not players can brew the potion\nIf this is disabled amethyst dust will also be unobtainable in survival\ndefault: true\n");
            rewrite = true;
        }
        if (!obj.hasInt((Object)"amethyst-dust-chance")) {
            obj.set("amethyst-dust-chance", amethystChance).setComment("Specifies the chance how often an amethyst dust should drop when mining an amethyst cluster\ndefault: 10\n");
            rewrite = true;
        }
        if (!obj.hasInt((Object)"short-potion-duration")) {
            obj.set("short-potion-duration", shortPotionDuration).setComment("The duration of the short spelunker potion in seconds\ndefault: 45\n");
            rewrite = true;
        }
        if (!obj.hasInt((Object)"long-potion-duration")) {
            obj.set("long-potion-duration", longPotionDuration).setComment("The duration of the long spelunker potion in seconds\ndefault: 90\n");
            rewrite = true;
        }
        if (!obj.hasList((Object)"loot-tables")) {
            int min = 1;
            int max = 1;
            int shortPotionChance = 10;
            int longPotionChance = 25;
            if (obj.hasObject((Object)"loot-table")) {
                HjsonObject lObj = obj.get("loot-table").asObject();
                if (lObj.hasObject((Object)"rolls")) {
                    HjsonObject rObj = lObj.get("rolls").asObject();
                    min = rObj.getInt((Object)"min", 1);
                    max = rObj.getInt((Object)"max", 1);
                }
                shortPotionChance = lObj.getInt((Object)"short-potion-chance", 10);
                longPotionChance = lObj.getInt((Object)"long-potion-chance", 25);
                obj.remove("loot-table");
            }
            HjsonList lootTableList = obj.addList("loot-tables");
            HjsonObject eObj = lootTableList.addObject(Integer.valueOf(lootTableList.size()));
            eObj.set("targetId", "chests/abandoned_mineshaft").setComment("The loot table where the potion should be able to generate in\ndefault: chests/abandoned_mineshaft\n");
            eObj.set("min", min).setComment("Minimum rolls\ndefault: 1\n");
            eObj.set("max", max).setComment("Maximum rolls\ndefault: 1\n");
            eObj.set("short-potion-chance", shortPotionChance).setComment("Modifies how likely it is that a short-potion generates in this loot table\ndefault: 10\n");
            eObj.set("long-potion-chance", longPotionChance).setComment("Modifies how likely it is that a long-potion generates in this loot table\ndefault: 25\n");
            rewrite = true;
        }
        if (!obj.hasBoolean((Object)"block-transition")) {
            obj.set("block-transition", globalTransition).setComment("Determines whether an ease-out animation should be played when approaching a block\nIf this option is false it will overwrite all block-specific transitions\ndefault: true\n");
            rewrite = true;
        }
        if (!obj.hasList((Object)"block-configs")) {
            HjsonList list = obj.addList("block-configs");
            list.setComment("The configuration for the given blocks\n\nhighlightColor:\n    Specifies the color with which the block will be outlined\n    You can also use values like \"red, dark_red, blue, aqua\"\n\ntransition:\n    Determines whether an ease-out animation should be played when approaching a block\n\neffectRadius:\n    How many blocks the effect should range, a higher value than 32 is not recommended\n    Must be greater or equal to 1\n");
            if (obj.hasList((Object)"block-highlight-colors")) {
                HjsonList oldList = obj.get("block-highlight-colors").asList();
                int i = 0;
                for (HjsonValue v : oldList) {
                    String[] vo = v.asObject();
                    vo.set("transition", true);
                    vo.set("effectRadius", obj.getInt((Object)"effect-radius", 16));
                    list.set(Integer.valueOf(i), (HjsonValue)vo);
                    ++i;
                }
                obj.remove("block-highlight-colors");
                obj.remove("effect-radius");
            } else {
                for (Map.Entry<String[], ChunkBlockConfig> entry : DEFAULT_BLOCK_CONFIGS.entrySet()) {
                    HjsonObject eObj = list.addObject(Integer.valueOf(list.size()));
                    HjsonList idList = eObj.addList("blockIds");
                    for (String id : entry.getKey()) {
                        idList.set(Integer.valueOf(idList.size()), id);
                    }
                    String color = class_5251.method_27717((int)entry.getValue().getColor()).method_27721();
                    eObj.set("highlightColor", color).setComment("default: " + color);
                    eObj.set("transition", entry.getValue().isTransition()).setComment("default: " + entry.getValue().isTransition());
                    eObj.set("effectRadius", entry.getValue().getEffectRadius()).setComment("default: " + entry.getValue().getEffectRadius());
                }
            }
            rewrite = true;
        }
        DEFAULT_BLOCK_CONFIGS.clear();
        if (rewrite) {
            CONFIG_FILE.getParentFile().mkdir();
            FileOutputStream out = new FileOutputStream(CONFIG_FILE);
            HjsonSerializer.INSTANCE.writeValue((OutputStream)out, (HjsonValue)obj);
            out.close();
        }
    }

    public static void loadConfig() throws IOException {
        FileInputStream in = new FileInputStream(CONFIG_FILE);
        HjsonObject obj = HjsonSerializer.INSTANCE.readValue((InputStream)in).asObject();
        ((InputStream)in).close();
        serverValidating = obj.getBoolean((Object)"server-validating", serverValidating);
        allowPotionBrewing = obj.getBoolean((Object)"allow-potion-brewing", allowPotionBrewing);
        shortPotionDuration = obj.getInt((Object)"short-potion-duration", shortPotionDuration);
        longPotionDuration = obj.getInt((Object)"long-potion-duration", longPotionDuration);
        amethystChance = obj.getInt((Object)"amethyst-dust-chance", amethystChance);
        for (HjsonValue value : obj.get("block-configs").asList()) {
            HjsonObject blockObj = value.asObject();
            ArrayList<String> blockIds = new ArrayList<String>();
            for (HjsonValue blockIdValue : blockObj.get("blockIds").asList()) {
                blockIds.add(blockIdValue.asString());
            }
            String hcolor = blockObj.getString((Object)"highlightColor", "#ffffff");
            class_5251 textColor = class_5251.method_27719((String)hcolor);
            int color = 0xFFFFFF;
            if (textColor == null) {
                SpelunkerMod.LOGGER.error("Invalid color '{}' specified for the block(s) '{}'.", (Object)hcolor, (Object)StringUtils.join(blockIds, (String)", "));
            } else {
                color = textColor.method_27716();
            }
            boolean transition = blockObj.getBoolean((Object)"transition", true);
            int effectRadius = blockObj.getInt((Object)"effectRadius", 1);
            if (effectRadius < 1) {
                SpelunkerMod.LOGGER.warn("Effect radius '{}' for the block(s) '{}' is smaller than 1.", (Object)effectRadius, (Object)StringUtils.join(blockIds, (String)", "));
                SpelunkerMod.LOGGER.warn("Setting it to 1.");
                effectRadius = 1;
            }
            ChunkBlockConfig config = new ChunkBlockConfig(color, transition, effectRadius);
            blockConfigInitializer = blockConfigInitializer.andThen(v -> {
                for (String blockId : blockIds) {
                    Optional optBlock = class_7923.field_41175.method_17966(new class_2960(blockId));
                    if (optBlock.isEmpty()) {
                        SpelunkerMod.LOGGER.error("Unknown block id in config: '{}'.", (Object)blockId);
                        continue;
                    }
                    class_2248 block = (class_2248)optBlock.get();
                    blockConfigs.put((Object)block, (Object)config.setBlock(block));
                }
            });
        }
        if (obj.has("loot-tables")) {
            for (HjsonValue value : obj.get("loot-tables").asList()) {
                HjsonObject entry = value.asObject();
                if (!entry.hasString((Object)"targetId")) {
                    SpelunkerMod.LOGGER.error("Missing targetId in loottable!");
                    continue;
                }
                LOOT_TABLES.add(new LootTableEntry(new class_2960(entry.get("targetId").asString()), entry.getInt((Object)"min", 1), entry.getInt((Object)"max", 1), entry.getInt((Object)"short-potion-chance", 10), entry.getInt((Object)"long-potion-chance", 25)));
            }
        }
    }

    public static void writePacket(class_2540 buf) {
        buf.writeBoolean(serverValidating);
        buf.method_10804(blockConfigs.size());
        for (Object2ObjectMap.Entry entry : blockConfigs.object2ObjectEntrySet()) {
            ChunkBlockConfig conf = (ChunkBlockConfig)entry.getValue();
            buf.method_10804(class_7923.field_41175.method_10206((Object)((class_2248)entry.getKey())));
            conf.write(buf);
        }
    }

    public static void readPacket(class_2540 buf) {
        serverValidating = buf.readBoolean();
        blockConfigs.clear();
        int c = buf.method_10816();
        for (int i = 0; i < c; ++i) {
            blockConfigs.put((Object)((class_2248)class_7923.field_41175.method_10200(buf.method_10816())), (Object)new ChunkBlockConfig(buf));
        }
    }

    public static void initBlockHighlightConfig() {
        if (blockHighlightInitialized) {
            return;
        }
        blockHighlightInitialized = true;
        blockConfigInitializer.accept(null);
    }

    public static boolean isOreBlock(class_2248 block) {
        return blockConfigs.containsKey((Object)block);
    }

    static {
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:coal_ore", "minecraft:deepslate_coal_ore"}, new ChunkBlockConfig(0x505050, true, 16));
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:iron_ore", "minecraft:deepslate_iron_ore"}, new ChunkBlockConfig(16765373, true, 8));
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:copper_ore", "minecraft:deepslate_copper_ore"}, new ChunkBlockConfig(15425076, true, 12));
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:gold_ore", "minecraft:deepslate_gold_ore", "minecraft:nether_gold_ore"}, new ChunkBlockConfig(16774446, true, 8));
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:diamond_ore", "minecraft:deepslate_diamond_ore"}, new ChunkBlockConfig(3072255, true, 5));
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:emerald_ore", "minecraft:deepslate_emerald_ore"}, new ChunkBlockConfig(3079989, true, 7));
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:lapis_ore", "minecraft:deepslate_lapis_ore"}, new ChunkBlockConfig(3223295, true, 8));
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:redstone_ore", "minecraft:deepslate_redstone_ore"}, new ChunkBlockConfig(0xFF2E2E, true, 8));
        DEFAULT_BLOCK_CONFIGS.put(new String[]{"minecraft:nether_quartz_ore"}, new ChunkBlockConfig(0xFFFFFF, true, 14));
    }

    public static class ChunkBlockConfig {
        private class_2248 block;
        private final int color;
        private final boolean transition;
        private final int effectRadius;
        private int blockRadiusMax;
        private int blockRadiusMin;

        public ChunkBlockConfig(int color, boolean transition, int effectRadius) {
            this.color = color;
            this.transition = transition;
            this.effectRadius = effectRadius;
            this.parseEffectRadius();
        }

        public ChunkBlockConfig(class_2540 buf) {
            this(buf.readInt(), buf.readBoolean(), buf.method_10816());
        }

        public void write(class_2540 buf) {
            buf.writeInt(this.color);
            buf.writeBoolean(this.transition);
            buf.method_10804(this.effectRadius);
        }

        private void parseEffectRadius() {
            int chunkRadius = (int)Math.ceil((float)this.effectRadius / 16.0f);
            if (chunkRadius > SpelunkerConfig.chunkRadius) {
                SpelunkerConfig.chunkRadius = chunkRadius;
            }
            this.blockRadiusMax = (int)Math.pow(this.effectRadius, 2.0);
            this.blockRadiusMin = (int)Math.pow(this.effectRadius - 1, 2.0);
        }

        public ChunkBlockConfig setBlock(class_2248 block) {
            this.block = block;
            return this;
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public int getColor() {
            return this.color;
        }

        public boolean isTransition() {
            return this.transition;
        }

        public int getEffectRadius() {
            return this.effectRadius;
        }

        public int getBlockRadiusMax() {
            return this.blockRadiusMax;
        }

        public int getBlockRadiusMin() {
            return this.blockRadiusMin;
        }
    }

    public record LootTableEntry(class_2960 id, int min, int max, int shortChance, int longChance) {
    }
}

