/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup;

import io.wispforest.owo.client.texture.AnimatedTextureDrawable;
import io.wispforest.owo.client.texture.SpriteSheetMetadata;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.ApiStatus;

public interface Icon {
    public void render(class_332 var1, int var2, int var3, int var4, int var5, float var6);

    public static Icon of(class_1799 stack) {
        return new ItemIcon(stack);
    }

    public static Icon of(class_1935 item) {
        return Icon.of(new class_1799(item));
    }

    public static Icon of(class_2960 texture, int u, int v, int textureWidth, int textureHeight) {
        return new TextureIcon(texture, u, v, textureWidth, textureHeight);
    }

    public static Icon of(class_2960 texture, int textureSize, int frameDelay, boolean loop) {
        return new AnimatedTextureIcon(texture, new SpriteSheetMetadata(textureSize, 16), frameDelay, loop);
    }

    @ApiStatus.Internal
    public static class ItemIcon
    implements Icon {
        private final class_1799 stack;

        private ItemIcon(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
            context.method_51445(this.stack, x, y);
        }
    }

    @ApiStatus.Internal
    public static class TextureIcon
    implements Icon {
        private final class_2960 texture;
        private final int u;
        private final int v;
        private final int textureWidth;
        private final int textureHeight;

        public TextureIcon(class_2960 texture, int u, int v, int textureWidth, int textureHeight) {
            this.texture = texture;
            this.u = u;
            this.v = v;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }

        @Override
        public void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
            context.method_25290(this.texture, x, y, (float)this.u, (float)this.v, 16, 16, this.textureWidth, this.textureHeight);
        }
    }

    @ApiStatus.Internal
    public static class AnimatedTextureIcon
    implements Icon {
        private final AnimatedTextureDrawable widget;

        public AnimatedTextureIcon(class_2960 texture, SpriteSheetMetadata spriteSheetMetadata, int frameDelay, boolean loop) {
            this.widget = new AnimatedTextureDrawable(0, 0, 16, 16, texture, spriteSheetMetadata, frameDelay, loop);
        }

        @Override
        public void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
            this.widget.render(x, y, context, mouseX, mouseY, delta);
        }
    }
}

