/*
 * Decompiled with CFR 0.152.
 */
package com.asasinmode.wheelbarrow.render;

import com.asasinmode.wheelbarrow.entity.custom.WheelbarrowEntity;
import com.asasinmode.wheelbarrow.model.WheelbarrowEntityModel;
import com.google.common.collect.Maps;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public class WheelbarrowEntityRenderer
extends class_897<WheelbarrowEntity> {
    private static final Map<WheelbarrowEntity.Type, class_2960> OXIDATION_LEVEL_TO_TEXTURE = (Map)class_156.method_654((Object)Maps.newEnumMap(WheelbarrowEntity.Type.class), map -> {
        map.put(WheelbarrowEntity.Type.COPPER, new class_2960("wheelbarrow", "textures/entity/copper_wheelbarrow.png"));
        map.put(WheelbarrowEntity.Type.EXPOSED, new class_2960("wheelbarrow", "textures/entity/exposed_copper_wheelbarrow.png"));
        map.put(WheelbarrowEntity.Type.WEATHERED, new class_2960("wheelbarrow", "textures/entity/weathered_copper_wheelbarrow.png"));
        map.put(WheelbarrowEntity.Type.OXIDIZED, new class_2960("wheelbarrow", "textures/entity/oxidized_copper_wheelbarrow.png"));
    });
    private final WheelbarrowEntityModel model;

    public WheelbarrowEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.7f;
        this.model = new WheelbarrowEntityModel(WheelbarrowEntityModel.getTexturedModelData().method_32109());
    }

    public class_2960 getTexture(WheelbarrowEntity entity) {
        return OXIDATION_LEVEL_TO_TEXTURE.get((Object)entity.getOxidationLevel());
    }

    public void render(WheelbarrowEntity entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light) {
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
        float damageWobbleTicks = (float)entity.getDamageWobbleTicks() - tickDelta;
        float damageWobbleStrength = entity.getDamageWobbleStrength() - tickDelta;
        if (damageWobbleStrength < 0.0f) {
            damageWobbleStrength = 0.0f;
        }
        if (damageWobbleTicks > 0.0f) {
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)damageWobbleTicks) * damageWobbleTicks * damageWobbleStrength / 15.0f * (float)entity.getDamageWobbleSide()));
        }
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrixStack.method_22904(0.0, -1.5, 0.0);
        float ageInTicks = this.getAnimationProgress(entity, tickDelta);
        float limbSwing = entity.limbAnimator.method_48572(tickDelta);
        float limbSwingAmount = entity.limbAnimator.method_48570(tickDelta);
        if (limbSwingAmount > 1.0f) {
            limbSwingAmount = 1.0f;
        }
        this.model.setAngles(entity, limbSwing, limbSwingAmount, ageInTicks, 0.0f, 0.0f);
        this.model.method_2828(matrixStack, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)this.getTexture(entity))), light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.method_22909();
        super.method_3936((class_1297)entity, yaw, tickDelta, matrixStack, vertexConsumers, light);
    }

    protected float getAnimationProgress(WheelbarrowEntity entity, float tickDelta) {
        return (float)entity.field_6012 + tickDelta;
    }
}

