/*
 * Decompiled with CFR 0.152.
 */
package com.asasinmode.wheelbarrow.entity.custom;

import com.asasinmode.wheelbarrow.Wheelbarrow;
import com.asasinmode.wheelbarrow.entity.ModEntities;
import com.asasinmode.wheelbarrow.item.ModItems;
import com.asasinmode.wheelbarrow.networking.InformYeetKeybindS2CPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1538;
import net.minecraft.class_1543;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1639;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2553;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4050;
import net.minecraft.class_4836;
import net.minecraft.class_5134;
import net.minecraft.class_5419;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8080;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class WheelbarrowEntity
extends class_1297 {
    private static final class_2940<Integer> OXIDATION_LEVEL = class_2945.method_12791(WheelbarrowEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_WAXED = class_2945.method_12791(WheelbarrowEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(WheelbarrowEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(WheelbarrowEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(WheelbarrowEntity.class, (class_2941)class_2943.field_13320);
    public final class_8080 limbAnimator = new class_8080();
    private int lerpTicks;
    private float velocityDecay;
    private double wheelbarrowYaw;
    private double wheelbarrowPitch;
    private double x;
    private double y;
    private double z;
    private float nearbySlipperiness;
    private Location location;
    private class_1309 prevControllingPassenger;
    private float prevYawVelocity;
    private float yawVelocity;
    private boolean pressingLeft;
    private boolean pressingRight;
    private boolean pressingForward;
    private boolean pressingBack;
    private boolean sprintingPressed;
    private class_1297 passengerBeingYeeted = null;
    private class_243 prevServerPos = class_243.field_1353;
    private Map<UUID, Integer> yeetedPlayersToPushImmuneTimestamps = new HashMap<UUID, Integer>();

    public WheelbarrowEntity(class_1299<? extends WheelbarrowEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected WheelbarrowEntity(class_1937 world, double x, double y, double z) {
        this(ModEntities.WHEELBARROW, world);
        this.method_5814(x, y, z);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.method_49477(0.5f);
    }

    protected void method_5693() {
        this.field_6011.method_12784(OXIDATION_LEVEL, (Object)Type.COPPER.ordinal());
        this.field_6011.method_12784(IS_WAXED, (Object)false);
        this.field_6011.method_12784(DAMAGE_WOBBLE_TICKS, (Object)0);
        this.field_6011.method_12784(DAMAGE_WOBBLE_SIDE, (Object)1);
        this.field_6011.method_12784(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10582("OxidationLevel", this.getOxidationLevel().asString());
        nbt.method_10556("IsWaxed", this.getIsWaxed());
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10573("OxidationLevel", 8)) {
            this.setOxidationLevel(Type.getType(nbt.method_10558("OxidationLevel")));
        }
        if (nbt.method_10545("IsWaxed")) {
            this.setIsWaxed(nbt.method_10577("IsWaxed"));
        }
    }

    public void setOxidationLevel(Type type) {
        this.field_6011.method_12778(OXIDATION_LEVEL, (Object)type.ordinal());
    }

    public void setOxidationLevel(int type) {
        this.field_6011.method_12778(OXIDATION_LEVEL, (Object)type);
    }

    public Type getOxidationLevel() {
        return Type.getType((Integer)this.field_6011.method_12789(OXIDATION_LEVEL));
    }

    public void setIsWaxed(boolean value) {
        this.field_6011.method_12778(IS_WAXED, (Object)value);
    }

    public boolean getIsWaxed() {
        return (Boolean)this.field_6011.method_12789(IS_WAXED);
    }

    public static WheelbarrowEntity create(Type type, class_3218 world, double x, double y, double z, class_1799 stack, class_1657 player) {
        WheelbarrowEntity wheelbarrowEntity = new WheelbarrowEntity((class_1937)world, x, y, z);
        wheelbarrowEntity.setOxidationLevel(type);
        class_1299.method_48009((class_3218)world, (class_1799)stack, (class_1657)player).accept(wheelbarrowEntity);
        return wheelbarrowEntity;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean isInCreative;
        if (this.method_37908().field_9236 || this.method_31481()) {
            return true;
        }
        if (this.method_5679(source) || source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) {
            return false;
        }
        this.method_5785();
        this.method_32875(class_5712.field_28736, source.method_5529());
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.method_5785();
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
        this.method_32875(class_5712.field_28736, source.method_5529());
        boolean bl = isInCreative = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_31549().field_7477;
        if (!(!isInCreative && this.getDamageWobbleStrength() > 40.0f || this.shouldAlwaysKill(source))) {
            if (isInCreative) {
                this.method_31472();
            }
        } else {
            this.killAndDropSelf();
        }
        return true;
    }

    boolean shouldAlwaysKill(class_1282 source) {
        return false;
    }

    public void killAndDropSelf() {
        this.method_5768();
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_1799 itemStack = new class_1799((class_1935)this.asItem());
            if (this.method_16914()) {
                itemStack.method_7977(this.method_5797());
            }
            this.method_5775(itemStack);
        }
    }

    public class_1792 asItem() {
        return switch (this.getOxidationLevel()) {
            case Type.COPPER -> ModItems.COPPER_WHEELBARROW;
            case Type.EXPOSED -> ModItems.EXPOSED_COPPER_WHEELBARROW;
            case Type.WEATHERED -> ModItems.WEATHERED_COPPER_WHEELBARROW;
            case Type.OXIDIZED -> ModItems.OXIDIZED_COPPER_WHEELBARROW;
            default -> ModItems.COPPER_WHEELBARROW;
        };
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (!this.method_37908().field_9236) {
            class_1799 itemStack = player.method_5998(hand);
            Type oxidationLevel = this.getOxidationLevel();
            boolean isWaxed = this.getIsWaxed();
            if (itemStack.method_31573(class_3489.field_42612)) {
                if (isWaxed) {
                    this.setIsWaxed(false);
                    this.method_37908().method_8396(null, this.method_24515(), class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
                    this.spawnParticles(class_2398.field_29643, (class_3218)this.method_37908());
                    return class_1269.field_5812;
                }
                if (oxidationLevel == Type.COPPER) {
                    return class_1269.field_21466;
                }
                this.setOxidationLevel(oxidationLevel.ordinal() - 1);
                itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                this.spawnParticles(class_2398.field_29645, (class_3218)this.method_37908());
                return class_1269.field_21466;
            }
            if (itemStack.method_31574(class_1802.field_20414)) {
                if (isWaxed) {
                    return class_1269.field_21466;
                }
                this.setIsWaxed(true);
                itemStack.method_7934(1);
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_29543, class_3419.field_15245, 1.0f, 1.0f);
                this.spawnParticles(class_2398.field_29642, (class_3218)this.method_37908());
                return class_1269.field_5812;
            }
            if (!player.method_5804((class_1297)this)) {
                return class_1269.field_5811;
            }
            if (this.method_5685().size() > 1 && this.method_5642() == player) {
                ServerPlayNetworking.send((class_3222)((class_3222)player), (FabricPacket)new InformYeetKeybindS2CPacket(PacketByteBufs.empty()));
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        Type oxidationLevel = this.getOxidationLevel();
        if (!this.getIsWaxed() && oxidationLevel != Type.COPPER) {
            this.setOxidationLevel(oxidationLevel.ordinal() - 1);
        }
    }

    public void method_5879(float yaw) {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean method_30949(class_1297 other) {
        return WheelbarrowEntity.canCollide(this, other);
    }

    public static boolean canCollide(class_1297 entity, class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !entity.method_5794(other);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    public void method_5697(class_1297 entity) {
        if (entity.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entity);
        }
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public class_2350 method_5755() {
        return this.method_5735();
    }

    protected class_2561 method_23315() {
        return class_2561.method_43471((String)this.asItem().method_7876());
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.asItem());
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < this.getMaxPassengers();
    }

    protected int getMaxPassengers() {
        return Wheelbarrow.CONFIG.getMaxPassengers() + 1;
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 entity = this.method_31483();
        return entity instanceof class_1309 ? (class_1309)entity : super.method_5642();
    }

    public void setInputs(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack, boolean sprinting, boolean jumping) {
        this.pressingLeft = pressingLeft;
        this.pressingRight = pressingRight;
        this.pressingForward = pressingForward;
        this.pressingBack = pressingBack;
        this.sprintingPressed = sprinting;
        if (!pressingForward) {
            this.method_5728(false);
        } else if (sprinting) {
            this.method_5728(true);
        }
    }

    private void steer() {
        float playerVelocityMultiplier;
        class_1309 class_13092 = this.method_5642();
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)class_13092;
        if (this.pressingLeft) {
            this.yawVelocity -= 1.5f;
            if (this.yawVelocity <= -5.0f) {
                this.yawVelocity = -5.0f;
            }
        }
        if (this.pressingRight) {
            this.yawVelocity += 1.5f;
            if (this.yawVelocity >= 5.0f) {
                this.yawVelocity = 5.0f;
            }
        }
        this.method_36456(this.method_36454() + this.yawVelocity);
        float velocity = 0.0f;
        if (this.pressingForward) {
            velocity = 0.07f;
        }
        if (this.pressingBack) {
            velocity = -0.07f;
        }
        if ((playerVelocityMultiplier = ((float)playerEntity.method_26825(class_5134.field_23719) - playerEntity.method_31549().method_7253()) * 3.0f + 1.0f) > 1.0f) {
            playerVelocityMultiplier += 0.195f;
        }
        this.method_5724(1.0f, new class_243(0.0, 0.0, (double)(velocity *= playerVelocityMultiplier)));
    }

    public boolean method_5624() {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_13092;
            return playerEntity.method_5624();
        }
        return super.method_5624();
    }

    public void method_5728(boolean sprinting) {
        for (class_1297 entity : this.method_5685()) {
            if (!(entity instanceof class_1657)) continue;
            class_1657 playerEntity = (class_1657)entity;
            playerEntity.method_5728(sprinting);
        }
        super.method_5728(sprinting);
    }

    protected void updateLimbs(float posDelta) {
        float speed = Math.min(posDelta * 2.0f, 1.0f);
        this.limbAnimator.method_48567(speed);
        this.limbAnimator.method_48568(speed, 1.0f);
    }

    public boolean canBeYoinked(class_1297 entity) {
        return (double)entity.method_17681() <= 1.4;
    }

    public void setDamageWobbleTicks(int damageWobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, (Object)damageWobbleTicks);
    }

    public void setDamageWobbleSide(int damageWobbleSide) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, (Object)damageWobbleSide);
    }

    public void setDamageWobbleStrength(float damageWobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(damageWobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    public void method_5773() {
        class_1309 controllingPassenger;
        boolean isServer;
        boolean bl = isServer = !this.method_37908().field_9236;
        if (this.field_6012 % 10 == 0) {
            this.yeetedPlayersToPushImmuneTimestamps.entrySet().removeIf(entry -> (Integer)entry.getValue() <= this.field_6012);
        }
        this.location = this.checkLocation();
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.method_5773();
        this.updatePositionAndRotation();
        if (this.method_5787()) {
            this.updateVelocity();
            this.steer();
            this.method_5784(class_1313.field_6308, this.method_18798());
        } else {
            this.method_18799(class_243.field_1353);
            this.prevServerPos = this.method_19538();
        }
        double yawRad = Math.toRadians(this.method_36454());
        double yawSin = Math.sin(yawRad);
        double yawCos = Math.cos(yawRad);
        double deltaX = this.method_23317() - this.field_6014;
        double deltaZ = this.method_23321() - this.field_5969;
        double movementX = deltaX * yawCos + deltaZ * yawSin;
        double movementZ = -deltaX * yawSin + deltaZ * yawCos;
        int direction = Math.atan2(movementZ, movementX) >= 0.0 ? 1 : -1;
        float posDelta = (float)class_3532.method_39241((double)deltaX, (double)deltaZ);
        this.updateLimbs(posDelta * (float)direction);
        this.method_5852();
        this.prevControllingPassenger = controllingPassenger = this.method_5642();
        boolean isControlledByPlayer = controllingPassenger instanceof class_1657;
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009(0.2, 0.1, 0.2), entity -> !entity.method_5626((class_1297)this) && !this.method_5626((class_1297)entity) && class_1301.method_5911((class_1297)this).test(entity));
        for (class_1297 entity2 : list) {
            boolean canYoink;
            boolean bl2 = canYoink = isServer && isControlledByPlayer && this.method_5685().size() < this.getMaxPassengers() && !entity2.method_5765() && entity2 instanceof class_1309 && !(entity2 instanceof class_1657) && this.canBeYoinked(entity2);
            if (canYoink) {
                if (!entity2.method_5804((class_1297)this)) continue;
                ServerPlayNetworking.send((class_3222)((class_3222)controllingPassenger), (FabricPacket)new InformYeetKeybindS2CPacket(PacketByteBufs.empty()));
                continue;
            }
            if (entity2 instanceof class_1657 && this.yeetedPlayersToPushImmuneTimestamps.getOrDefault(entity2.method_5667(), Integer.MIN_VALUE) >= this.field_6012) continue;
            this.method_5697(entity2);
        }
        Type oxidationLevel = this.getOxidationLevel();
        if (isServer && oxidationLevel != Type.OXIDIZED && !this.getIsWaxed()) {
            int randomTickSpeed = this.method_37908().method_8450().method_8356(class_1928.field_19399);
            class_5819 random = this.method_37908().method_8409();
            if (random.method_43057() < 1.39E-5f * (float)randomTickSpeed) {
                this.setOxidationLevel(oxidationLevel.ordinal() + 1);
            }
        }
    }

    private void updatePositionAndRotation() {
        if (this.method_5787()) {
            this.lerpTicks = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.lerpTicks > 0) {
            this.lerpPosAndRotation(this.lerpTicks, this.x, this.y, this.z, this.wheelbarrowYaw, this.wheelbarrowPitch);
            --this.lerpTicks;
        }
    }

    protected void lerpPosAndRotation(int step, double x, double y, double z, double yaw, double pitch) {
        double var12 = 1.0 / (double)step;
        double var14 = class_3532.method_16436((double)var12, (double)this.method_23317(), (double)x);
        double var16 = class_3532.method_16436((double)var12, (double)this.method_23318(), (double)y);
        double var18 = class_3532.method_16436((double)var12, (double)this.method_23321(), (double)z);
        float var20 = class_3532.method_17821((float)((float)var12), (float)this.method_36454(), (float)((float)yaw));
        float var21 = (float)class_3532.method_16436((double)var12, (double)this.method_36455(), (double)pitch);
        this.method_5814(var14, var16, var18);
        this.method_5710(var20, var21);
    }

    public void updateTrackedPositionAndAngles(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.wheelbarrowYaw = yaw;
        this.wheelbarrowPitch = pitch;
        this.lerpTicks = 10;
    }

    public double getLerpTargetX() {
        return this.lerpTicks > 0 ? this.x : this.method_23317();
    }

    public double getLerpTargetY() {
        return this.lerpTicks > 0 ? this.y : this.method_23318();
    }

    public double getLerpTargetZ() {
        return this.lerpTicks > 0 ? this.z : this.method_23321();
    }

    public float getLerpTargetPitch() {
        return this.lerpTicks > 0 ? (float)this.wheelbarrowPitch : this.method_36455();
    }

    public float getLerpTargetYaw() {
        return this.lerpTicks > 0 ? (float)this.wheelbarrowYaw : this.method_36454();
    }

    public float getPrevYawVelocity() {
        return this.prevYawVelocity;
    }

    public float getYawVelocity() {
        return this.yawVelocity;
    }

    private void updateVelocity() {
        double yMulitplier = 1.0;
        double yMod = this.method_5740() ? 0.0 : -0.04;
        this.velocityDecay = 0.05f;
        if (this.location == Location.UNDER_FLOWING_WATER) {
            yMod = -0.03;
            this.velocityDecay = 0.3f;
        } else if (this.location == Location.UNDER_WATER) {
            this.velocityDecay = 0.3f;
            yMulitplier = 0.8;
        } else if (this.location == Location.IN_AIR) {
            this.velocityDecay = 0.5f;
        } else if (this.location == Location.ON_LAND) {
            this.velocityDecay = this.nearbySlipperiness;
            if (this.method_5642() instanceof class_1657) {
                this.nearbySlipperiness /= 2.0f;
            }
        }
        class_243 velocity = this.method_18798();
        double y = (velocity.field_1351 + yMod) * yMulitplier;
        if (y < -1.0) {
            y = -1.0;
        }
        this.prevYawVelocity = this.yawVelocity;
        this.yawVelocity = (float)((double)this.yawVelocity * 0.6);
        this.method_18800(velocity.field_1352 * (double)this.velocityDecay, y, velocity.field_1350 * (double)this.velocityDecay);
        double velocityLength = this.method_18798().method_37267();
        if (velocityLength <= 0.07 && this.method_5624() && !this.sprintingPressed) {
            this.method_5728(false);
        }
    }

    private Location checkLocation() {
        Location location = this.getUnderWaterLocation();
        if (location != null) {
            return location;
        }
        float slipperiness = this.getNearbySlipperiness();
        if (slipperiness > 0.0f) {
            this.nearbySlipperiness = slipperiness;
            return Location.ON_LAND;
        }
        return Location.IN_AIR;
    }

    public float getNearbySlipperiness() {
        class_238 box = this.method_5829();
        class_238 box2 = new class_238(box.field_1323, box.field_1322 - 0.001, box.field_1321, box.field_1320, box.field_1322, box.field_1324);
        int i = class_3532.method_15357((double)box2.field_1323) - 1;
        int j = class_3532.method_15384((double)box2.field_1320) + 1;
        int k = class_3532.method_15357((double)box2.field_1322) - 1;
        int l = class_3532.method_15384((double)box2.field_1325) + 1;
        int m = class_3532.method_15357((double)box2.field_1321) - 1;
        int n = class_3532.method_15384((double)box2.field_1324) + 1;
        class_265 voxelShape = class_259.method_1078((class_238)box2);
        float f = 0.0f;
        int o = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int p = i; p < j; ++p) {
            for (int q = m; q < n; ++q) {
                int r = (p != i && p != j - 1 ? 0 : 1) + (q != m && q != n - 1 ? 0 : 1);
                if (r == 2) continue;
                for (int s = k; s < l; ++s) {
                    if (r > 0 && (s == k || s == l - 1)) continue;
                    mutable.method_10103(p, s, q);
                    class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
                    if (blockState.method_26204() instanceof class_2553 || !class_259.method_1074((class_265)blockState.method_26220((class_1922)this.method_37908(), (class_2338)mutable).method_1096((double)p, (double)s, (double)q), (class_265)voxelShape, (class_247)class_247.field_16896)) continue;
                    f += blockState.method_26204().method_9499();
                    ++o;
                }
            }
        }
        return f / (float)o;
    }

    @Nullable
    private Location getUnderWaterLocation() {
        class_238 box = this.method_5829();
        double d = box.field_1325 + 0.001;
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)d);
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean isUnderWater = false;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (!fluidState.method_15767(class_3486.field_15517) || !(d < (double)((float)mutable.method_10264() + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable)))) continue;
                    if (!fluidState.method_15771()) {
                        return Location.UNDER_FLOWING_WATER;
                    }
                    isUnderWater = true;
                }
            }
        }
        return isUnderWater ? Location.UNDER_WATER : null;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        if (this.method_5765()) {
            return;
        }
        if (onGround) {
            this.method_38785();
        } else if (!this.method_37908().method_8316(this.method_24515().method_10074()).method_15767(class_3486.field_15517) && heightDifference < 0.0) {
            this.field_6017 -= (float)heightDifference;
        }
    }

    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
        class_1309 controllingPassenger = this.method_5642();
        boolean isControlledByPlayer = controllingPassenger instanceof class_1657;
        this.method_49477(isControlledByPlayer ? 1.0f : 0.5f);
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        this.method_49477(this.method_5642() instanceof class_1657 ? 1.0f : 0.5f);
    }

    protected void getPassengerAttachmentPos(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        List passengers;
        int index;
        float zOffset = -0.8f;
        float yOffset = 0.0f;
        boolean isControllingPassenger = passenger == this.method_5642();
        boolean isPlayer = passenger instanceof class_1657;
        if (isControllingPassenger && isPlayer || !isPlayer && this.method_5685().indexOf(passenger) > 1) {
            passenger.method_18380(class_4050.field_18076);
        } else {
            passenger.method_18380(class_4050.field_40118);
        }
        if (!isControllingPassenger || !isPlayer) {
            zOffset = 0.2f;
            yOffset = 0.4f + this.getRidingOffset(passenger);
            zOffset += Math.max((passenger.method_17681() - 1.0f) / 2.0f, 0.0f);
        }
        if ((index = (passengers = this.method_5685()).indexOf(passenger)) != 0) {
            int offset = this.method_5642() instanceof class_1657 ? 1 : 0;
            for (class_1297 entity : passengers.subList(offset, index)) {
                yOffset += entity.method_17682() + this.getRidingOffset(entity);
            }
        }
        class_243 offset = new class_243(0.0, (double)yOffset, (double)zOffset).method_1024(-this.method_36454() * ((float)Math.PI / 180));
        positionUpdater.accept(passenger, this.method_23317() + offset.field_1352, this.method_23318() + offset.field_1351, this.method_23321() + offset.field_1350);
    }

    protected float getRidingOffset(class_1297 entity) {
        if (entity instanceof class_1657) {
            return -0.6f;
        }
        if (entity instanceof class_1641) {
            class_1641 zombieVillagerEntity = (class_1641)entity;
            return zombieVillagerEntity.method_6109() ? 0.0f : -0.4f;
        }
        if (entity instanceof class_1642) {
            class_1642 zombieEntity = (class_1642)entity;
            return zombieEntity.method_6109() ? -0.1f : -0.5f;
        }
        if (entity instanceof class_1613 || entity instanceof class_1627) {
            return -0.65f;
        }
        if (entity instanceof class_1639) {
            return -0.75f;
        }
        if (entity instanceof class_4836) {
            class_4836 piglinEntity = (class_4836)entity;
            return piglinEntity.method_6109() ? -0.2f : -0.5f;
        }
        if (entity instanceof class_5419) {
            return -0.6f;
        }
        if (entity instanceof class_1543) {
            return -0.6f;
        }
        return 0.0f;
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        this.getPassengerAttachmentPos(passenger, positionUpdater);
        boolean isControllingPassenger = passenger == this.method_5642();
        boolean isPlayer = passenger instanceof class_1657;
        if (isControllingPassenger && isPlayer) {
            passenger.method_18380(class_4050.field_18076);
        } else {
            passenger.method_18380(class_4050.field_40118);
        }
        passenger.method_36456(passenger.method_36454() + this.yawVelocity);
        passenger.method_5847(passenger.method_5791() + this.yawVelocity);
        this.clampPassengerYaw(passenger);
    }

    protected void clampPassengerYaw(class_1297 passenger) {
        if (passenger != this.method_5642() || !(passenger instanceof class_1657)) {
            return;
        }
        passenger.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(passenger.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        passenger.field_5982 += g - f;
        passenger.method_36456(passenger.method_36454() + g - f);
        passenger.method_5847(passenger.method_36454());
    }

    public void method_5644(class_1297 passenger) {
        this.clampPassengerYaw(passenger);
    }

    public class_243 method_24829(class_1309 passenger) {
        double dismountYOffset;
        class_2338 blockPos;
        double z;
        double x;
        if (this.passengerBeingYeeted == passenger) {
            this.passengerBeingYeeted = null;
            float offset = 0.15f + passenger.method_17681() * 0.1f;
            double yawRad = Math.toRadians(this.method_36454());
            double yawSin = -Math.sin(yawRad);
            double yawCos = Math.cos(yawRad);
            double largerSinCos = Math.max(Math.abs(yawSin), Math.abs(yawCos));
            double x2 = yawSin * (double)offset / largerSinCos;
            double y = 0.3;
            double z2 = yawCos * (double)offset / largerSinCos;
            class_243 currentVelocity = this.method_19538().method_1020(this.prevServerPos);
            double length = currentVelocity.method_1033();
            if (length >= 0.3) {
                y += length * 0.2;
            }
            passenger.method_18799(currentVelocity.method_1021(1.5).method_1031(x2, y, z2));
            passenger.field_6037 = true;
            if (passenger instanceof class_1657) {
                this.yeetedPlayersToPushImmuneTimestamps.put(passenger.method_5667(), this.field_6012 + 40);
            }
            return passenger.method_19538().method_1019(currentVelocity);
        }
        if (passenger == this.prevControllingPassenger) {
            float offset = -0.6f;
            double yawRad = Math.toRadians(this.method_36454());
            double yawSin = -Math.sin(yawRad);
            double yawCos = Math.cos(yawRad);
            double largerSinCos = Math.max(Math.abs(yawSin), Math.abs(yawCos));
            x = passenger.method_23317() + yawSin * (double)offset / largerSinCos;
            z = passenger.method_23321() + yawCos * (double)offset / largerSinCos;
            blockPos = class_2338.method_49637((double)x, (double)this.method_23318(), (double)z);
            dismountYOffset = Math.max(0.0, this.method_37908().method_30347(blockPos));
        } else {
            class_243 offsetVec = WheelbarrowEntity.method_24826((double)(this.method_17681() * class_3532.field_15724), (double)passenger.method_17681(), (float)passenger.method_36454());
            x = this.method_23317() + offsetVec.field_1352;
            z = this.method_23321() + offsetVec.field_1350;
            blockPos = class_2338.method_49637((double)x, (double)this.method_5829().field_1325, (double)z);
            dismountYOffset = this.method_37908().method_30347(blockPos);
        }
        return new class_243(x, (double)blockPos.method_10264() + dismountYOffset, z);
    }

    public void method_5700(boolean drag) {
    }

    private void spawnParticles(class_2400 particleType, class_3218 world) {
        double particleZ;
        double particleY;
        double particleX;
        int i;
        double yawRad = Math.toRadians(this.method_36454());
        double yawSin = Math.sin(yawRad);
        double yawCos = Math.cos(yawRad);
        for (i = 0; i < 6; ++i) {
            particleX = this.field_5974.method_43058() * 0.4 * (double)(this.field_5974.method_43056() ? 1 : -1);
            particleY = this.field_5974.method_43058() * 0.3125 * (double)(this.field_5974.method_43056() ? 1 : -1);
            particleZ = 0.2 + this.field_5974.method_43058() * 0.5 * (double)(this.field_5974.method_43056() ? 1 : -1);
            this.spawnParticle(world, particleType, particleX, particleY, particleZ, yawSin, yawCos);
        }
        for (i = 0; i < 8; ++i) {
            particleX = 0.5;
            particleY = this.field_5974.method_43058() * 0.3125 * (double)(this.field_5974.method_43056() ? 1 : -1);
            particleZ = 0.2 + this.field_5974.method_43058() * 0.625 * (double)(this.field_5974.method_43056() ? 1 : -1);
            this.spawnParticle(world, particleType, particleX, particleY, particleZ, yawSin, yawCos);
        }
        for (i = 0; i < 8; ++i) {
            particleX = -0.5;
            particleY = this.field_5974.method_43058() * 0.3125 * (double)(this.field_5974.method_43056() ? 1 : -1);
            particleZ = 0.2 + this.field_5974.method_43058() * 0.625 * (double)(this.field_5974.method_43056() ? 1 : -1);
            this.spawnParticle(world, particleType, particleX, particleY, particleZ, yawSin, yawCos);
        }
        for (i = 0; i < 4; ++i) {
            particleX = this.field_5974.method_43058() * 0.5 * (double)(this.field_5974.method_43056() ? 1 : -1);
            particleY = this.field_5974.method_43058() * 0.3125 * (double)(this.field_5974.method_43056() ? 1 : -1);
            particleZ = -0.55;
            this.spawnParticle(world, particleType, particleX, particleY, particleZ, yawSin, yawCos);
        }
        for (i = 0; i < 4; ++i) {
            particleX = this.field_5974.method_43058() * 0.5 * (double)(this.field_5974.method_43056() ? 1 : -1);
            particleY = this.field_5974.method_43058() * 0.3125 * (double)(this.field_5974.method_43056() ? 1 : -1);
            particleZ = 0.8;
            this.spawnParticle(world, particleType, particleX, particleY, particleZ, yawSin, yawCos);
        }
    }

    private void spawnParticle(class_3218 world, class_2400 particleType, double x, double y, double z, double yawSin, double yawCos) {
        world.method_14199((class_2394)particleType, this.method_23317() + x * yawCos - z * yawSin, this.method_23318() + 0.55 + y, this.method_23321() + z * yawCos + x * yawSin, 1, this.field_5974.method_43058() / 10.0 * (double)(this.field_5974.method_43056() ? 1 : -1), this.field_5974.method_43058() / 10.0 * (double)(this.field_5974.method_43056() ? 1 : -1), this.field_5974.method_43058() / 10.0 * (double)(this.field_5974.method_43056() ? 1 : -1), this.field_5974.method_43058() * 0.5);
    }

    public void yeetLastPassenger() {
        class_1297 passenger;
        List passengers = this.method_5685();
        if (passengers.size() <= 1) {
            return;
        }
        this.passengerBeingYeeted = passenger = (class_1297)passengers.get(passengers.size() - 1);
        passenger.method_5848();
    }

    public static enum Type {
        COPPER("copper"),
        EXPOSED("exposed"),
        WEATHERED("weathered"),
        OXIDIZED("oxidized");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String asString() {
            return this.type;
        }

        public static Type getType(String value) {
            for (Type enumConstant : Type.values()) {
                if (!enumConstant.asString().equals(value)) continue;
                return enumConstant;
            }
            throw new IllegalArgumentException("No enum constant with value: " + value);
        }

        public static Type getType(int ordinal) {
            if (ordinal >= 0 && ordinal < Type.values().length) {
                return Type.values()[ordinal];
            }
            throw new IllegalArgumentException("No enum constant with ordinal value: " + ordinal);
        }
    }

    static enum Location {
        ON_LAND,
        IN_AIR,
        UNDER_WATER,
        UNDER_FLOWING_WATER;

    }
}

