/*
 * Decompiled with CFR 0.152.
 */
package com.asasinmode.wheelbarrow;

import com.asasinmode.wheelbarrow.Wheelbarrow;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "wheelbarrow.json");
    private int maxPassengers = 1;

    public static Config load() {
        Config config = new Config();
        if (!CONFIG_FILE.exists()) {
            Config.save(config);
        }
        try {
            BufferedReader reader = Files.newBufferedReader(CONFIG_FILE.toPath());
            config = (Config)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, Config.class);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            Wheelbarrow.LOGGER.error("Failed to load the configuration file. Default configuration used.", (Throwable)e);
        }
        return config;
    }

    public static void save(Config config) {
        try {
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE.toPath(), new OpenOption[0]);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)config, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            Wheelbarrow.LOGGER.error("Failed to save configuration file.", (Throwable)e);
        }
    }

    public int getMaxPassengers() {
        return this.maxPassengers;
    }

    public void setMaxPassengers(int value) {
        this.maxPassengers = Math.min(Integer.MAX_VALUE, Math.max(0, value));
    }
}

