/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.common.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.orcinus.overweightfarming.OFConfig;
import net.orcinus.overweightfarming.common.blocks.CropFullBlock;
import net.orcinus.overweightfarming.common.blocks.OverweightCarrotBlock;
import net.orcinus.overweightfarming.common.registry.OFObjects;
import net.orcinus.overweightfarming.common.registry.OFTags;
import net.orcinus.overweightfarming.common.util.OverweightType;
import org.jetbrains.annotations.Nullable;

public record OverweightGrowthManager(class_5819 random) {
    public Map<class_2248, Pair<Pair<Boolean, OverweightType>, class_2248>> getOverweightMap() {
        return (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
            map.put(class_2246.field_10609, Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightCarrot, (Object)((Object)OverweightType.SPROUT)), (Object)OFObjects.OVERWEIGHT_CARROT));
            map.put(class_2246.field_10247, Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightPotato, (Object)((Object)OverweightType.DEFAULT)), (Object)OFObjects.OVERWEIGHT_POTATO));
            map.put(class_2246.field_10341, Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightBeetroot, (Object)((Object)OverweightType.DEFAULT)), (Object)OFObjects.OVERWEIGHT_BEETROOT));
            map.put(class_2246.field_10302, Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightCocoa, (Object)((Object)OverweightType.SIMPLE)), (Object)OFObjects.OVERWEIGHT_COCOA));
            map.put(class_2246.field_9974, Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightNetherWart, (Object)((Object)OverweightType.INVERTED)), (Object)OFObjects.OVERWEIGHT_NETHER_WART));
            map.put(this.getCompatBlock("farmersdelight", "cabbages"), Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightCabbage, (Object)((Object)OverweightType.SIMPLE)), (Object)OFObjects.OVERWEIGHT_CABBAGE));
            map.put(this.getCompatBlock("farmersdelight", "onions"), Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightOnion, (Object)((Object)OverweightType.DEFAULT)), (Object)OFObjects.OVERWEIGHT_ONION));
            map.put(this.getCompatBlock("bewitchment", "mandrake"), Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightMandrake, (Object)((Object)OverweightType.DEFAULT)), (Object)OFObjects.OVERWEIGHT_MANDRAKE));
            map.put(this.getCompatBlock("bewitchment", "garlic"), Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightGarlic, (Object)((Object)OverweightType.DEFAULT)), (Object)OFObjects.OVERWEIGHT_GARLIC));
            map.put(this.getCompatBlock("immersive_weathering", "weeds"), Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightWeeds, (Object)((Object)OverweightType.SIMPLE)), (Object)OFObjects.OVERWEIGHT_WEED));
            map.put(this.getCompatBlock("hedgehog", "kiwi_vines"), Pair.of((Object)Pair.of((Object)OFConfig.allowOverweightKiwi, (Object)((Object)OverweightType.DEFAULT)), (Object)OFObjects.OVERWEIGHT_KIWI));
        });
    }

    public void growOverweightCrops(class_3218 serverLevel, class_2338 blockPos, class_2680 state, class_5819 random) {
        for (class_2248 block : this.getOverweightMap().keySet()) {
            class_2680 class_26802;
            if (!state.method_27852(block)) continue;
            if (!this.isNearOvergrowthObstacles(serverLevel, blockPos)) {
                return;
            }
            Pair<Pair<Boolean, OverweightType>, class_2248> pair = this.getOverweightMap().get(block);
            Pair firstPair = (Pair)pair.getFirst();
            Boolean configValue = (Boolean)firstPair.getFirst();
            if (!configValue.booleanValue()) {
                return;
            }
            OverweightType overweightType = (OverweightType)((Object)firstPair.getSecond());
            class_2248 overweightBlock = (class_2248)pair.getSecond();
            if (!(overweightBlock instanceof CropFullBlock)) continue;
            CropFullBlock cropFullBlock = (CropFullBlock)overweightBlock;
            if (cropFullBlock instanceof OverweightCarrotBlock) {
                OverweightCarrotBlock carrotBlock = (OverweightCarrotBlock)cropFullBlock;
                class_26802 = (class_2680)carrotBlock.method_9564().method_11657((class_2769)OverweightCarrotBlock.FACING, (Comparable)class_2350.field_11036);
            } else {
                class_26802 = cropFullBlock.method_9564();
            }
            class_2680 overweightState = class_26802;
            class_2248 stemBlock = cropFullBlock.getStemBlock();
            class_2680 stemState = null;
            if (stemBlock != null) {
                stemState = stemBlock.method_9564();
            }
            switch (overweightType) {
                case DEFAULT: {
                    this.simpleOverweightGrowth(serverLevel, blockPos, overweightState, stemState);
                    break;
                }
                case SIMPLE: {
                    this.setBlock(serverLevel, blockPos, overweightState);
                    break;
                }
                case SPROUT: {
                    this.sproutGrowth(serverLevel, blockPos, random, overweightState, stemState);
                    break;
                }
                case INVERTED: {
                    this.invertedGrowth(serverLevel, blockPos, overweightState, stemState);
                }
            }
        }
    }

    private void invertedGrowth(class_3218 world, class_2338 blockPos, class_2680 overweightState, class_2680 stemState) {
        if (!world.method_16358(blockPos.method_10084(), class_5726::method_33014)) {
            return;
        }
        this.setBlock(world, blockPos.method_10084(), overweightState);
        this.setBlock(world, blockPos, stemState);
    }

    @Nullable
    public class_2248 getCompatBlock(String modid, String name) {
        return (class_2248)class_7923.field_41175.method_10223(new class_2960(modid, name));
    }

    private void simpleOverweightGrowth(class_3218 world, class_2338 blockPos, class_2680 overweightCrop, class_2680 stemBlock) {
        this.setBlock(world, blockPos, overweightCrop);
        if (stemBlock != null) {
            if (stemBlock.method_26204() instanceof class_2320) {
                boolean flag;
                boolean bl = flag = world.method_22347(blockPos.method_10084()) && world.method_22347(blockPos.method_10086(2));
                if (!flag) {
                    return;
                }
                class_2320.method_10021((class_1936)world, (class_2680)stemBlock.method_26204().method_9564(), (class_2338)blockPos.method_10084(), (int)2);
            } else {
                this.setBlock(world, blockPos.method_10084(), stemBlock);
            }
        }
    }

    private void sproutGrowth(class_3218 world, class_2338 blockPos, class_5819 random, class_2680 blockState, class_2680 stemState) {
        int height = random.method_43056() && random.method_43048(5) == 0 ? (random.method_43056() && random.method_43048(10) == 0 ? 4 : 3) : 2;
        class_2338 startPos = blockPos.method_10084();
        class_2338.class_2339 mutableBlockPos = startPos.method_25503();
        for (int i = 0; i < height; ++i) {
            class_2680 placeState = blockState;
            if (i == 0 && stemState != null) {
                placeState = stemState;
            }
            this.setBlock(world, (class_2338)mutableBlockPos, placeState);
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
    }

    public void setBlock(class_3218 world, class_2338 blockPos, class_2680 overweightState) {
        for (class_2248 cropBlock : this.getOverweightMap().keySet()) {
            class_2680 state = world.method_8320(blockPos);
            if (!state.method_26215() && state.method_26204() != cropBlock && !state.method_27852(class_2246.field_10362) && !state.method_27852(class_2246.field_10566)) continue;
            world.method_8652(blockPos, overweightState, 2);
        }
    }

    private boolean isNearOvergrowthObstacles(class_3218 world, class_2338 blockPos) {
        boolean flag = true;
        int radius = 10;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                class_2338 pos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264(), blockPos.method_10260() + z);
                class_2680 state = world.method_8320(pos);
                if (!state.method_26164(OFTags.OVERWEIGHT_OBSTACLES) || !state.method_26164(OFTags.OVERWEIGHT_OBSTACLES)) continue;
                flag = false;
            }
        }
        return flag;
    }
}

