/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.feature.world_ambience;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charmonium.feature.world_ambience.sounds.Alien;
import svenhjol.charmonium.feature.world_ambience.sounds.Bleak;
import svenhjol.charmonium.feature.world_ambience.sounds.CaveDepth;
import svenhjol.charmonium.feature.world_ambience.sounds.CaveDrone;
import svenhjol.charmonium.feature.world_ambience.sounds.Deepslate;
import svenhjol.charmonium.feature.world_ambience.sounds.Dry;
import svenhjol.charmonium.feature.world_ambience.sounds.Geode;
import svenhjol.charmonium.feature.world_ambience.sounds.Gravel;
import svenhjol.charmonium.feature.world_ambience.sounds.High;
import svenhjol.charmonium.feature.world_ambience.sounds.Mansion;
import svenhjol.charmonium.feature.world_ambience.sounds.Mineshaft;
import svenhjol.charmonium.feature.world_ambience.sounds.NightPlains;
import svenhjol.charmonium.feature.world_ambience.sounds.Snowstorm;
import svenhjol.charmonium.feature.world_ambience.sounds.UndergroundWater;
import svenhjol.charmonium.feature.world_ambience.sounds.Village;
import svenhjol.charmonium.sound.ISoundType;
import svenhjol.charmonium.sound.SoundHandler;
import svenhjol.charmonium.sound.WorldSound;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.client.ClientFeature;
import svenhjol.charmony_api.event.ClientEntityJoinEvent;
import svenhjol.charmony_api.event.ClientEntityLeaveEvent;
import svenhjol.charmony_api.event.ClientTickEvent;

public class WorldAmbience
extends ClientFeature {
    public static final List<class_2960> VALID_CAVE_DIMENSIONS = new ArrayList<class_2960>();
    private static final ISoundType<WorldSound> ALIEN = new Alien();
    private static final ISoundType<WorldSound> BLEAK = new Bleak();
    private static final ISoundType<WorldSound> CAVE_DRONE = new CaveDrone();
    private static final ISoundType<WorldSound> CAVE_DEPTH = new CaveDepth();
    private static final ISoundType<WorldSound> DEEPSLATE = new Deepslate();
    private static final ISoundType<WorldSound> DRY = new Dry();
    private static final ISoundType<WorldSound> GEODE = new Geode();
    private static final ISoundType<WorldSound> GRAVEL = new Gravel();
    private static final ISoundType<WorldSound> HIGH = new High();
    private static final ISoundType<WorldSound> MANSION = new Mansion();
    private static final ISoundType<WorldSound> MINESHAFT = new Mineshaft();
    private static final ISoundType<WorldSound> NIGHT_PLAINS = new NightPlains();
    private static final ISoundType<WorldSound> SNOWSTORM = new Snowstorm();
    private static final ISoundType<WorldSound> UNDERGROUND_WATER = new UndergroundWater();
    private static final ISoundType<WorldSound> VILLAGE = new Village();
    private Handler handler;
    @Configurable(name="Volume scaling", description="Affects the volume of all situational ambient sounds. 1.0 is full volume.", requireRestart=false)
    public static double volumeScaling = 0.55;
    @Configurable(name="Above ground for ambience silencing", description="Number of blocks above the ground that biome ambience will be silenced.\nSet to zero to disable.", requireRestart=false)
    public static int cullSoundAboveGround = 32;
    @Configurable(name="Alien", description="If true, plays ambient sounds while anywhere in the End.", requireRestart=false)
    public static boolean alien = true;
    @Configurable(name="Bleak", description="If true, plays ambient sounds in cold and/or barren overworld environments.", requireRestart=false)
    public static boolean bleak = true;
    @Configurable(name="Cave depth", description="If true, plays more intense cave sounds when below Y 0 and light level is lower than the cave light level.", requireRestart=false)
    public static boolean caveDepth = true;
    @Configurable(name="Cave drone", description="If true, plays a low drone sound when in a cave below the cave drone cutoff..", requireRestart=false)
    public static boolean caveDrone = true;
    @Configurable(name="Cave drone cutoff", description="Height at which the cave drone will be silenced.", requireRestart=false)
    public static int caveDroneCutoff = 48;
    @Configurable(name="Cave light level", description="Light level at which cave ambience will be dampened.", requireRestart=false)
    public static int caveLightLevel = 10;
    @Configurable(name="Deepslate", description="If true, plays ambient sounds when the player is underground and near deepslate blocks.", requireRestart=false)
    public static boolean deepslate = true;
    @Configurable(name="Dry", description="If true, plays ambient sounds in dry and/or hot overworld environments.", requireRestart=false)
    public static boolean dry = true;
    @Configurable(name="Geode", description="If true, plays ambient sounds from a nearby amethyst geode.", requireRestart=false)
    public static boolean geode = true;
    @Configurable(name="Gravel", description="If true, plays ambient sounds when the player is underground and near gravel blocks.", requireRestart=false)
    public static boolean gravel = true;
    @Configurable(name="High", description="If true, plays ambient sounds when high up in the overworld.", requireRestart=false)
    public static boolean high = true;
    @Configurable(name="Mansion", description="If true, plays ambient sounds while inside a woodland mansion.", requireRestart=false)
    public static boolean mansion = true;
    @Configurable(name="Mineshaft", description="If true, plays ambient sounds from a nearby mineshaft.", requireRestart=false)
    public static boolean mineshaft = true;
    @Configurable(name="Night plains", description="If true, plays ambient sounds in plains environments at night.", requireRestart=false)
    public static boolean nightPlains = true;
    @Configurable(name="Snowstorm", description="If true, plays ambient sounds when in a cold biome during a thunderstorm.", requireRestart=false)
    public static boolean snowstorm = true;
    @Configurable(name="Underground water", description="If true, plays water sounds from a nearby water source when underground.", requireRestart=false)
    public static boolean undergroundWater = true;
    @Configurable(name="Village", description="If true, plays ambient sounds when a player is inside a village.", requireRestart=false)
    public static boolean village = true;
    @Configurable(name="Valid cave ambience dimensions", description="Dimensions in which cave ambience (drone and depth) will be played.", requireRestart=false)
    public static List<String> caveDimensions = List.of("minecraft:overworld");

    public String description() {
        return "Plays ambient sound according to features of the world around the player.";
    }

    public void runWhenEnabled() {
        ClientEntityJoinEvent.INSTANCE.handle(this::handleClientEntityJoin);
        ClientEntityLeaveEvent.INSTANCE.handle(this::handleClientEntityLeave);
        ClientTickEvent.INSTANCE.handle(this::handleClientTick);
        caveDimensions.forEach(dim -> VALID_CAVE_DIMENSIONS.add(new class_2960(dim)));
    }

    public static int getCaveLightLevel() {
        return Math.min(15, Math.max(0, caveLightLevel));
    }

    public static int getCaveDroneCutoff() {
        return Math.min(256, Math.max(-64, caveDroneCutoff));
    }

    public static void addCaveAmbienceToDimension(class_1937 level) {
        class_2960 dimension = level.method_27983().method_29177();
        if (!VALID_CAVE_DIMENSIONS.contains(dimension)) {
            VALID_CAVE_DIMENSIONS.add(dimension);
        }
    }

    private void handleClientTick(class_310 client) {
        if (this.handler != null && !client.method_1493()) {
            this.handler.tick();
        }
    }

    private void handleClientEntityLeave(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746 && this.handler != null) {
            this.handler.stop();
        }
    }

    private void handleClientEntityJoin(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746) {
            class_746 player = (class_746)entity;
            this.trySetupSoundHandler((class_1657)player);
        }
    }

    private void trySetupSoundHandler(class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        this.handler = new Handler(player);
        this.handler.updatePlayer(player);
    }

    public static class Handler
    extends SoundHandler<WorldSound> {
        public Handler(@NotNull class_1657 player) {
            super(player);
            ALIEN.addSounds(this);
            BLEAK.addSounds(this);
            CAVE_DRONE.addSounds(this);
            CAVE_DEPTH.addSounds(this);
            DEEPSLATE.addSounds(this);
            DRY.addSounds(this);
            GEODE.addSounds(this);
            GRAVEL.addSounds(this);
            HIGH.addSounds(this);
            MANSION.addSounds(this);
            MINESHAFT.addSounds(this);
            NIGHT_PLAINS.addSounds(this);
            SNOWSTORM.addSounds(this);
            UNDERGROUND_WATER.addSounds(this);
            VILLAGE.addSounds(this);
        }
    }
}

