/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.phys.shapes;

import com.google.common.collect.Lists;
import fuzs.spikyspikes.mixin.accessor.VoxelShapeAccessor;
import fuzs.spikyspikes.world.phys.shapes.ExtensibleVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class CustomOutlineShape
extends ExtensibleVoxelShape {
    private final class_265 collisionShape;
    private final class_265 outlineShapeBase;
    private final List<class_243[]> outlineShapeEdges;

    public CustomOutlineShape(class_265 collisionShape, class_243 ... outlineShapeEdges) {
        this(collisionShape, class_259.method_1073(), outlineShapeEdges);
    }

    public CustomOutlineShape(class_265 collisionShape, class_265 outlineShapeBase, class_243 ... outlineShapeEdges) {
        super(collisionShape);
        this.collisionShape = collisionShape;
        this.outlineShapeBase = outlineShapeBase;
        this.outlineShapeEdges = this.createOutlineList(outlineShapeEdges);
    }

    private List<class_243[]> createOutlineList(class_243[] outlineShapeEdges) {
        if (outlineShapeEdges.length % 2 != 0) {
            throw new IllegalStateException("Edges must be in groups of two points");
        }
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < outlineShapeEdges.length; i += 2) {
            list.add(new class_243[]{outlineShapeEdges[i], outlineShapeEdges[i + 1]});
        }
        return list;
    }

    @Override
    protected DoubleList method_1109(class_2350.class_2351 axis) {
        return ((VoxelShapeAccessor)this.collisionShape).spikyspikes$getCoords(axis);
    }

    public void method_1104(class_259.class_260 boxConsumer) {
        this.outlineShapeBase.method_1104(boxConsumer);
        for (class_243[] edge : this.outlineShapeEdges) {
            boxConsumer.consume(edge[0].field_1352, edge[0].field_1351, edge[0].field_1350, edge[1].field_1352, edge[1].field_1351, edge[1].field_1350);
        }
    }
}

