/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block.entity;

import com.google.common.collect.Maps;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.world.damagesource.LootingDamageSource;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1903;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class SpikeBlockEntity
extends class_2586 {
    public static final String ENCHANTMENTS_TAG = "Enchantments";
    public static final String REPAIR_COST_TAG = "RepairCost";
    private Map<class_1887, Integer> enchantments = Maps.newHashMap();
    private int repairCost;

    public SpikeBlockEntity(class_2338 p_155229_, class_2680 p_155230_) {
        super((class_2591)ModRegistry.SPIKE_BLOCK_ENTITY_TYPE.get(), p_155229_, p_155230_);
    }

    public static class_2499 serializeEnchantments(Map<class_1887, Integer> p_44866_) {
        class_2499 listtag = new class_2499();
        for (Map.Entry<class_1887, Integer> entry : p_44866_.entrySet()) {
            class_1887 enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            listtag.add((Object)class_1890.method_37426((class_2960)class_1890.method_37423((class_1887)enchantment), (int)i));
        }
        return listtag;
    }

    public static void attackPlayerLike(class_1937 level, class_2338 pos, class_2680 state, SpikeBlockEntity blockEntity, class_1309 entity, SpikeMaterial material) {
        SpikeBlockEntity.attackPlayerLike((class_1297)entity, material.damageAmount(), level, pos, (class_2350)state.method_11654((class_2769)SpikeBlock.FACING), blockEntity.enchantments, material.hurtsPlayers());
    }

    private static void attackPlayerLike(class_1297 target, float attackDamage, class_1937 level, class_2338 pos, class_2350 direction, Map<class_1887, Integer> enchantments, boolean hurtPlayers) {
        if (target.method_5732()) {
            class_1310 mobType = target instanceof class_1309 ? ((class_1309)target).method_6046() : class_1310.field_6290;
            float damageBonus = 0.0f;
            for (Map.Entry<class_1887, Integer> entry : enchantments.entrySet()) {
                damageBonus += entry.getKey().method_8196(entry.getValue().intValue(), mobType);
            }
            if (attackDamage > 0.0f || damageBonus > 0.0f) {
                attackDamage += damageBonus;
                int fireAspect = enchantments.getOrDefault(class_1893.field_9124, 0);
                boolean setOnFire = false;
                if (target instanceof class_1309 && fireAspect > 0 && !target.method_5809()) {
                    setOnFire = true;
                    target.method_5639(1);
                }
                int looting = enchantments.getOrDefault(class_1893.field_9110, 0);
                class_243 oldMovement = target.method_18798();
                if (SpikeBlockEntity.hurtPlayerLike(level, target, attackDamage, looting)) {
                    int sweeping;
                    target.method_18799(oldMovement);
                    int knockback = enchantments.getOrDefault(class_1893.field_9121, 0);
                    if (knockback > 0) {
                        SpikeBlockEntity.applyLivingKnockback(direction, target, (float)knockback * 0.5f, level.method_8409());
                    }
                    if ((sweeping = enchantments.getOrDefault(class_1893.field_9115, 0).intValue()) > 0) {
                        SpikeBlockEntity.applySweepingDamage(target, attackDamage, level, pos, direction, looting, knockback, sweeping, hurtPlayers);
                    }
                    if (damageBonus > 0.0f && level instanceof class_3218) {
                        ((class_3218)level).method_14178().method_18751(target, (class_2596)new class_2616(target, 5));
                    }
                    if (target instanceof class_1309 && fireAspect > 0) {
                        target.method_5639(fireAspect * 4);
                    }
                } else if (setOnFire) {
                    target.method_5646();
                }
            }
        }
    }

    private static boolean hurtPlayerLike(class_1937 level, class_1297 entity, float attackDamage, int looting) {
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_6015(null);
            mob.method_29505(null);
            mob.method_5980(null);
        }
        return entity.method_5643(LootingDamageSource.source((class_4538)level, ModRegistry.SPIKE_DAMAGE_TYPE, looting), attackDamage);
    }

    private static void applyLivingKnockback(class_2350 direction, class_1297 target, float strength, class_5819 random) {
        if (target instanceof class_1309) {
            strength = (float)((double)strength * (1.0 - ((class_1309)target).method_26825(class_5134.field_23718)));
        }
        if ((double)strength > 0.0) {
            class_243 deltaMovement = target.method_18798();
            class_243 normalVec = new class_243((double)direction.method_10163().method_10263(), (double)direction.method_10163().method_10264(), (double)direction.method_10163().method_10260());
            int axisStep = direction.method_10153().method_10171().method_10181();
            class_243 offsetVec = new class_243((double)axisStep, (double)axisStep, (double)axisStep).method_1019(normalVec).method_18805(random.method_43059(), random.method_43059(), random.method_43059());
            class_243 knockbackVec = normalVec.method_1019(offsetVec).method_1029().method_1021((double)strength);
            target.method_18800(deltaMovement.field_1352 / 2.0 + knockbackVec.field_1352, Math.min(0.4, deltaMovement.field_1351 / 2.0 + knockbackVec.field_1351), deltaMovement.field_1350 / 2.0 + knockbackVec.field_1350);
            target.field_6007 = true;
        }
    }

    private static void applySweepingDamage(class_1297 target, float attackDamage, class_1937 level, class_2338 pos, class_2350 direction, int looting, int knockback, int sweeping, boolean hurtPlayers) {
        float f3 = 1.0f + class_1903.method_8241((int)sweeping) * attackDamage;
        for (class_1309 livingentity : level.method_8390(class_1309.class, target.method_5829().method_1009(1.0, 0.25, 1.0), hurtPlayers ? class_1301.field_6155 : entity -> !(entity instanceof class_1657))) {
            if (livingentity == target || livingentity instanceof class_1531 && ((class_1531)livingentity).method_6912() || !(pos.method_19770((class_2374)livingentity.method_19538()) < 9.0)) continue;
            if (knockback > 0) {
                SpikeBlockEntity.applyLivingKnockback(direction, (class_1297)livingentity, 0.4f, level.method_8409());
            }
            livingentity.method_5643(LootingDamageSource.source((class_4538)level, ModRegistry.SPIKE_DAMAGE_TYPE, looting), f3);
        }
        if (level instanceof class_3218) {
            class_2338 offsetPos = pos.method_10093(direction);
            ((class_3218)level).method_14199((class_2394)class_2398.field_11227, (double)offsetPos.method_10263() + 0.5, (double)offsetPos.method_10264() + 0.5, (double)offsetPos.method_10260() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573(ENCHANTMENTS_TAG, 9)) {
            class_2499 enchantments = tag.method_10554(ENCHANTMENTS_TAG, 10);
            this.enchantments = class_1890.method_22445((class_2499)enchantments);
        } else {
            this.enchantments = Maps.newHashMap();
        }
        if (tag.method_10573(REPAIR_COST_TAG, 3)) {
            this.repairCost = tag.method_10550(REPAIR_COST_TAG);
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2499 enchantments = SpikeBlockEntity.serializeEnchantments(this.enchantments);
        if (!enchantments.isEmpty()) {
            tag.method_10566(ENCHANTMENTS_TAG, (class_2520)enchantments);
        }
        if (this.repairCost != 0) {
            tag.method_10569(REPAIR_COST_TAG, this.repairCost);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void setEnchantmentData(Map<class_1887, Integer> enchantments, int repairCost) {
        this.enchantments = enchantments;
        this.repairCost = repairCost;
        this.method_5431();
    }

    public boolean hasFoil() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }
}

