/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block;

import fuzs.spikyspikes.SpikySpikes;
import fuzs.spikyspikes.config.ServerConfig;
import java.util.function.DoubleSupplier;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public enum SpikeMaterial {
    WOOD(0, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).woodenSpikeDamage),
    STONE(1, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).stoneSpikeDamage),
    IRON(2, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).ironSpikeDamage),
    GOLD(3, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).goldenSpikeDamage),
    DIAMOND(4, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).diamondSpikeDamage),
    NETHERITE(5, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).netheriteSpikeDamage);

    private final int materialTier;
    private final DoubleSupplier damageAmount;

    private SpikeMaterial(int materialTier, DoubleSupplier damageAmount) {
        this.materialTier = materialTier;
        this.damageAmount = damageAmount;
    }

    public float damageAmount() {
        return (float)this.damageAmount.getAsDouble();
    }

    public class_124 tooltipStyle() {
        if (this.isAtLeast(DIAMOND)) {
            return class_124.field_1060;
        }
        if (this.isAtLeast(IRON)) {
            return class_124.field_1075;
        }
        return class_124.field_1061;
    }

    public class_1792 swordItem() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case WOOD -> class_1802.field_8091;
            case STONE -> class_1802.field_8528;
            case IRON -> class_1802.field_8371;
            case GOLD -> class_1802.field_8845;
            case DIAMOND -> class_1802.field_8802;
            case NETHERITE -> class_1802.field_22022;
        };
    }

    public boolean dealsFinalBlow() {
        return this.isAtLeast(STONE);
    }

    public boolean dropsLoot() {
        return this != STONE && this != GOLD;
    }

    public boolean dropsJustExperience() {
        return this == GOLD;
    }

    public boolean dropsPlayerLoot() {
        return this.isAtLeast(DIAMOND);
    }

    public boolean acceptsEnchantments() {
        return this.isAtLeast(DIAMOND);
    }

    public boolean hurtsPlayers() {
        return this != NETHERITE;
    }

    private boolean isAtLeast(SpikeMaterial material) {
        return this.materialTier >= material.materialTier;
    }
}

