/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.mixin.accessor.LivingEntityAccessor;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import fuzs.spikyspikes.world.phys.shapes.CustomOutlineShape;
import fuzs.spikyspikes.world.phys.shapes.VoxelUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class SpikeBlock
extends class_2237
implements class_3737 {
    public static final DecimalFormat TOOLTIP_DAMAGE_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("0.0"), p_41704_ -> p_41704_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12525;
    private static final Map<class_2350, class_265> SHAPE_BY_DIRECTION = (Map)Arrays.stream(class_2350.values()).collect(Maps.toImmutableEnumMap(Function.identity(), SpikeBlock::makeVisualShape));
    private static final Map<class_2350, class_265> COLLISION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(class_2350.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, false)));
    private static final Map<class_2350, class_265> INTERACTION_SHAPE_BY_DIRECTION = (Map)Arrays.stream(class_2350.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> SpikeBlock.makeCollisionShape(direction, true)));
    public final SpikeMaterial spikeMaterial;

    public SpikeBlock(SpikeMaterial spikeMaterial, class_4970.class_2251 p_49795_) {
        super(p_49795_);
        this.spikeMaterial = spikeMaterial;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657((class_2769)FACING, (Comparable)class_2350.field_11036));
    }

    private static class_265 makeVisualShape(class_2350 direction) {
        class_265 shape = SpikeBlock.makeStaircasePyramid(direction, 8, 2.0);
        class_243[] outlineVectors = VoxelUtils.makePyramidEdges(VoxelUtils.makeVectors(0.0, 0.0, 0.0, 16.0, 0.0, 0.0, 16.0, 0.0, 16.0, 0.0, 0.0, 16.0, 8.0, 16.0, 8.0));
        return new CustomOutlineShape(shape, VoxelUtils.scale(VoxelUtils.rotate(direction, outlineVectors)));
    }

    private static class_265 makeStaircasePyramid(class_2350 direction, int layers, double layerHeight) {
        class_243[] vectors = new class_243[layers * 2];
        int i = 0;
        int j = layers;
        while (i < layers) {
            vectors[2 * i] = new class_243(8.0 - (double)j, (double)i * layerHeight, 8.0 - (double)j);
            vectors[2 * i + 1] = new class_243(8.0 + (double)j, (double)(i + 1) * layerHeight, 8.0 + (double)j);
            ++i;
            --j;
        }
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    private static class_265 makeCollisionShape(class_2350 direction, boolean fullHeight) {
        class_243[] vectors = VoxelUtils.makeVectors(1.0, 0.0, 1.0, 15.0, fullHeight ? 16.0 : 11.0, 15.0);
        return VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, vectors));
    }

    public class_265 method_9530(class_2680 p_60555_, class_1922 p_60556_, class_2338 p_60557_, class_3726 p_60558_) {
        return SHAPE_BY_DIRECTION.get(p_60555_.method_11654((class_2769)FACING));
    }

    public class_265 method_9549(class_2680 p_52357_, class_1922 p_52358_, class_2338 p_52359_, class_3726 p_52360_) {
        return COLLISION_SHAPE_BY_DIRECTION.get(p_52357_.method_11654((class_2769)FACING));
    }

    public class_265 method_26159(class_2680 p_60479_, class_1922 p_60480_, class_2338 p_60481_, class_3726 p_60482_) {
        return this.method_9530(p_60479_, p_60480_, p_60481_, p_60482_);
    }

    public class_265 method_9584(class_2680 p_60547_, class_1922 p_60548_, class_2338 p_60549_) {
        return INTERACTION_SHAPE_BY_DIRECTION.get(p_60547_.method_11654((class_2769)FACING));
    }

    public class_265 method_25959(class_2680 p_60581_, class_1922 p_60582_, class_2338 p_60583_) {
        return class_259.method_1073();
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 otherPos = pos.method_10093(direction.method_10153());
        if (direction == class_2350.field_11036) {
            return SpikeBlock.method_16361((class_1922)level, (class_2338)otherPos);
        }
        return level.method_8320(otherPos).method_26206((class_1922)level, otherPos, direction);
    }

    public class_2680 method_9559(class_2680 p_152036_, class_2350 p_152037_, class_2680 p_152038_, class_1936 p_152039_, class_2338 p_152040_, class_2338 p_152041_) {
        if (((Boolean)p_152036_.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            p_152039_.method_39281(p_152040_, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)p_152039_));
        }
        return p_152037_ == ((class_2350)p_152036_.method_11654((class_2769)FACING)).method_10153() && !p_152036_.method_26184((class_4538)p_152039_, p_152040_) ? class_2246.field_10124.method_9564() : super.method_9559(p_152036_, p_152037_, p_152038_, p_152039_, p_152040_, p_152041_);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(level.method_8316(pos).method_15772() == class_3612.field_15910));
        for (class_2350 direction : context.method_7718()) {
            class_2350 opposite = direction.method_10153();
            if (!(state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)opposite)).method_26184((class_4538)level, pos)) continue;
            return state;
        }
        return null;
    }

    public class_2680 method_9598(class_2680 p_152033_, class_2470 p_152034_) {
        return (class_2680)p_152033_.method_11657((class_2769)FACING, (Comparable)p_152034_.method_10503((class_2350)p_152033_.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 p_152030_, class_2415 p_152031_) {
        return p_152030_.method_26186(p_152031_.method_10345((class_2350)p_152030_.method_11654((class_2769)FACING)));
    }

    public class_3610 method_9545(class_2680 p_152045_) {
        return (Boolean)p_152045_.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(p_152045_);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> p_152043_) {
        p_152043_.method_11667(new class_2769[]{WATERLOGGED, FACING});
    }

    public boolean method_9516(class_2680 p_60475_, class_1922 p_60476_, class_2338 p_60477_, class_10 p_60478_) {
        return false;
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 p_51151_) {
        block10: {
            SpikeMaterial material;
            class_1309 entity;
            block11: {
                if (level.field_9236 || !(p_51151_ instanceof class_1309) || !(entity = (class_1309)p_51151_).method_5805()) break block10;
                if (!(entity instanceof class_1657)) break block11;
                class_1657 player = (class_1657)entity;
                if (player.method_31549().field_7477 || player.method_31549().field_7480) break block10;
            }
            if (((material = this.spikeMaterial).dealsFinalBlow() || entity.method_6032() > material.damageAmount()) && (material.hurtsPlayers() || !(entity instanceof class_1657))) {
                if (material.dropsPlayerLoot()) {
                    class_2586 class_25862 = level.method_8321(pos);
                    if (class_25862 instanceof SpikeBlockEntity) {
                        SpikeBlockEntity blockEntity = (SpikeBlockEntity)class_25862;
                        SpikeBlockEntity.attackPlayerLike(level, pos, level.method_8320(pos), blockEntity, entity, material);
                    }
                } else {
                    boolean doMobLoot = level.method_8450().method_8355(class_1928.field_19391);
                    if (!material.dropsLoot()) {
                        ((class_1928.class_4310)level.method_8450().method_20746(class_1928.field_19391)).method_20758(false, level.method_8503());
                    }
                    entity.method_5643(DamageSourcesHelper.source((class_4538)level, ModRegistry.SPIKE_DAMAGE_TYPE), material.damageAmount());
                    if (!material.dropsLoot()) {
                        ((class_1928.class_4310)level.method_8450().method_20746(class_1928.field_19391)).method_20758(doMobLoot, level.method_8503());
                    }
                    if (!entity.method_5805() && material.dropsJustExperience()) {
                        entity.method_29505(null);
                        ((LivingEntityAccessor)entity).spikyspikes$dropExperience();
                    }
                }
            }
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpikeBlockEntity(pos, state);
    }

    public void method_9567(class_1937 p_55179_, class_2338 p_55180_, class_2680 p_55181_, @Nullable class_1309 p_55182_, class_1799 stack) {
        super.method_9567(p_55179_, p_55180_, p_55181_, p_55182_, stack);
        class_2586 class_25862 = p_55179_.method_8321(p_55180_);
        if (class_25862 instanceof SpikeBlockEntity) {
            SpikeBlockEntity blockEntity = (SpikeBlockEntity)class_25862;
            Map enchantments = class_1890.method_22445((class_2499)stack.method_7921());
            blockEntity.setEnchantmentData(enchantments, stack.method_7928());
        }
    }

    public void method_9568(class_1799 p_56193_, @Nullable class_1922 p_56194_, List<class_2561> tooltip, class_1836 p_56196_) {
        super.method_9568(p_56193_, p_56194_, tooltip, p_56196_);
        if (p_56194_ == null) {
            return;
        }
        if (!Proxy.INSTANCE.hasShiftDown()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spikyspikes.spike.tooltip.more", (Object[])new Object[]{class_2561.method_43471((String)"item.spikyspikes.spike.tooltip.shift").method_27692(class_124.field_1054)}).method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".description")).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spikyspikes.spike.tooltip.damage", (Object[])new Object[]{class_2561.method_43469((String)"item.spikyspikes.spike.tooltip.hearts", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(TOOLTIP_DAMAGE_FORMAT.format(this.spikeMaterial.damageAmount() / 2.0f)))}).method_27692(this.spikeMaterial.tooltipStyle())}).method_27692(class_124.field_1065));
        }
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 p_49825_) {
        class_2586 class_25862;
        class_1799 stack = super.method_9574(level, pos, p_49825_);
        if (this.spikeMaterial.acceptsEnchantments() && (class_25862 = level.method_8321(pos)) instanceof SpikeBlockEntity) {
            SpikeBlockEntity blockEntity = (SpikeBlockEntity)class_25862;
            stack.method_7980(blockEntity.method_38244());
        }
        return stack;
    }
}

