/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.client.model.geom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fuzs.spikyspikes.client.model.geom.PureModelPart;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ShapeModelPart {
    public static PureModelPart pyramid(float minX, float minY, float minZ, float dimensionX, float dimensionY, float dimensionZ, boolean fullBrightness) {
        return ShapeModelPart.pyramid(0, 0, minX, minY, minZ, dimensionX, dimensionY, dimensionZ, 16.0f, 16.0f, fullBrightness);
    }

    public static PureModelPart pyramid(int texCoordU, int texCoordV, float minX, float minY, float minZ, float dimensionX, float dimensionY, float dimensionZ, float texWidthScaled, float texHeightScaled, boolean fullBrightness) {
        return ShapeModelPart.pyramid(texCoordU, texCoordV, minX, minY, minZ, dimensionX, dimensionY, dimensionZ, 0.0f, 0.0f, 0.0f, false, texWidthScaled, texHeightScaled, fullBrightness);
    }

    public static PureModelPart pyramid(int texCoordU, int texCoordV, float minX, float minY, float minZ, float dimensionX, float dimensionY, float dimensionZ, float growX, float growY, float growZ, boolean mirror, float texWidthScaled, float texHeightScaled, boolean fullBrightness) {
        return new PureModelPart((List<class_630.class_628>)ImmutableList.of((Object)((Object)new Pyramid(texCoordU, texCoordV, minX, minY, minZ, dimensionX, dimensionY, dimensionZ, growX, growY, growZ, mirror, texWidthScaled, texHeightScaled, fullBrightness))), (Map<String, PureModelPart>)ImmutableMap.of());
    }

    static class Pyramid
    extends class_630.class_628 {
        private final Polygon[] polygons;
        public final float minX;
        public final float minY;
        public final float minZ;
        public final float maxX;
        public final float maxY;
        public final float maxZ;

        public Pyramid(int texCoordU, int texCoordV, float minX, float minY, float minZ, float dimensionX, float dimensionY, float dimensionZ, float growX, float growY, float growZ, boolean mirror, float texWidthScaled, float texHeightScaled, boolean fullBrightness) {
            super(texCoordU, texCoordV, minX, minY, minZ, dimensionX, dimensionY, dimensionZ, growX, growY, growZ, mirror, texWidthScaled, texHeightScaled, EnumSet.allOf(class_2350.class));
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = minX + dimensionX;
            this.maxY = minY + dimensionY;
            this.maxZ = minZ + dimensionZ;
            this.polygons = new Polygon[5];
            float maxX = minX + dimensionX;
            float maxY = minY + dimensionY;
            float maxZ = minZ + dimensionZ;
            float centerX = minX + dimensionX / 2.0f;
            float centerY = minY + dimensionY / 2.0f;
            float centerZ = minZ + dimensionZ / 2.0f;
            minX -= growX;
            minY -= growY;
            minZ -= growZ;
            maxX += growX;
            maxY += growY;
            maxZ += growZ;
            if (mirror) {
                float f3 = maxX;
                maxX = minX;
                minX = f3;
            }
            Vertex modelpart$vertex7 = new Vertex(minX, minY, minZ, 0.0f, 0.0f);
            Vertex modelpart$vertex = new Vertex(maxX, minY, minZ, 0.0f, 8.0f);
            Vertex modelpart$vertex1 = new Vertex(centerX, maxY, centerZ, 8.0f, 8.0f);
            Vertex modelpart$vertex2 = new Vertex(centerX, maxY, centerZ, 8.0f, 0.0f);
            Vertex modelpart$vertex3 = new Vertex(minX, minY, maxZ, 0.0f, 0.0f);
            Vertex modelpart$vertex4 = new Vertex(maxX, minY, maxZ, 0.0f, 8.0f);
            Vertex modelpart$vertex5 = new Vertex(centerX, maxY, centerZ, 8.0f, 8.0f);
            Vertex modelpart$vertex6 = new Vertex(centerX, maxY, centerZ, 8.0f, 0.0f);
            this.polygons[2] = new Polygon(new Vertex[]{modelpart$vertex4, modelpart$vertex3, modelpart$vertex7, modelpart$vertex}, (float)texCoordU + dimensionX, (float)texCoordV + dimensionZ, texCoordU, texCoordV, texWidthScaled, texHeightScaled, mirror, class_2350.field_11033);
            this.polygons[1] = new Polygon(new Vertex[]{modelpart$vertex7, modelpart$vertex3, modelpart$vertex6, modelpart$vertex2}, (float)texCoordU + dimensionX, (float)texCoordV + dimensionZ, texCoordU, texCoordV, texWidthScaled, texHeightScaled, mirror, fullBrightness ? class_2350.field_11036 : class_2350.field_11039);
            this.polygons[3] = new Polygon(new Vertex[]{modelpart$vertex, modelpart$vertex7, modelpart$vertex2, modelpart$vertex1}, (float)texCoordU + dimensionX, (float)texCoordV + dimensionZ, texCoordU, texCoordV, texWidthScaled, texHeightScaled, mirror, fullBrightness ? class_2350.field_11036 : class_2350.field_11043);
            this.polygons[0] = new Polygon(new Vertex[]{modelpart$vertex4, modelpart$vertex, modelpart$vertex1, modelpart$vertex5}, (float)texCoordU + dimensionX, (float)texCoordV + dimensionZ, texCoordU, texCoordV, texWidthScaled, texHeightScaled, mirror, fullBrightness ? class_2350.field_11036 : class_2350.field_11034);
            this.polygons[4] = new Polygon(new Vertex[]{modelpart$vertex3, modelpart$vertex4, modelpart$vertex5, modelpart$vertex6}, (float)texCoordU + dimensionX, (float)texCoordV + dimensionZ, texCoordU, texCoordV, texWidthScaled, texHeightScaled, mirror, fullBrightness ? class_2350.field_11036 : class_2350.field_11035);
        }

        public void method_32089(class_4587.class_4665 p_171333_, class_4588 p_171334_, int p_171335_, int p_171336_, float p_171337_, float p_171338_, float p_171339_, float p_171340_) {
            Matrix4f matrix4f = p_171333_.method_23761();
            Matrix3f matrix3f = p_171333_.method_23762();
            for (Polygon modelpart$polygon : this.polygons) {
                Vector3f vector3f = matrix3f.transform(new Vector3f((Vector3fc)modelpart$polygon.normal));
                float f = vector3f.x();
                float f1 = vector3f.y();
                float f2 = vector3f.z();
                for (Vertex modelpart$vertex : modelpart$polygon.vertices) {
                    float f3 = modelpart$vertex.pos.x() / 16.0f;
                    float f4 = modelpart$vertex.pos.y() / 16.0f;
                    float f5 = modelpart$vertex.pos.z() / 16.0f;
                    Vector4f vector4f = matrix4f.transform(new Vector4f(f3, f4, f5, 1.0f));
                    p_171334_.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), p_171337_, p_171338_, p_171339_, p_171340_, modelpart$vertex.u, modelpart$vertex.v, p_171336_, p_171335_, f, f1, f2);
                }
            }
        }
    }

    static class Vertex {
        public final Vector3f pos;
        public final float u;
        public final float v;

        public Vertex(float x, float y, float z, float u, float v) {
            this(new Vector3f(x, y, z), u, v);
        }

        public Vertex remap(float u, float v) {
            return new Vertex(this.pos, u, v);
        }

        public Vertex(Vector3f pos, float u, float v) {
            this.pos = pos;
            this.u = u;
            this.v = v;
        }
    }

    static class Polygon {
        public final Vertex[] vertices;
        public final Vector3f normal;

        public Polygon(Vertex[] p_104362_, float p_104363_, float p_104364_, float p_104365_, float p_104366_, float p_104367_, float p_104368_, boolean p_104369_, class_2350 p_104370_) {
            this.vertices = p_104362_;
            float f = 0.0f / p_104367_;
            float f1 = 0.0f / p_104368_;
            p_104362_[0] = p_104362_[0].remap(p_104365_ / p_104367_ - f, p_104364_ / p_104368_ + f1);
            p_104362_[1] = p_104362_[1].remap(p_104363_ / p_104367_ + f, p_104364_ / p_104368_ + f1);
            p_104362_[2] = p_104362_[2].remap(p_104363_ / p_104367_ + f, p_104366_ / p_104368_ - f1);
            p_104362_[3] = p_104362_[3].remap(p_104365_ / p_104367_ - f, p_104366_ / p_104368_ - f1);
            if (p_104369_) {
                int i = p_104362_.length;
                for (int j = 0; j < i / 2; ++j) {
                    Vertex modelpart$vertex = p_104362_[j];
                    p_104362_[j] = p_104362_[i - 1 - j];
                    p_104362_[i - 1 - j] = modelpart$vertex;
                }
            }
            this.normal = p_104370_.method_23955();
            if (p_104369_) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }
}

