/*
 * Decompiled with CFR 0.152.
 */
package net.bl4st.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    public static float ELYTRA_DRAG = 2.0f;
    public static float MAXIMUM_FALLDISTANCE = 15.0f;
    public static float MINIMUM_SPEED = 0.1f;

    public static void LoadConfig() {
        String configPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), "elytradrag.properties").toString();
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(configPath);){
            properties.load(input);
            ELYTRA_DRAG = Float.parseFloat(properties.getProperty("drag", "2.0"));
            MAXIMUM_FALLDISTANCE = Float.parseFloat(properties.getProperty("maximum-fall-distance-while-slowing-Down", "15.0"));
            MINIMUM_SPEED = Float.parseFloat(properties.getProperty("minimum-speed-required", "0.1"));
        }
        catch (FileNotFoundException e) {
            try (FileOutputStream output = new FileOutputStream(configPath);){
                properties.setProperty("drag", "2.0");
                properties.setProperty("maximum-fall-distance-while-slowing-Down", "15.0");
                properties.setProperty("minimum-speed-required", "0.1");
                properties.store(output, "Elytra Drag Configuration");
            }
            catch (IOException ex) {
                System.err.println("Error creating default config file: " + ex.getMessage());
            }
        }
        catch (IOException e) {
            System.err.println("Error loading config file: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing config values: " + e.getMessage());
        }
    }
}

