/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4865;
import net.minecraft.class_5281;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6016;
import net.orcinus.goodending.init.GoodEndingBlocks;
import net.orcinus.goodending.world.gen.features.config.MuddyOakFeatureConfig;

public class MuddyOakTreeFeature
extends class_3031<MuddyOakFeatureConfig> {
    public MuddyOakTreeFeature(Codec<MuddyOakFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<MuddyOakFeatureConfig> context) {
        class_5281 world = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 random = context.method_33654();
        MuddyOakFeatureConfig config = (MuddyOakFeatureConfig)context.method_33656();
        int treeHeight = class_6016.method_34998((int)8).method_35008(random);
        ArrayList leavePoses = Lists.newArrayList();
        for (int i = 0; i < treeHeight; ++i) {
            class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
            if (config.generateBranch && random.method_43048(2) == 0 && i >= treeHeight / 2) {
                for (int branchLength = 0; branchLength <= class_3532.method_15395((class_5819)random, (int)1, (int)2); ++branchLength) {
                    class_2338 branchPos = blockPos.method_10086(i).method_10079(direction, branchLength);
                    if (!world.method_16358(branchPos.method_10074(), class_5726::method_33014) || !world.method_16358(branchPos, blockState -> blockState.method_26215() || blockState.method_26164(class_3481.field_15503) || blockState.method_27852(class_2246.field_10382))) continue;
                    world.method_8652(branchPos, (class_2680)config.trunkProvider.method_23455(random, branchPos).method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()), 19);
                }
                if (!world.method_16358(blockPos.method_10086(i), blockState -> blockState.method_26215() || blockState.method_26164(class_3481.field_15503) || blockState.method_27852(class_2246.field_10382) || blockState.method_26164(class_3481.field_15475))) continue;
                world.method_8652(blockPos.method_10086(i), config.trunkProvider.method_23455(random, blockPos.method_10086(i)), 2);
                continue;
            }
            if (!world.method_16358(blockPos.method_10086(i), blockState -> blockState.method_26215() || blockState.method_26164(class_3481.field_15503) || blockState.method_27852(class_2246.field_10382))) continue;
            world.method_8652(blockPos.method_10086(i), config.trunkProvider.method_23455(random, blockPos.method_10086(i)), 19);
        }
        for (int y = -1; y <= 2; ++y) {
            int radius = 4;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264() + y + treeHeight, blockPos.method_10260() + z);
                    int eliminateFactor = 16;
                    if (y == -1 && (x <= 1 && x >= -1 && (z == 2 || z == -2) || z <= 1 && z >= -1 && (x == 2 || x == -2))) {
                        if (world.method_16358(pos.method_10074(), class_5726::method_33014)) {
                            world.method_8652(pos.method_10074(), (class_2680)config.foliageProvider.method_23455(random, pos.method_10074()).method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)), 19);
                            leavePoses.add(pos.method_10074());
                        }
                        if ((x == 0 || z == 0) && world.method_16358(pos.method_10087(2), class_5726::method_33014)) {
                            world.method_8652(pos.method_10087(2), (class_2680)config.foliageProvider.method_23455(random, pos.method_10087(2)).method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)), 19);
                            leavePoses.add(pos.method_10087(2));
                        }
                    }
                    if (y > 0) {
                        eliminateFactor /= y * 2;
                    }
                    if (x * x + z * z > eliminateFactor || !world.method_16358(pos, class_5726::method_33014)) continue;
                    world.method_8652(pos, (class_2680)config.foliageProvider.method_23455(random, pos).method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)), 19);
                    leavePoses.add(pos);
                }
            }
        }
        this.generateHangingVines(world, 0.25f, random, leavePoses);
        return true;
    }

    public void generateHangingVines(class_5281 world, float probability, class_5819 random, List<class_2338> leavePositions) {
        leavePositions.stream().filter(pos -> world.method_22347(pos.method_10074()) && world.method_8320(pos).method_27852(class_2246.field_10503)).forEach(pos -> {
            class_2338.class_2339 mutable = pos.method_25503();
            if (random.method_43057() < probability) {
                int length = class_3532.method_15395((class_5819)random, (int)1, (int)2);
                for (int i = 0; i <= length; ++i) {
                    if (world.method_22347((class_2338)mutable)) {
                        if (i == length || !world.method_22347(mutable.method_10074())) {
                            world.method_8652((class_2338)mutable, (class_2680)GoodEndingBlocks.HANGING_OAK_LEAVES.method_9564().method_11657((class_2769)class_4865.field_22509, (Comparable)Integer.valueOf(class_3532.method_15395((class_5819)random, (int)17, (int)25))), 2);
                            break;
                        }
                        world.method_8652((class_2338)mutable, GoodEndingBlocks.HANGING_OAK_LEAVES_PLANT.method_9564(), 2);
                    }
                    mutable.method_10098(class_2350.field_11033);
                }
            }
        });
    }
}

