/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.orcinus.goodending.init.GoodEndingBlocks;

public class LargeLilyPadFeature
extends class_3031<class_3111> {
    public LargeLilyPadFeature(Codec<class_3111> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 world = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 random = context.method_33654();
        ArrayList pos = Lists.newArrayList();
        int size = class_3532.method_15395((class_5819)random, (int)1, (int)4);
        if (size == 1) {
            pos.add(blockPos);
            pos.add(blockPos.method_10078());
            pos.add(blockPos.method_10072());
            pos.add(blockPos.method_10078().method_10072());
            if (this.hasEnoughSpace(pos, world)) {
                this.placeLargeLilypad(pos, world);
                return true;
            }
        } else if (size == 2) {
            this.addLargeLilypads(pos, blockPos, 1, false, false);
            if (this.hasEnoughSpace(pos, world)) {
                this.placeLargeLilypad(pos, world);
                return true;
            }
        } else if (size == 3) {
            this.addLargeLilypads(pos, blockPos, 2, false, true);
            if (this.hasEnoughSpace(pos, world)) {
                this.placeLargeLilypad(pos, world);
                return true;
            }
        } else {
            this.addLargeLilypads(pos, blockPos, 2, true, true);
            if (this.hasEnoughSpace(pos, world)) {
                this.placeLargeLilypad(pos, world);
                return true;
            }
        }
        return false;
    }

    private void addLargeLilypads(List<class_2338> pos, class_2338 origin, int range, boolean even, boolean corners) {
        int minRange = range;
        int maxRange = even ? range - 1 : range;
        for (int x = -minRange; x <= maxRange; ++x) {
            for (int z = -minRange; z <= maxRange; ++z) {
                if (!(!corners || x != -minRange && x != maxRange || z != -minRange && z != maxRange)) continue;
                pos.add(new class_2338((class_2382)new class_2338(origin.method_10263() + x, origin.method_10264(), origin.method_10260() + z)));
            }
        }
    }

    private void placeLargeLilypad(List<class_2338> pos, class_5281 world) {
        for (class_2338 position : pos) {
            world.method_8652(position.method_10074(), (class_2680)GoodEndingBlocks.LARGE_LILY_PAD.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    private boolean hasEnoughSpace(List<class_2338> pos, class_5281 world) {
        boolean flag = false;
        for (class_2338 position : pos) {
            Predicate<class_2350> predicate = direction -> {
                class_2338 belowPos = position.method_10074();
                return !world.method_8320(belowPos).method_27852(class_2246.field_10382) || world.method_8320(belowPos.method_10093(direction)).method_27852(GoodEndingBlocks.LARGE_LILY_PAD) && !world.method_8320(belowPos.method_10093(direction)).method_27852(class_2246.field_10382);
            };
            Optional<class_2350> relativeDir = Arrays.stream(class_2350.values()).filter(predicate).findAny();
            if (!relativeDir.isPresent()) continue;
            flag = true;
        }
        return !flag;
    }
}

