/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.orcinus.goodending.init.GoodEndingBlocks;
import net.orcinus.goodending.init.GoodEndingTags;
import net.orcinus.goodending.world.gen.features.DuckweedFeature;
import net.orcinus.goodending.world.gen.features.config.WaterTreeFeatureConfig;

public class CypressTreeFeature
extends class_3031<WaterTreeFeatureConfig> {
    public CypressTreeFeature(Codec<WaterTreeFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<WaterTreeFeatureConfig> context) {
        boolean initialFlag1;
        class_5281 world = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 random = context.method_33654();
        ArrayList list = Lists.newArrayList();
        ArrayList leavePoses = Lists.newArrayList();
        ArrayList branchPoses = Lists.newArrayList();
        int height = class_3532.method_15395((class_5819)random, (int)10, (int)15);
        class_2248 cypressLog = GoodEndingBlocks.CYPRESS_LOG;
        boolean isPlanted = ((WaterTreeFeatureConfig)context.method_33656()).isPlanted;
        boolean initialFlag = !isPlanted && !world.method_8320(blockPos).method_27852(class_2246.field_10382) || !world.method_8320(blockPos.method_10074()).method_26164(class_3481.field_29822);
        boolean bl = initialFlag1 = isPlanted && !this.canGrow(world, blockPos.method_10074());
        if (initialFlag || initialFlag1) {
            return false;
        }
        class_2680 cypressLogDefaultState = cypressLog.method_9564();
        for (int i = 0; i <= height; ++i) {
            if (!world.method_8320(blockPos.method_10086(i)).method_45474() && !world.method_8320(blockPos.method_10086(i)).method_26164(GoodEndingTags.CYPRESS_REPLACEABLES) && !world.method_8320(blockPos.method_10086(i)).method_27852(class_2246.field_37576)) continue;
            world.method_8652(blockPos.method_10086(i), cypressLogDefaultState, 19);
            if (random.method_43048(3) != 0 || i >= height - 3 || i <= 3) continue;
            branchPoses.add(blockPos.method_10086(i));
        }
        class_2350 randomDirection = class_2350.class_2353.field_11062.method_10183(random);
        class_2680 leaveState = (class_2680)GoodEndingBlocks.CYPRESS_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(1));
        branchPoses.stream().map(position -> position.method_10093(randomDirection)).forEach(brancingPos -> {
            if (world.method_8320(brancingPos).method_45474() || world.method_8320(brancingPos).method_26164(GoodEndingTags.CYPRESS_REPLACEABLES)) {
                world.method_8652(brancingPos, (class_2680)cypressLogDefaultState.method_11657((class_2769)class_2465.field_11459, (Comparable)randomDirection.method_10166()), 2);
                Arrays.stream(class_2350.values()).forEach(direction -> {
                    for (int i = 0; i <= class_3532.method_15395((class_5819)random, (int)1, (int)4); ++i) {
                        class_2338 relativeOffset = brancingPos.method_10093(direction).method_10087(i);
                        if (!world.method_16358(relativeOffset, class_5726::method_33014) && !world.method_8320(relativeOffset).method_45474() && !world.method_8320(brancingPos).method_26164(GoodEndingTags.CYPRESS_REPLACEABLES)) continue;
                        world.method_8652(relativeOffset, (class_2680)leaveState.method_11657((class_2769)class_2397.field_38227, (Comparable)Boolean.valueOf(world.method_8320(relativeOffset).method_27852(class_2246.field_10382))), 2);
                        leavePoses.add(relativeOffset);
                    }
                });
            }
        });
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (world.method_8320(blockPos.method_10093(direction)).method_45474() || world.method_8320(blockPos.method_10093(direction)).method_26164(GoodEndingTags.CYPRESS_REPLACEABLES)) {
                world.method_8652(blockPos.method_10093(direction), cypressLogDefaultState, 19);
            }
            this.branchingRoot(world, blockPos.method_10093(direction), cypressLog, random, direction, 0);
        }
        if (world.method_8320(blockPos.method_10074()).method_27852(class_2246.field_10382) && world.method_8320(blockPos).method_26215()) {
            DuckweedFeature.generateDuckweed(world, blockPos, random);
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            for (int length = 0; length < class_3532.method_15395((class_5819)random, (int)2, (int)5); ++length) {
                class_2338 dirPos = blockPos.method_10086(height).method_10079(direction, length);
                if (!world.method_8320(dirPos).method_45474() && !world.method_8320(dirPos).method_26164(GoodEndingTags.CYPRESS_REPLACEABLES)) continue;
                world.method_8652(dirPos, (class_2680)cypressLogDefaultState.method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()), 19);
                list.add(blockPos.method_10086(height));
                list.add(dirPos);
            }
        }
        list.forEach(pos -> {
            for (class_2350 direction : class_2350.values()) {
                if (!world.method_16358(pos.method_10093(direction), class_5726::method_33014)) continue;
                for (int t = 0; t < class_3532.method_15395((class_5819)random, (int)2, (int)5); ++t) {
                    class_2338 leavePose = pos.method_10093(direction).method_10087(t);
                    if (!world.method_8320(leavePose).method_26164(GoodEndingTags.CYPRESS_REPLACEABLES) && !world.method_8320(leavePose).method_45474() && !world.method_8320(leavePose).method_26164(class_3481.field_15503)) continue;
                    world.method_8652(leavePose, (class_2680)leaveState.method_11657((class_2769)class_2397.field_38227, (Comparable)Boolean.valueOf(world.method_8320(leavePose).method_27852(class_2246.field_10382))), 19);
                    leavePoses.add(leavePose);
                }
            }
        });
        this.generateVines(world, 0.25f, random, leavePoses);
        return true;
    }

    public boolean canGrow(class_5281 world, class_2338 blockPos) {
        int range = 3;
        boolean flag = false;
        for (int x = -range; x <= range; ++x) {
            class_2338 pos;
            for (int z = -range; z <= range && !world.method_16358(pos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264(), blockPos.method_10260() + z), class_5726::method_33389); ++z) {
                flag = true;
            }
        }
        return flag;
    }

    public boolean branchingRoot(class_5281 world, class_2338 blockPos, class_2248 block, class_5819 random, class_2350 direction, int tries) {
        class_2338 finalPos;
        class_2338 belowPos = blockPos.method_10074();
        if (tries == 2) {
            return this.repeatPlace(world, blockPos, block);
        }
        class_2338 class_23382 = finalPos = random.method_43048(3) != 0 ? belowPos : blockPos.method_10093(direction);
        if ((world.method_8320(finalPos).method_26164(GoodEndingTags.CYPRESS_REPLACEABLES) || world.method_8320(finalPos).method_45474() || world.method_8320(finalPos).method_27852(class_2246.field_10382)) && tries < 2) {
            world.method_8652(finalPos, block.method_9564(), 19);
            return this.branchingRoot(world, finalPos, block, random, direction, ++tries);
        }
        return true;
    }

    public boolean repeatPlace(class_5281 world, class_2338 blockPos, class_2248 block) {
        class_2338 belowPos = blockPos.method_10074();
        if (world.method_8320(belowPos).method_26164(GoodEndingTags.CYPRESS_REPLACEABLES) || world.method_8320(belowPos).method_27852(class_2246.field_10382) || world.method_8320(belowPos).method_45474()) {
            world.method_8652(belowPos, block.method_9564(), 19);
            return this.repeatPlace(world, belowPos, block);
        }
        return true;
    }

    public void generateVines(class_5281 world, float probability, class_5819 random, List<class_2338> leavePositions) {
        leavePositions.forEach(pos -> {
            class_2338 blockPos;
            if (random.method_43057() < probability && world.method_22347(blockPos = pos.method_10067())) {
                CypressTreeFeature.placeVines(blockPos, class_2541.field_11702, world);
            }
            if (random.method_43057() < probability && world.method_22347(blockPos = pos.method_10078())) {
                CypressTreeFeature.placeVines(blockPos, class_2541.field_11696, world);
            }
            if (random.method_43057() < probability && world.method_22347(blockPos = pos.method_10095())) {
                CypressTreeFeature.placeVines(blockPos, class_2541.field_11699, world);
            }
            if (random.method_43057() < probability && world.method_22347(blockPos = pos.method_10072())) {
                CypressTreeFeature.placeVines(blockPos, class_2541.field_11706, world);
            }
        });
    }

    private static void placeVines(class_2338 pos, class_2746 faceProperty, class_5281 world) {
        world.method_8652(pos, (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)faceProperty, (Comparable)Boolean.valueOf(true)), 19);
        pos = pos.method_10074();
        for (int i = 4; world.method_22347(pos) && i > 0; --i) {
            world.method_8652(pos, (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)faceProperty, (Comparable)Boolean.valueOf(true)), 19);
            pos = pos.method_10074();
        }
    }
}

