/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.entities;

import net.minecraft.class_1299;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.orcinus.goodending.init.GoodEndingBlocks;
import net.orcinus.goodending.init.GoodEndingEntityTypes;
import net.orcinus.goodending.init.GoodEndingItems;

public class GoodEndingBoatEntity
extends class_1690 {
    private static final class_2940<Integer> BOAT_TYPE = class_2945.method_12791(GoodEndingBoatEntity.class, (class_2941)class_2943.field_13327);

    public GoodEndingBoatEntity(class_1299<? extends GoodEndingBoatEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public GoodEndingBoatEntity(class_1937 world, double x, double y, double z) {
        this(GoodEndingEntityTypes.BOAT, world);
        this.method_5814(x, y, z);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BOAT_TYPE, (Object)BOAT_TYPE.method_12713());
    }

    public class_1792 method_7557() {
        return this.getGoodEndingBoatType() == BoatType.MUDDY_OAK ? GoodEndingItems.MUDDY_OAK_BOAT : GoodEndingItems.CYPRESS_BOAT;
    }

    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Type", 8)) {
            this.setGoodEndingBoatType(BoatType.byName(nbt.method_10558("Type")));
        }
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Type", this.getGoodEndingBoatType().getName());
    }

    public BoatType getGoodEndingBoatType() {
        return BoatType.byId((Integer)this.field_6011.method_12789(BOAT_TYPE));
    }

    public void setGoodEndingBoatType(BoatType type) {
        this.field_6011.method_12778(BOAT_TYPE, (Object)type.ordinal());
    }

    public static enum BoatType {
        MUDDY_OAK(GoodEndingBlocks.MUDDY_OAK_PLANKS, "muddy_oak"),
        CYPRESS(GoodEndingBlocks.CYPRESS_PLANKS, "cypress");

        private final String name;
        private final class_2248 planks;

        private BoatType(class_2248 block, String name) {
            this.name = name;
            this.planks = block;
        }

        public String getName() {
            return this.name;
        }

        public class_2248 getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int id) {
            BoatType[] aboat$type = BoatType.values();
            if (id < 0 || id >= aboat$type.length) {
                id = 0;
            }
            return aboat$type[id];
        }

        public static BoatType byName(String name) {
            BoatType[] types;
            for (BoatType type : types = BoatType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return types[0];
        }
    }
}

