/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.orcinus.goodending.entities.GoodEndingBoatEntity;
import net.orcinus.goodending.init.GoodEndingModelLayers;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class GoodEndingBoatEntityRenderer
extends class_897<GoodEndingBoatEntity> {
    private final Map<GoodEndingBoatEntity.BoatType, Pair<class_2960, class_554>> texturesAndModels;

    public GoodEndingBoatEntityRenderer(class_5617.class_5618 ctx, boolean chest) {
        super(ctx);
        this.field_4673 = 0.8f;
        this.texturesAndModels = (Map)Stream.of(GoodEndingBoatEntity.BoatType.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new class_2960("goodending", GoodEndingBoatEntityRenderer.getTexture(type, chest)), (Object)this.createModel(ctx, (GoodEndingBoatEntity.BoatType)((Object)type), chest))));
    }

    private class_554 createModel(class_5617.class_5618 ctx, GoodEndingBoatEntity.BoatType type, boolean chest) {
        class_5601 entityModelLayer = chest ? GoodEndingModelLayers.createChestBoat(type) : GoodEndingModelLayers.createBoat(type);
        class_630 modelPart = ctx.method_32167(entityModelLayer);
        return chest ? new class_7752(modelPart) : new class_554(modelPart);
    }

    private static String getTexture(GoodEndingBoatEntity.BoatType type, boolean chest) {
        if (chest) {
            return "textures/entity/chest_boat/" + type.getName() + ".png";
        }
        return "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(GoodEndingBoatEntity boatEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.375, 0.0);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - f));
        float h = (float)boatEntity.method_7533() - g;
        float j = boatEntity.method_7554() - g;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)h) * h * j / 10.0f * (float)boatEntity.method_7543()));
        }
        if (!class_3532.method_15347((float)boatEntity.method_7547(g), (float)0.0f)) {
            matrixStack.method_22907(new Quaternionf().setAngleAxis(boatEntity.method_7547(g) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_554> pair = this.texturesAndModels.get((Object)boatEntity.getGoodEndingBoatType());
        class_2960 identifier = (class_2960)pair.getFirst();
        class_554 boatEntityModel = (class_554)pair.getSecond();
        matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        boatEntityModel.method_22952((class_1690)boatEntity, g, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(boatEntityModel.method_23500(identifier));
        boatEntityModel.method_2828(matrixStack, vertexConsumer, i, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boatEntity.method_5869()) {
            class_4588 vertexConsumer2 = vertexConsumerProvider.getBuffer(class_1921.method_23589());
            boatEntityModel.method_22954().method_22698(matrixStack, vertexConsumer2, i, class_4608.field_21444);
        }
        matrixStack.method_22909();
        super.method_3936((class_1297)boatEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public class_2960 getTextureLocation(GoodEndingBoatEntity entity) {
        return (class_2960)this.texturesAndModels.get((Object)entity.getGoodEndingBoatType()).getFirst();
    }
}

