/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.fabric;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class ResourceConditionsBridge {
    public static final String CONDITIONS_KEY = "conditions";
    public static final String NON_RECIPE_CONDITIONS_KEY = "global_conditions";
    public static final String CONDITION_ID = "type";

    public static void init() {
        try {
            ResourceConditions.register((class_2960)new class_2960("forge:not"), ResourceConditionsBridge::forgeNot);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ResourceConditions.register((class_2960)new class_2960("forge:or"), ResourceConditionsBridge::forgeOr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ResourceConditions.register((class_2960)new class_2960("forge:and"), ResourceConditionsBridge::forgeAnd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ResourceConditions.register((class_2960)new class_2960("forge:mod_loaded"), ResourceConditionsBridge::forgeModLoaded);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ResourceConditions.register((class_2960)new class_2960("forge:tag_empty"), ResourceConditionsBridge::forgeTagEmpty);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean forgeNot(JsonObject jsonObject) {
        JsonObject jo = class_3518.method_15296((JsonObject)jsonObject, (String)"value");
        return !ResourceConditionsBridge.conditionMatches(jo);
    }

    private static boolean forgeAnd(JsonObject jsonObject) {
        JsonArray jo = class_3518.method_15261((JsonObject)jsonObject, (String)"values");
        return ResourceConditionsBridge.conditionsMatch(jo, true);
    }

    private static boolean forgeOr(JsonObject jsonObject) {
        JsonArray jo = class_3518.method_15261((JsonObject)jsonObject, (String)"values");
        return ResourceConditionsBridge.conditionsMatch(jo, false);
    }

    private static boolean forgeModLoaded(JsonObject jsonObject) {
        return PlatHelper.isModLoaded(class_3518.method_15265((JsonObject)jsonObject, (String)"modid"));
    }

    private static Boolean forgeTagEmpty(JsonObject object) {
        class_2960 id = new class_2960(class_3518.method_15265((JsonObject)object, (String)"tag"));
        Map allTags = (Map)ResourceConditionsImpl.LOADED_TAGS.get();
        if (allTags == null) {
            Moonlight.LOGGER.warn("Can't retrieve deserialized tags. Failing tag resource condition check.");
            return true;
        }
        Map registryTags = (Map)allTags.get(class_7924.field_41197);
        if (registryTags == null) {
            return true;
        }
        Collection tags = (Collection)registryTags.get(id);
        if (tags == null) {
            return true;
        }
        if (tags.size() == 1 && ((class_6880)tags.stream().findFirst().get()).comp_349() == class_1802.field_8162) {
            Moonlight.LOGGER.warn("Found broken tag which just contained the empty item: " + id);
            return true;
        }
        return tags.isEmpty();
    }

    public static void registerSimple(class_2960 id, Predicate<String> predicate) {
        ResourceConditions.register((class_2960)id, j -> predicate.test(j.get(id.method_12832()).getAsString()));
    }

    public static boolean matchesForgeCondition(JsonObject obj) {
        try {
            if (obj.has("fabric:load_conditions")) {
                return true;
            }
            JsonArray conditions = class_3518.method_15292((JsonObject)obj, (String)NON_RECIPE_CONDITIONS_KEY, null);
            if (conditions == null) {
                conditions = class_3518.method_15292((JsonObject)obj, (String)CONDITIONS_KEY, null);
            }
            if (conditions != null) {
                return ResourceConditionsBridge.conditionsMatch(conditions, true);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return true;
    }

    public static boolean conditionMatches(JsonObject condition) throws RuntimeException {
        if (condition.has(CONDITION_ID)) {
            class_2960 conditionId = new class_2960(class_3518.method_15265((JsonObject)condition, (String)CONDITION_ID));
            Predicate jrc = ResourceConditions.get((class_2960)conditionId);
            if (jrc == null) {
                throw new JsonParseException("Unknown recipe condition: " + conditionId);
            }
            return jrc.test(condition);
        }
        return ResourceConditions.conditionMatches((JsonObject)condition);
    }

    public static boolean conditionsMatch(JsonArray conditions, boolean and) throws RuntimeException {
        for (JsonElement element : conditions) {
            if (element.isJsonObject()) {
                if (ResourceConditionsBridge.conditionMatches(element.getAsJsonObject()) == and) continue;
                return !and;
            }
            throw new JsonParseException("Invalid condition entry: " + element);
        }
        return and;
    }
}

