/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.structure.void_blossom_cavern;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.barribob.boss.structure.util.IPieceGenerator;
import net.barribob.boss.structure.util.IStructurePiece;
import net.barribob.boss.structure.void_blossom_cavern.BossBlockDecorator;
import net.barribob.boss.structure.void_blossom_cavern.ICaveDecorator;
import net.barribob.boss.structure.void_blossom_cavern.MossCeilingCaveDecorator;
import net.barribob.boss.structure.void_blossom_cavern.MossFloorCaveDecorator;
import net.barribob.boss.structure.void_blossom_cavern.SpikeCaveDecorator;
import net.barribob.boss.structure.void_blossom_cavern.SporeBlossomCaveDecorator;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5138;
import net.minecraft.class_5216;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6019;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b$\u0010%JO\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014JM\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJS\u0010\"\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010!\u001a\u00020 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lnet/barribob/boss/structure/void_blossom_cavern/VoidBlossomCavernPieceGenerator;", "Lnet/barribob/boss/structure/util/IPieceGenerator;", "Lnet/minecraft/class_5281;", "world", "Lnet/minecraft/class_5138;", "structureAccessor", "Lnet/minecraft/class_2794;", "chunkGenerator", "Lnet/minecraft/class_5819;", "random", "Lnet/minecraft/class_3341;", "boundingBox", "Lnet/minecraft/class_1923;", "chunkPos", "Lnet/minecraft/class_2338;", "pos", "Lnet/barribob/boss/structure/util/IStructurePiece;", "structurePiece", "", "generate", "(Lnet/minecraft/class_5281;Lnet/minecraft/class_5138;Lnet/minecraft/class_2794;Lnet/minecraft/class_5819;Lnet/minecraft/class_3341;Lnet/minecraft/class_1923;Lnet/minecraft/class_2338;Lnet/barribob/boss/structure/util/IStructurePiece;)Z", "", "Lnet/barribob/boss/structure/void_blossom_cavern/ICaveDecorator;", "caveDecorators", "", "bottomOfWorld", "", "generateCave", "(Lnet/minecraft/class_5281;Lnet/minecraft/class_2338;Lnet/barribob/boss/structure/util/IStructurePiece;Lnet/minecraft/class_5819;Lnet/minecraft/class_3341;Ljava/util/List;I)V", "Lkotlin/Function0;", "predicate", "samplePos", "Lnet/minecraft/class_2680;", "blockState", "replaceBlock", "(Lkotlin/jvm/functions/Function0;Lnet/minecraft/class_5281;Lnet/minecraft/class_2338;Lnet/barribob/boss/structure/util/IStructurePiece;Lnet/minecraft/class_3341;Lnet/minecraft/class_2680;Ljava/util/List;)V", "<init>", "()V", "BOMD"})
public final class VoidBlossomCavernPieceGenerator
implements IPieceGenerator {
    @Override
    public boolean generate(@NotNull class_5281 world, @NotNull class_5138 structureAccessor, @NotNull class_2794 chunkGenerator, @NotNull class_5819 random, @NotNull class_3341 boundingBox, @NotNull class_1923 chunkPos, @NotNull class_2338 pos, @NotNull IStructurePiece structurePiece) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)structureAccessor, (String)"structureAccessor");
        Intrinsics.checkNotNullParameter((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"boundingBox");
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)structurePiece, (String)"structurePiece");
        int minY = chunkGenerator.method_33730();
        ICaveDecorator[] iCaveDecoratorArray = new ICaveDecorator[]{new SpikeCaveDecorator(minY, random), new MossFloorCaveDecorator(minY, random), new MossCeilingCaveDecorator(minY, random), new SporeBlossomCaveDecorator(minY, random), new BossBlockDecorator(minY)};
        List caveDecorators = CollectionsKt.listOf((Object[])iCaveDecoratorArray);
        class_2338 class_23382 = pos.method_10086(17);
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"pos.up(17)");
        this.generateCave(world, class_23382, structurePiece, random, boundingBox, caveDecorators, chunkGenerator.method_33730());
        for (ICaveDecorator decorator : caveDecorators) {
            decorator.generate(world, chunkGenerator, random, boundingBox, pos, structurePiece);
        }
        return true;
    }

    private final void generateCave(class_5281 world, class_2338 pos, IStructurePiece structurePiece, class_5819 random, class_3341 boundingBox, List<? extends ICaveDecorator> caveDecorators, int bottomOfWorld) {
        double noiseMultiplier = 0.005;
        class_6019 outerWallDistance = class_6019.method_35017((int)3, (int)4);
        class_6019 pointOffset = class_6019.method_35017((int)1, (int)2);
        int minY = bottomOfWorld - pos.method_10264();
        int maxY = minY + 32;
        int minXZ = -32;
        int maxXZ = 32;
        double verticalSquish = 2.0;
        int distributionPoints = 5;
        LinkedList linkedList = Lists.newLinkedList();
        Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"newLinkedList()");
        List randoms = linkedList;
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(world.method_8412()));
        double[] dArray = new double[]{1.0};
        class_5216 doublePerlinNoiseSampler = class_5216.method_31927((class_5819)((class_5819)chunkRandom), (int)-4, (double[])dArray);
        double d = (double)distributionPoints / (double)outerWallDistance.method_35011();
        double airThickness = 1.0 / Math.sqrt(25.2 + d);
        double outerLayerThickness = 1.0 / Math.sqrt(30.2 + d);
        class_2338 randomPos = null;
        for (int r = 0; r < distributionPoints; ++r) {
            Intrinsics.checkNotNullExpressionValue((Object)pos.method_10069(outerWallDistance.method_35008(random), outerWallDistance.method_35008(random), outerWallDistance.method_35008(random)), (String)"pos.add(outerWallDistanc\u2026uterWallDistance[random])");
            Pair pair = Pair.of((Object)randomPos, (Object)pointOffset.method_35008(random));
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(\n                    \u2026random]\n                )");
            randoms.add(pair);
        }
        Predicate predicate = class_3031.method_36999((class_6862)class_3481.field_33757);
        Iterator positions = class_2338.method_10097((class_2338)pos.method_10069(minXZ, minY, minXZ), (class_2338)pos.method_10069(maxXZ, maxY, maxXZ)).iterator();
        while (true) {
            double noisedDistance = 0.0;
            Ref.ObjectRef samplePos = new Ref.ObjectRef();
            do {
                if (!positions.hasNext()) {
                    return;
                }
                samplePos.element = positions.next();
                double noise = doublePerlinNoiseSampler.method_27406((double)((class_2338)samplePos.element).method_10263(), (double)((class_2338)samplePos.element).method_10264(), (double)((class_2338)samplePos.element).method_10260()) * noiseMultiplier;
                noisedDistance = 0.0;
                for (Pair pair : randoms) {
                    class_2338 distancePos = new class_2338(((class_2338)samplePos.element).method_10263(), (int)((double)(((class_2338)samplePos.element).method_10264() - bottomOfWorld) * verticalSquish + (double)bottomOfWorld), ((class_2338)samplePos.element).method_10260());
                    noisedDistance += class_3532.method_15345((double)(distancePos.method_10262((class_2382)pair.getFirst()) + (double)((Number)pair.getSecond()).intValue())) + noise;
                }
            } while (noisedDistance < outerLayerThickness);
            Function0 canReplace2 = (Function0)new Function0<Boolean>((Predicate<class_2680>)predicate, world, (Ref.ObjectRef<class_2338>)samplePos, bottomOfWorld){
                final /* synthetic */ Predicate<class_2680> $predicate;
                final /* synthetic */ class_5281 $world;
                final /* synthetic */ Ref.ObjectRef<class_2338> $samplePos;
                final /* synthetic */ int $bottomOfWorld;
                {
                    this.$predicate = $predicate;
                    this.$world = $world;
                    this.$samplePos = $samplePos;
                    this.$bottomOfWorld = $bottomOfWorld;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return this.$predicate.test(this.$world.method_8320((class_2338)this.$samplePos.element)) && !this.$world.method_8320((class_2338)this.$samplePos.element).method_26215() && !Intrinsics.areEqual((Object)this.$world.method_8320((class_2338)this.$samplePos.element).method_26204(), (Object)class_2246.field_9987) && ((class_2338)this.$samplePos.element).method_10264() > 4 + this.$bottomOfWorld;
                }
            };
            if (noisedDistance >= airThickness) {
                class_2338 class_23382 = (class_2338)samplePos.element;
                class_2680 class_26802 = class_2246.field_10124.method_9564();
                Intrinsics.checkNotNullExpressionValue((Object)class_26802, (String)"AIR.defaultState");
                this.replaceBlock((Function0<Boolean>)canReplace2, world, class_23382, structurePiece, boundingBox, class_26802, caveDecorators);
                continue;
            }
            if (!(noisedDistance >= outerLayerThickness)) continue;
            class_2338 class_23383 = (class_2338)samplePos.element;
            class_2680 class_26803 = ((class_2338)samplePos.element).method_10264() > 0 ? class_2246.field_10340.method_9564() : class_2246.field_28888.method_9564();
            Intrinsics.checkNotNullExpressionValue((Object)class_26803, (String)"if(samplePos.y > 0) Bloc\u2026ks.DEEPSLATE.defaultState");
            this.replaceBlock((Function0<Boolean>)canReplace2, world, class_23383, structurePiece, boundingBox, class_26803, caveDecorators);
        }
    }

    private final void replaceBlock(Function0<Boolean> predicate, class_5281 world, class_2338 samplePos, IStructurePiece structurePiece, class_3341 boundingBox, class_2680 blockState, List<? extends ICaveDecorator> caveDecorators) {
        if (((Boolean)predicate.invoke()).booleanValue()) {
            structurePiece.addBlock(world, blockState, samplePos, boundingBox);
        }
        for (ICaveDecorator iCaveDecorator : caveDecorators) {
            class_2338 class_23382 = new class_2338((class_2382)samplePos);
            class_2248 class_22482 = blockState.method_26204();
            Intrinsics.checkNotNullExpressionValue((Object)class_22482, (String)"blockState.block");
            iCaveDecorator.onBlockPlaced(class_23382, class_22482);
        }
    }
}

