/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.modifiers;

import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;

public class MultiplyPixelModifier
implements IPixelModifier {
    public final int multiplyColor;

    public MultiplyPixelModifier(int multiplyColor) {
        this.multiplyColor = multiplyColor;
    }

    @Override
    public int modifyPixel(int ABGR) {
        if (this.multiplyColor == 0) {
            return ABGR;
        }
        int alpha = ABGR >> 24 & 0xFF;
        int blue = ABGR >> 16 & 0xFF;
        int green = ABGR >> 8 & 0xFF;
        int red = ABGR & 0xFF;
        int tintAlpha = this.multiplyColor >> 24 & 0xFF;
        int tintRed = this.multiplyColor >> 16 & 0xFF;
        int tintGreen = this.multiplyColor >> 8 & 0xFF;
        int tintBlue = this.multiplyColor & 0xFF;
        alpha = Math.min(255, alpha * tintAlpha / 255);
        blue = Math.min(255, blue * tintBlue / 255);
        green = Math.min(255, green * tintGreen / 255);
        red = Math.min(255, red * tintRed / 255);
        return alpha << 24 | blue << 16 | green << 8 | red;
    }

    @Override
    public String getIdSuffix() {
        return this.multiplyColor != 0 ? "_tint" + Integer.toHexString(this.multiplyColor) : "";
    }
}

