/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.modifiers;

import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import io.github.mortuusars.exposure.util.HUSLColorConverter;
import net.minecraft.class_3532;
import org.apache.commons.lang3.StringUtils;

public class AgedHSLUVPixelModifier
implements IPixelModifier {
    public final int tintColor;
    public final double[] tintColorHsluv;
    public final float tintOpacity;
    public final int blackPoint;
    public final int whitePoint;

    public AgedHSLUVPixelModifier(int tintColor, float tintOpacity, int blackPoint, int whitePoint) {
        this.tintColor = tintColor;
        String hexStr = StringUtils.leftPad((String)Integer.toHexString(tintColor & 0xFFFFFF), (int)6, (String)"0");
        this.tintColorHsluv = HUSLColorConverter.hexToHsluv("#" + hexStr);
        this.tintOpacity = tintOpacity;
        this.blackPoint = blackPoint & 0xFF;
        this.whitePoint = whitePoint & 0xFF;
    }

    @Override
    public String getIdSuffix() {
        return "_sepia";
    }

    @Override
    public int modifyPixel(int ABGR) {
        int alpha = ABGR >> 24 & 0xFF;
        int red = ABGR >> 16 & 0xFF;
        int green = ABGR >> 8 & 0xFF;
        int blue = ABGR & 0xFF;
        red = (int)class_3532.method_37959((float)red, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        green = (int)class_3532.method_37959((float)green, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        blue = (int)class_3532.method_37959((float)blue, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        double[] hsluv = HUSLColorConverter.rgbToHsluv(new double[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f});
        hsluv[0] = this.tintColorHsluv[0];
        hsluv[1] = this.tintColorHsluv[1];
        double[] rgb = HUSLColorConverter.hsluvToRgb(hsluv);
        int newRed = class_3532.method_15340((int)((int)class_3532.method_16436((double)this.tintOpacity, (double)red, (double)(rgb[2] * 255.0))), (int)0, (int)255);
        int newGreen = class_3532.method_15340((int)((int)class_3532.method_16436((double)this.tintOpacity, (double)green, (double)(rgb[1] * 255.0))), (int)0, (int)255);
        int newBlue = class_3532.method_15340((int)((int)class_3532.method_16436((double)this.tintOpacity, (double)blue, (double)(rgb[0] * 255.0))), (int)0, (int)255);
        ABGR = alpha << 24 | newRed << 16 | newGreen << 8 | newBlue;
        return ABGR;
    }

    public String toString() {
        return "AgedHSLUVPixelModifier{tintColor=#" + Integer.toHexString(this.tintColor) + ", tintOpacity=" + this.tintOpacity + ", blackPoint=" + this.blackPoint + ", whitePoint=" + this.whitePoint + "}";
    }
}

