/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.render.ExposureTexture;
import net.minecraft.class_1011;
import net.minecraft.class_3620;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposureImage {
    private final String name;
    @Nullable
    private final ExposureSavedData exposureData;
    @Nullable
    private final ExposureTexture texture;

    public ExposureImage(String name, @NotNull ExposureSavedData exposureData) {
        this.name = name;
        this.exposureData = exposureData;
        this.texture = null;
    }

    public ExposureImage(String name, @NotNull ExposureTexture texture) {
        this.name = name;
        this.exposureData = null;
        this.texture = texture;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        if (this.exposureData != null) {
            return this.exposureData.getWidth();
        }
        if (this.texture != null) {
            @Nullable class_1011 image = this.texture.getImage();
            return image != null ? image.method_4307() : 1;
        }
        throw new IllegalStateException("Neither exposureData nor texture was specified.");
    }

    public int getHeight() {
        if (this.exposureData != null) {
            return this.exposureData.getHeight();
        }
        if (this.texture != null) {
            @Nullable class_1011 image = this.texture.getImage();
            return image != null ? image.method_4323() : 1;
        }
        throw new IllegalStateException("Neither exposureData nor texture was specified.");
    }

    public int getPixelABGR(int x, int y) {
        if (this.exposureData != null) {
            return class_3620.method_38480((int)this.exposureData.getPixel(x, y));
        }
        if (this.texture != null) {
            @Nullable class_1011 image = this.texture.getImage();
            return image != null ? image.method_4315(x, y) : 0;
        }
        throw new IllegalStateException("Neither exposureData nor texture was specified.");
    }
}

