/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.fabric;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.fabric.ClientPackets;
import io.github.mortuusars.exposure.network.packet.ExposureDataPartPacket;
import io.github.mortuusars.exposure.network.packet.IPacket;
import io.github.mortuusars.exposure.network.packet.server.AlbumSignC2SP;
import io.github.mortuusars.exposure.network.packet.server.AlbumSyncNoteC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraInHandAddFrameC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetCompositionGuideC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetFlashModeC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetSelfieModeC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetShutterSpeedC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetZoomC2SP;
import io.github.mortuusars.exposure.network.packet.server.DeactivateCamerasInHandC2SP;
import io.github.mortuusars.exposure.network.packet.server.OpenCameraAttachmentsPacketC2SP;
import io.github.mortuusars.exposure.network.packet.server.QueryExposureDataC2SP;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PacketsImpl {
    @Nullable
    private static MinecraftServer server;

    public static void registerC2SPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ExposureDataPartPacket.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(ExposureDataPartPacket::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OpenCameraAttachmentsPacketC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(OpenCameraAttachmentsPacketC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)DeactivateCamerasInHandC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(DeactivateCamerasInHandC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CameraSetZoomC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(CameraSetZoomC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CameraSetCompositionGuideC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(CameraSetCompositionGuideC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CameraSetFlashModeC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(CameraSetFlashModeC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CameraSetShutterSpeedC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(CameraSetShutterSpeedC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CameraInHandAddFrameC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(CameraInHandAddFrameC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CameraSetSelfieModeC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(CameraSetSelfieModeC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)QueryExposureDataC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(QueryExposureDataC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)AlbumSyncNoteC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(AlbumSyncNoteC2SP::fromBuffer));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)AlbumSignC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(AlbumSignC2SP::fromBuffer));
    }

    public static void registerS2CPackets() {
        ClientPackets.registerS2CPackets();
    }

    public static void sendToServer(IPacket packet) {
        ClientPackets.sendToServer(packet);
    }

    public static void sendToClient(IPacket packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)packet.toBuffer(PacketByteBufs.create()));
    }

    public static void sendToAllClients(IPacket packet) {
        if (server == null) {
            LogUtils.getLogger().error("Cannot send a packet to all players. Server is not present.");
            return;
        }
        class_2540 packetBuffer = packet.toBuffer(PacketByteBufs.create());
        for (class_3222 player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)packetBuffer);
        }
    }

    public static void onServerStarting(MinecraftServer server) {
        PacketsImpl.server = server;
    }

    public static void onServerStopped(MinecraftServer server) {
        PacketsImpl.server = null;
    }

    private record ServerHandler(Function<class_2540, IPacket> decodeFunction) implements ServerPlayNetworking.PlayChannelHandler
    {
        public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            IPacket packet = this.decodeFunction.apply(buf);
            packet.handle(PacketDirection.TO_SERVER, (class_1657)player);
        }
    }
}

