/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.menu;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.AlbumPage;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.menu.AlbumPhotographSlot;
import io.github.mortuusars.exposure.menu.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.AlbumSignC2SP;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlbumMenu
extends class_1703 {
    public static final int CANCEL_ADDING_PHOTO_BUTTON = -1;
    public static final int PREVIOUS_PAGE_BUTTON = 0;
    public static final int NEXT_PAGE_BUTTON = 1;
    public static final int LEFT_PAGE_PHOTO_BUTTON = 2;
    public static final int RIGHT_PAGE_PHOTO_BUTTON = 3;
    public static final int ENTER_SIGN_MODE_BUTTON = 4;
    public static final int SIGN_BUTTON = 5;
    public static final int CANCEL_SIGNING_BUTTON = 6;
    protected final ItemAndStack<AlbumItem> album;
    protected final boolean editable;
    protected final List<AlbumPage> pages;
    protected final List<AlbumPhotographSlot> photographSlots = new ArrayList<AlbumPhotographSlot>();
    protected final List<AlbumPlayerInventorySlot> playerInventorySlots = new ArrayList<AlbumPlayerInventorySlot>();
    protected class_3915 currentSpreadIndex = class_3915.method_17403();
    @Nullable
    protected Side sideBeingAddedTo = null;
    protected boolean signing;
    protected String title = "";
    protected final Map<Integer, Consumer<class_1657>> buttonActions = new HashMap<Integer, Consumer<class_1657>>(){
        {
            this.put(-1, p -> {
                AlbumMenu.this.sideBeingAddedTo = null;
                if (!AlbumMenu.this.method_34255().method_7960()) {
                    p.method_31548().method_7398(AlbumMenu.this.method_34255());
                    AlbumMenu.this.method_34254(class_1799.field_8037);
                }
                AlbumMenu.this.updatePlayerInventorySlots();
            });
            this.put(0, p -> {
                AlbumMenu.this.method_7604((class_1657)p, -1);
                AlbumMenu.this.setCurrentSpreadIndex(Math.max(0, AlbumMenu.this.getCurrentSpreadIndex() - 1));
            });
            this.put(1, p -> {
                AlbumMenu.this.method_7604((class_1657)p, -1);
                AlbumMenu.this.setCurrentSpreadIndex(Math.min((AlbumMenu.this.getPages().size() - 1) / 2, AlbumMenu.this.getCurrentSpreadIndex() + 1));
            });
            this.put(2, p -> AlbumMenu.this.onPhotoButtonPress((class_1657)p, Side.LEFT));
            this.put(3, p -> AlbumMenu.this.onPhotoButtonPress((class_1657)p, Side.RIGHT));
            this.put(4, p -> {
                AlbumMenu.this.signing = true;
                AlbumMenu.this.sideBeingAddedTo = null;
            });
            this.put(5, p -> AlbumMenu.this.signAlbum((class_1657)p));
            this.put(6, p -> {
                AlbumMenu.this.signing = false;
            });
        }
    };

    public AlbumMenu(int containerId, class_1661 playerInventory, ItemAndStack<AlbumItem> album, boolean editable) {
        this(Exposure.MenuTypes.ALBUM.get(), containerId, playerInventory, album, editable);
    }

    protected AlbumMenu(class_3917<? extends class_1703> type, int containerId, class_1661 playerInventory, ItemAndStack<AlbumItem> album, boolean editable) {
        super(type, containerId);
        this.album = album;
        this.editable = editable;
        ArrayList albumPages = album.getItem().getPages(album.getStack());
        ArrayList arrayList = this.pages = this.isAlbumEditable() ? new ArrayList(albumPages) : albumPages;
        if (this.isAlbumEditable()) {
            while (this.pages.size() < album.getItem().getMaxPages()) {
                this.addEmptyPage();
            }
        }
        this.addPhotographSlots();
        this.addPlayerInventorySlots(playerInventory, 70, 115);
        this.method_17362(this.currentSpreadIndex);
    }

    private void addPhotographSlots() {
        class_1799[] photographs = (class_1799[])this.pages.stream().map(AlbumPage::getPhotographStack).toArray(class_1799[]::new);
        class_1277 container = new class_1277(photographs);
        for (int i = 0; i < container.method_5439(); ++i) {
            int x = i % 2 == 0 ? 71 : 212;
            int y = 67;
            AlbumPhotographSlot slot = new AlbumPhotographSlot((class_1263)container, i, x, y);
            this.method_7621(slot);
            this.photographSlots.add(slot);
        }
        container.method_5489(c -> {
            List<AlbumPage> pages = this.getPages();
            for (int pageIndex = 0; pageIndex < pages.size(); ++pageIndex) {
                AlbumPage page = pages.get(pageIndex);
                class_1799 stack = container.method_5438(pageIndex);
                page.setPhotographStack(stack);
            }
            this.updateAlbumStack();
        });
    }

    private void addPlayerInventorySlots(class_1661 playerInventory, int x, int y) {
        AlbumPlayerInventorySlot slot;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                slot = new AlbumPlayerInventorySlot((class_1263)playerInventory, column + row * 9 + 9, x + column * 18, y + row * 18);
                this.method_7621(slot);
                this.playerInventorySlots.add(slot);
            }
        }
        for (int index = 0; index < 9; ++index) {
            final boolean disabled = index == playerInventory.field_7545 && playerInventory.method_7391().method_7909() instanceof AlbumItem;
            slot = new AlbumPlayerInventorySlot((class_1263)playerInventory, index, x + index * 18, y + 58){

                public boolean method_7674(class_1657 player) {
                    return !disabled;
                }

                public boolean method_7680(class_1799 stack) {
                    return !disabled;
                }
            };
            this.method_7621(slot);
            this.playerInventorySlots.add(slot);
        }
    }

    protected void updatePlayerInventorySlots() {
        boolean isInAddingPhotographMode = this.isInAddingPhotographMode();
        for (AlbumPlayerInventorySlot slot : this.playerInventorySlots) {
            slot.setActive(isInAddingPhotographMode);
        }
    }

    public boolean isAlbumEditable() {
        return this.editable;
    }

    public boolean isInAddingPhotographMode() {
        return this.getSideBeingAddedTo() != null;
    }

    public boolean isInSigningMode() {
        return this.signing;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String authorName) {
        this.title = authorName;
    }

    public boolean canSignAlbum() {
        for (AlbumPage page : this.getPages()) {
            if (page.getPhotographStack().method_7960() && !page.getNote().left().map(note -> !note.isEmpty()).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected void signAlbum(class_1657 player) {
        if (!player.method_37908().field_9236) {
            return;
        }
        if (!this.canSignAlbum()) {
            throw new IllegalStateException("Cannot sign the album.\n" + Arrays.toString(this.getPages().toArray()));
        }
        Packets.sendToServer(new AlbumSignC2SP(this.title));
    }

    public void updateAlbumStack() {
        List<AlbumPage> pages = this.getPages();
        for (int pageIndex = 0; pageIndex < pages.size(); ++pageIndex) {
            AlbumPage page = pages.get(pageIndex);
            this.album.getItem().setPage(this.album.getStack(), page, pageIndex);
        }
    }

    protected void addEmptyPage() {
        AlbumPage page = this.album.getItem().createEmptyPage();
        this.pages.add(page);
        this.album.getItem().addPage(this.album.getStack(), page);
    }

    public List<AlbumPlayerInventorySlot> getPlayerInventorySlots() {
        return this.playerInventorySlots;
    }

    public List<AlbumPage> getPages() {
        return this.pages;
    }

    public Optional<AlbumPage> getPage(Side side) {
        return this.getPage(this.getCurrentSpreadIndex() * 2 + side.getIndex());
    }

    public Optional<AlbumPage> getPage(int pageIndex) {
        if (pageIndex <= this.getPages().size() - 1) {
            return Optional.ofNullable(this.getPages().get(pageIndex));
        }
        return Optional.empty();
    }

    public Optional<AlbumPhotographSlot> getPhotographSlot(Side side) {
        return this.getPhotographSlot(this.getCurrentSpreadIndex() * 2 + (side == Side.LEFT ? 0 : 1));
    }

    public Optional<AlbumPhotographSlot> getPhotographSlot(int index) {
        if (index >= 0 && index < this.photographSlots.size()) {
            return Optional.ofNullable(this.photographSlots.get(index));
        }
        return Optional.empty();
    }

    public class_1799 getPhotograph(Side side) {
        return this.getPhotographSlot(side).map(class_1735::method_7677).orElse(class_1799.field_8037);
    }

    public int getCurrentSpreadIndex() {
        return this.currentSpreadIndex.method_17407();
    }

    public void setCurrentSpreadIndex(int spreadIndex) {
        this.currentSpreadIndex.method_17404(spreadIndex);
    }

    @Nullable
    public Side getSideBeingAddedTo() {
        return this.sideBeingAddedTo;
    }

    public boolean method_7604(class_1657 player, int id) {
        @Nullable Consumer<class_1657> buttonAction = this.buttonActions.get(id);
        if (buttonAction != null) {
            buttonAction.accept(player);
            return true;
        }
        return false;
    }

    private void onPhotoButtonPress(class_1657 player, Side side) {
        Preconditions.checkArgument((boolean)this.isAlbumEditable(), (Object)("Photo Button should be disabled and hidden when Album is not editable. " + this.album.getStack()));
        Optional<AlbumPhotographSlot> photographSlot = this.getPhotographSlot(side);
        if (photographSlot.isEmpty()) {
            return;
        }
        AlbumPhotographSlot slot = photographSlot.get();
        if (!slot.method_7681()) {
            this.sideBeingAddedTo = side;
        } else {
            class_1799 stack = slot.method_7677();
            if (!player.method_31548().method_7394(stack)) {
                player.method_7328(stack, false);
            }
            slot.method_7673(class_1799.field_8037);
        }
        this.updatePlayerInventorySlots();
    }

    public void method_7593(int slotId, int button, class_1713 clickType, class_1657 player) {
        if (this.sideBeingAddedTo == null || slotId < 0 || slotId >= this.field_7761.size()) {
            super.method_7593(slotId, button, clickType, player);
            return;
        }
        class_1735 slot = (class_1735)this.field_7761.get(slotId);
        class_1799 stack = slot.method_7677();
        if (button == 0 && slot instanceof AlbumPlayerInventorySlot && stack.method_7909() instanceof PhotographItem && this.method_34255().method_7960()) {
            int pageIndex = this.getCurrentSpreadIndex() * 2 + this.sideBeingAddedTo.getIndex();
            Optional<AlbumPhotographSlot> photographSlot = this.getPhotographSlot(pageIndex);
            if (photographSlot.isEmpty() || !photographSlot.get().method_7677().method_7960()) {
                return;
            }
            photographSlot.get().method_7673(stack);
            slot.method_7673(class_1799.field_8037);
            if (player.method_37908().field_9236) {
                player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_PLACE.get(), 0.8f, 1.1f);
            }
            this.sideBeingAddedTo = null;
            this.updatePlayerInventorySlots();
        } else {
            super.method_7593(slotId, button, clickType, player);
        }
    }

    @NotNull
    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return !this.isAlbumEditable() || player.method_6047().method_7909() instanceof AlbumItem || player.method_6079().method_7909() instanceof AlbumItem;
    }

    public static AlbumMenu fromBuffer(int containerId, class_1661 inventory, class_2540 buffer) {
        return new AlbumMenu(containerId, inventory, new ItemAndStack<AlbumItem>(buffer.method_10819()), buffer.readBoolean());
    }
}

