/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class AlbumPage {
    public static final String PHOTOGRAPH_TAG = "Photo";
    public static final String NOTE_TAG = "Note";
    public static final String NOTE_COMPONENT_TAG = "NoteComponent";
    private class_1799 photographStack;
    private Either<String, class_2561> note;

    public AlbumPage(class_1799 photographStack, Either<String, class_2561> note) {
        this.photographStack = photographStack;
        this.note = note;
    }

    public static AlbumPage editable(class_1799 photographStack, String note) {
        return new AlbumPage(photographStack, (Either<String, class_2561>)Either.left((Object)note));
    }

    public static AlbumPage signed(class_1799 photographStack, class_2561 note) {
        return new AlbumPage(photographStack, (Either<String, class_2561>)Either.right((Object)note));
    }

    public boolean isEditable() {
        return this.note.left().isPresent();
    }

    public boolean isEmpty() {
        return this.photographStack.method_7960() && (Boolean)this.note.map(String::isEmpty, c -> c.getString().isEmpty()) != false;
    }

    public static AlbumPage fromTag(class_2487 tag, boolean editable) {
        class_1799 photographStack;
        class_1799 class_17992 = photographStack = tag.method_10573(PHOTOGRAPH_TAG, 10) ? class_1799.method_7915((class_2487)tag.method_10562(PHOTOGRAPH_TAG)) : class_1799.field_8037;
        if (editable) {
            class_5250 component;
            String note = tag.method_10573(NOTE_TAG, 8) ? tag.method_10558(NOTE_TAG) : (tag.method_10545(NOTE_COMPONENT_TAG) ? ((component = class_2561.class_2562.method_10877((String)tag.method_10558(NOTE_COMPONENT_TAG))) != null ? component.method_10858(512) : "") : "");
            return AlbumPage.editable(photographStack, note);
        }
        class_5250 note = tag.method_10573(NOTE_COMPONENT_TAG, 8) ? class_2561.class_2562.method_10877((String)tag.method_10558(NOTE_COMPONENT_TAG)) : (tag.method_10545(NOTE_TAG) ? class_2561.method_43470((String)tag.method_10558(NOTE_TAG)) : class_2561.method_43473());
        return AlbumPage.signed(photographStack, (class_2561)note);
    }

    public class_2487 toTag(class_2487 tag) {
        if (!this.photographStack.method_7960()) {
            tag.method_10566(PHOTOGRAPH_TAG, (class_2520)this.photographStack.method_7953(new class_2487()));
        }
        this.note.ifLeft(string -> {
            if (!string.isEmpty()) {
                tag.method_10582(NOTE_TAG, string);
            }
        }).ifRight(component -> tag.method_10582(NOTE_COMPONENT_TAG, class_2561.class_2562.method_10867((class_2561)component)));
        return tag;
    }

    public class_1799 getPhotographStack() {
        return this.photographStack;
    }

    public class_1799 setPhotographStack(class_1799 photographStack) {
        class_1799 existingStack = this.photographStack;
        this.photographStack = photographStack;
        return existingStack;
    }

    public Either<String, class_2561> getNote() {
        return this.note;
    }

    public void setNote(Either<String, class_2561> note) {
        this.note = note;
    }

    public AlbumPage toSigned() {
        if (!this.isEditable()) {
            return this;
        }
        class_5250 noteComponent = class_2561.method_43470((String)((String)this.getNote().left().orElseThrow()));
        return AlbumPage.signed(this.getPhotographStack(), (class_2561)noteComponent);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AlbumPage that = (AlbumPage)obj;
        return Objects.equals(this.photographStack, that.photographStack) && Objects.equals(this.note, that.note);
    }

    public int hashCode() {
        return Objects.hash(this.photographStack, this.note);
    }

    public String toString() {
        return "Page[photo=" + this.photographStack + ", note=" + this.note + "]";
    }
}

