/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.item.AlbumPage;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3715;
import net.minecraft.class_3908;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlbumItem
extends class_1792 {
    public static final String TAG_PAGES = "Pages";
    public static final String TAG_TITLE = "Title";
    public static final String TAG_AUTHOR = "Author";

    public AlbumItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public int getMaxPages() {
        return 16;
    }

    public boolean isEditable() {
        return true;
    }

    public Optional<AlbumPage> getPage(class_1799 albumStack, int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getMaxPages());
        class_2487 tag = albumStack.method_7969();
        if (tag == null || tag.method_33133() || !tag.method_10573(TAG_PAGES, 9)) {
            return Optional.empty();
        }
        class_2499 pagesTag = this.getOrCreatePagesTag(albumStack);
        return pagesTag.size() - 1 >= index ? Optional.ofNullable(AlbumPage.fromTag(pagesTag.method_10602(index), this.isEditable())) : Optional.empty();
    }

    public void setPage(class_1799 albumStack, AlbumPage page, int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getMaxPages());
        class_2499 pagesTag = this.getOrCreatePagesTag(albumStack);
        while (pagesTag.size() - 1 < index) {
            pagesTag.add((Object)this.createEmptyPage().toTag(new class_2487()));
        }
        pagesTag.method_10606(index, (class_2520)page.toTag(new class_2487()));
    }

    public AlbumPage createEmptyPage() {
        return new AlbumPage(class_1799.field_8037, (Either<String, class_2561>)(this.isEditable() ? Either.left((Object)"") : Either.right((Object)class_2561.method_43473())));
    }

    public List<AlbumPage> getPages(class_1799 albumStack) {
        class_2487 tag = albumStack.method_7969();
        if (tag == null || tag.method_33133() || !tag.method_10573(TAG_PAGES, 9)) {
            return Collections.emptyList();
        }
        class_2499 pagesList = tag.method_10554(TAG_PAGES, 10);
        if (pagesList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AlbumPage> pages = new ArrayList<AlbumPage>();
        for (int i = 0; i < pagesList.size(); ++i) {
            pages.add(AlbumPage.fromTag(pagesList.method_10602(i), this.isEditable()));
        }
        return pages;
    }

    public void addPage(class_1799 albumStack, AlbumPage page) {
        class_2499 pages = this.getOrCreatePagesTag(albumStack);
        pages.add((Object)page.toTag(new class_2487()));
    }

    public void addPage(class_1799 albumStack, AlbumPage page, int index) {
        class_2499 pages = this.getOrCreatePagesTag(albumStack);
        pages.method_10531(index, (class_2520)page.toTag(new class_2487()));
    }

    public int getPhotographsCount(class_1799 albumStack) {
        @Nullable class_2487 tag = albumStack.method_7969();
        if (tag == null || !tag.method_10573(TAG_PAGES, 9)) {
            return 0;
        }
        int count = 0;
        class_2499 pagesTag = tag.method_10554(TAG_PAGES, 10);
        for (int i = 0; i < pagesTag.size(); ++i) {
            class_2487 pageTag = pagesTag.method_10602(i);
            if (!pageTag.method_10573("Photo", 10)) continue;
            ++count;
        }
        return count;
    }

    protected class_2499 getOrCreatePagesTag(class_1799 albumStack) {
        class_2487 tag = albumStack.method_7948();
        class_2499 list = tag.method_10554(TAG_PAGES, 10);
        tag.method_10566(TAG_PAGES, (class_2520)list);
        return list;
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemStack = player.method_5998(usedHand);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.open(serverPlayer, itemStack, this.isEditable());
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        return class_1271.method_29237((Object)itemStack, (boolean)level.method_8608());
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_2338 blockPos = context.method_8037();
        class_1937 level = context.method_8045();
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState.method_27852(class_2246.field_16330)) {
            return class_3715.method_17472((class_1297)context.method_8036(), (class_1937)level, (class_2338)blockPos, (class_2680)blockState, (class_1799)context.method_8041()) ? class_1269.method_29236((boolean)level.field_9236) : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public void open(class_3222 player, final class_1799 albumStack, final boolean editable) {
        class_3908 menuProvider = new class_3908(){

            @NotNull
            public class_2561 method_5476() {
                return albumStack.method_7964();
            }

            @NotNull
            public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                return new AlbumMenu(containerId, playerInventory, new ItemAndStack<AlbumItem>(albumStack), editable);
            }
        };
        PlatformHelper.openMenu(player, menuProvider, buffer -> {
            buffer.method_10793(albumStack);
            buffer.writeBoolean(editable);
        });
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        int photographsCount;
        if (((Boolean)Config.Client.ALBUM_SHOW_PHOTOS_COUNT.get()).booleanValue() && (photographsCount = this.getPhotographsCount(stack)) > 0) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.exposure.album.tooltip.photos_count", (Object[])new Object[]{photographsCount}));
        }
    }

    public boolean shouldPlayEquipAnimation(class_1799 oldStack, class_1799 newStack) {
        return oldStack.method_7909() != newStack.method_7909();
    }

    public class_1799 sign(class_1799 album, String title, String author) {
        class_2487 pageTag;
        AlbumPage page;
        int i;
        if (!(album.method_7909() instanceof AlbumItem)) {
            throw new IllegalArgumentException("Can only sign AlbumItem's. Provided: '" + album + "'.");
        }
        if (!this.isEditable()) {
            throw new IllegalArgumentException("Cannot sign fixed album.");
        }
        class_1799 albumCopy = album.method_7972();
        class_2499 pagesTag = this.getOrCreatePagesTag(albumCopy);
        for (i = pagesTag.size() - 1; i >= 0 && (page = AlbumPage.fromTag(pageTag = pagesTag.method_10602(i), this.isEditable())).isEmpty(); --i) {
            pagesTag.method_10536(i);
        }
        for (i = 0; i < pagesTag.size(); ++i) {
            AlbumPage page2 = AlbumPage.fromTag(pagesTag.method_10602(i), this.isEditable());
            pagesTag.method_10606(i, (class_2520)page2.toSigned().toTag(new class_2487()));
        }
        class_1799 signedAlbum = new class_1799((class_1935)Exposure.Items.SIGNED_ALBUM.get());
        signedAlbum.method_7980(albumCopy.method_7969());
        signedAlbum.method_7948().method_10582(TAG_TITLE, title);
        signedAlbum.method_7948().method_10582(TAG_AUTHOR, author);
        return signedAlbum;
    }
}

