/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.element;

import io.github.mortuusars.exposure.gui.screen.element.textbox.HorizontalAlignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8001;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlock
extends class_339 {
    public int fontColor = -16777216;
    public boolean drawShadow = false;
    public HorizontalAlignment alignment = HorizontalAlignment.LEFT;
    private final class_327 font;
    private final Function<class_2583, Boolean> componentClickedHandler;
    private List<class_5481> renderedLines;
    private List<class_5481> tooltipLines;

    public TextBlock(class_327 font, int x, int y, int width, int height, class_2561 message, Function<class_2583, Boolean> componentClickedHandler) {
        super(x, y, width, height, message);
        this.font = font;
        this.componentClickedHandler = componentClickedHandler;
        this.makeLines();
    }

    public void method_25355(class_2561 message) {
        super.method_25355(message);
        this.makeLines();
    }

    protected void makeLines() {
        class_2561 text = this.method_25369();
        List lines = this.font.method_1728((class_5348)text, this.method_25368());
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int availableLines = Math.min(n, this.field_22759 / 9);
        ArrayList<class_5481> visibleLines = new ArrayList<class_5481>();
        for (int i = 0; i < availableLines; ++i) {
            class_5481 line = (class_5481)lines.get(i);
            if (i == availableLines - 1 && availableLines < lines.size()) {
                line = class_5481.method_30742((class_5481)line, (class_5481)class_2561.method_43470((String)"...").method_27696(text.method_10866()).method_30937());
            }
            visibleLines.add(line);
        }
        List hiddenLines = Collections.emptyList();
        if (availableLines < lines.size()) {
            hiddenLines = new ArrayList(lines.stream().skip(availableLines).toList());
            hiddenLines.set(0, class_5481.method_30742((class_5481)class_5481.method_30747((String)"...", (class_2583)text.method_10866()), (class_5481)((class_5481)hiddenLines.get(0))));
        }
        this.renderedLines = visibleLines;
        this.tooltipLines = hiddenLines;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_2583 style = this.getClickedComponentStyleAt(mouseX, mouseY);
        return button == 0 && style != null && this.componentClickedHandler.apply(style) != false;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }

    @NotNull
    protected class_5250 method_25360() {
        return this.method_25369().method_27661();
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_2583 style;
        for (int i = 0; i < this.renderedLines.size(); ++i) {
            class_5481 line = this.renderedLines.get(i);
            int x = this.method_46426() + this.alignment.align(this.method_25368(), this.font.method_30880(line));
            int n = this.method_46427();
            Objects.requireNonNull(this.font);
            guiGraphics.method_51430(this.font, line, x, n + 9 * i, this.fontColor, this.drawShadow);
        }
        if (this.method_49606() && (style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            guiGraphics.method_51441(this.font, style, mouseX, mouseY);
        }
        if (!this.tooltipLines.isEmpty() && this.method_25405(mouseX, mouseY)) {
            guiGraphics.method_51436(this.font, this.tooltipLines, class_8001.field_41687, mouseX, mouseY);
        }
    }

    @Nullable
    public class_2583 getClickedComponentStyleAt(double mouseX, double mouseY) {
        if (this.renderedLines.isEmpty()) {
            return null;
        }
        int x = class_3532.method_15357((double)(mouseX - (double)this.method_46426()));
        int y = class_3532.method_15357((double)(mouseY - (double)this.method_46427()));
        if (x < 0 || y < 0 || x > this.method_25368() || y > this.method_25364()) {
            return null;
        }
        Objects.requireNonNull(this.font);
        int hoveredLine = y / 9;
        if (hoveredLine >= this.renderedLines.size()) {
            return null;
        }
        class_5481 line = this.renderedLines.get(hoveredLine);
        int lineStart = this.alignment.align(this.method_25368(), this.font.method_30880(line));
        if (x < lineStart) {
            return null;
        }
        return this.font.method_27527().method_30876(line, x - lineStart);
    }
}

