/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderOverlay;
import io.github.mortuusars.exposure.client.MouseHandler;
import io.github.mortuusars.exposure.gui.screen.camera.button.CompositionGuideButton;
import io.github.mortuusars.exposure.gui.screen.camera.button.FlashModeButton;
import io.github.mortuusars.exposure.gui.screen.camera.button.FocalLengthButton;
import io.github.mortuusars.exposure.gui.screen.camera.button.FrameCounterButton;
import io.github.mortuusars.exposure.gui.screen.camera.button.ShutterSpeedButton;
import io.github.mortuusars.exposure.gui.screen.element.IElementWithTooltip;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;

public class ViewfinderControlsScreen
extends class_437 {
    public static final class_2960 TEXTURE = Exposure.resource("textures/gui/viewfinder/viewfinder_camera_controls.png");
    private final class_1657 player;
    private final class_638 level;
    private final long openedAtTimestamp;

    public ViewfinderControlsScreen() {
        super((class_2561)class_2561.method_43473());
        this.player = class_310.method_1551().field_1724;
        this.level = class_310.method_1551().field_1687;
        assert (this.level != null);
        this.openedAtTimestamp = this.level.method_8510();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        this.refreshMovementKeys();
        class_310.method_1551().method_1508();
    }

    protected void method_25426() {
        super.method_25426();
        this.refreshMovementKeys();
        int leftPos = (this.field_22789 - 256) / 2;
        int topPos = Math.round(ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height - 256.0f);
        CameraInHand camera = CameraInHand.getActive(this.player);
        Preconditions.checkState((!camera.isEmpty() ? 1 : 0) != 0, (Object)"Player should hold an Active Camera at this point.");
        boolean hasFlashAttached = camera.getItem().getAttachment(camera.getStack(), CameraItem.FLASH_ATTACHMENT).isPresent();
        int sideButtonsWidth = 48;
        int buttonWidth = 15;
        int elementX = leftPos + 128 - (sideButtonsWidth + 1 + buttonWidth + 1 + (hasFlashAttached ? buttonWidth + 1 : 0) + sideButtonsWidth) / 2;
        int elementY = topPos + 238;
        ShutterSpeedButton shutterSpeedButton = new ShutterSpeedButton(this, leftPos + 94, topPos + 226, 69, 12, 112, 0, TEXTURE);
        this.method_37063((class_364)shutterSpeedButton);
        FocalLengthButton focalLengthButton = new FocalLengthButton(this, elementX, elementY, 48, 18, 0, 0, TEXTURE);
        this.method_37060((class_4068)focalLengthButton);
        class_344 separator1 = new class_344(elementX += focalLengthButton.method_25368(), elementY, 1, 18, 111, 0, TEXTURE, pButton -> {});
        this.method_37060((class_4068)separator1);
        CompositionGuideButton compositionGuideButton = new CompositionGuideButton(this, elementX += separator1.method_25368(), elementY, 15, 18, 48, 0, TEXTURE);
        this.method_37063((class_364)compositionGuideButton);
        class_344 separator2 = new class_344(elementX += compositionGuideButton.method_25368(), elementY, 1, 18, 111, 0, TEXTURE, pButton -> {});
        this.method_37060((class_4068)separator2);
        elementX += separator2.method_25368();
        if (hasFlashAttached) {
            FlashModeButton flashModeButton = new FlashModeButton(this, elementX, elementY, 15, 18, 48, 0, TEXTURE);
            this.method_37063((class_364)flashModeButton);
            class_344 separator3 = new class_344(elementX += flashModeButton.method_25368(), elementY, 1, 18, 111, 0, TEXTURE, pButton -> {});
            this.method_37060((class_4068)separator3);
            elementX += separator3.method_25368();
        }
        FrameCounterButton frameCounterButton = new FrameCounterButton(this, elementX, elementY, 48, 18, 63, 0, TEXTURE);
        this.method_37060((class_4068)frameCounterButton);
    }

    private void refreshMovementKeys() {
        Consumer<class_304> update = keyMapping -> {
            if (keyMapping.field_1655.method_1442() == class_3675.class_307.field_1672) {
                keyMapping.method_23481(MouseHandler.isMouseButtonHeld(keyMapping.field_1655.method_1444()));
            } else {
                long windowId = class_310.method_1551().method_22683().method_4490();
                keyMapping.method_23481(class_3675.method_15987((long)windowId, (int)keyMapping.field_1655.method_1444()));
            }
        };
        update.accept(ExposureClient.getCameraControlsKey());
        class_315 opt = class_310.method_1551().field_1690;
        update.accept(opt.field_1894);
        update.accept(opt.field_1881);
        update.accept(opt.field_1913);
        update.accept(opt.field_1849);
        update.accept(opt.field_1903);
        update.accept(opt.field_1867);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!ViewfinderClient.isLookingThrough()) {
            this.method_25419();
            return;
        }
        if (class_310.method_1551().field_1690.field_1842) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        float viewfinderScale = ViewfinderOverlay.getScale();
        if (viewfinderScale != 1.0f) {
            guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
            guiGraphics.method_51448().method_22905(viewfinderScale, viewfinderScale, viewfinderScale);
            guiGraphics.method_51448().method_46416((float)(-this.field_22789) / 2.0f, (float)(-this.field_22790) / 2.0f, 0.0f);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        for (class_4068 renderable : this.field_33816) {
            if (!(renderable instanceof IElementWithTooltip)) continue;
            IElementWithTooltip tooltipElement = (IElementWithTooltip)renderable;
            if (!(renderable instanceof class_339)) continue;
            class_339 widget = (class_339)renderable;
            if (!widget.field_22764 || !widget.method_25367()) continue;
            tooltipElement.renderToolTip(guiGraphics, mouseX, mouseY);
            break;
        }
        guiGraphics.method_51448().method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1 && class_310.method_1551().field_1761 != null) {
            class_1799 itemInHand;
            class_1268 activeHand = CameraInHand.getActiveHand(this.player);
            if (activeHand != null && (itemInHand = this.player.method_5998(activeHand)).method_7909() instanceof CameraItem) {
                class_310.method_1551().field_1761.method_2919(this.player, activeHand);
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (ExposureClient.getCameraControlsKey().method_1433(button) || ((Boolean)Config.Client.VIEWFINDER_MIDDLE_CLICK_CONTROLS.get()).booleanValue() && button == 2) {
            if (this.level.method_8510() - this.openedAtTimestamp >= 5L) {
                this.method_25419();
            }
            return false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (ExposureClient.getCameraControlsKey().method_1417(keyCode, scanCode)) {
            if (this.level.method_8510() - this.openedAtTimestamp >= 5L) {
                this.method_25419();
            }
            return false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Preconditions.checkState((this.field_22787 != null ? 1 : 0) != 0);
        boolean handled = super.method_25404(keyCode, scanCode, modifiers);
        if (handled) {
            return true;
        }
        if (keyCode == 334 || keyCode == 61) {
            ViewfinderClient.zoom(ZoomDirection.IN, true);
            return true;
        }
        if (keyCode == 333 || keyCode == 45) {
            ViewfinderClient.zoom(ZoomDirection.OUT, true);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!super.method_25401(mouseX, mouseY, delta)) {
            ViewfinderClient.zoom(delta > 0.0 ? ZoomDirection.IN : ZoomDirection.OUT, true);
            return true;
        }
        return false;
    }
}

