/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.album;

import com.google.common.collect.Lists;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.render.PhotographRenderProperties;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_768;
import net.minecraft.class_8494;

public class PhotographSlotButton
extends class_344 {
    protected final class_768 exposureArea;
    protected final class_4185.class_4241 onRightButtonPress;
    protected final Supplier<class_1799> photograph;
    protected final boolean isEditable;
    protected boolean hasPhotograph;

    public PhotographSlotButton(class_768 exposureArea, int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffTex, class_2960 resourceLocation, int textureWidth, int textureHeight, class_4185.class_4241 onLeftButtonPress, class_4185.class_4241 onRightButtonPress, Supplier<class_1799> photographGetter, boolean isEditable) {
        super(x, y, width, height, xTexStart, yTexStart, yDiffTex, resourceLocation, textureWidth, textureHeight, onLeftButtonPress, (class_2561)class_2561.method_43471((String)"item.exposure.photograph"));
        this.exposureArea = exposureArea;
        this.onRightButtonPress = onRightButtonPress;
        this.photograph = photographGetter;
        this.isEditable = isEditable;
    }

    public class_1799 getPhotograph() {
        return this.photograph.get();
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_1799 photograph = this.getPhotograph();
        if (photograph.method_7909() instanceof PhotographItem) {
            this.hasPhotograph = true;
            PhotographRenderProperties renderProperties = PhotographRenderProperties.get(photograph);
            this.method_48588(guiGraphics, renderProperties.getAlbumPaperTexture(), this.method_46426(), this.method_46427(), 0, 0, 0, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
            guiGraphics.method_51448().method_22903();
            float scale = (float)this.exposureArea.method_3319() / (float)ExposureClient.getExposureRenderer().getSize();
            guiGraphics.method_51448().method_46416((float)this.exposureArea.method_3321(), (float)this.exposureArea.method_3322(), 1.0f);
            guiGraphics.method_51448().method_22905(scale, scale, scale);
            class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            PhotographRenderer.render(photograph, false, false, guiGraphics.method_51448(), (class_4597)bufferSource, 0xF000F0, 255, 255, 255, 255);
            bufferSource.method_22993();
            guiGraphics.method_51448().method_22909();
            if (renderProperties.hasAlbumPaperOverlayTexture()) {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0.0f, 0.0f, 2.0f);
                this.method_48588(guiGraphics, renderProperties.getAlbumPaperOverlayTexture(), this.method_46426(), this.method_46427(), 0, 0, 0, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
                guiGraphics.method_51448().method_22909();
            }
        } else {
            this.hasPhotograph = false;
        }
        int xTex = this.field_2126 + (this.hasPhotograph ? this.method_25368() : 0);
        this.method_48588(guiGraphics, this.field_2127, this.method_46426(), this.method_46427(), xTex, this.field_2125, this.field_19079, this.field_22758, this.field_22759, this.field_2124, this.field_19080);
    }

    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isEditable && !this.hasPhotograph) {
            guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"gui.exposure.album.add_photograph"), mouseX, mouseY);
            return;
        }
        class_1799 photograph = this.getPhotograph();
        if (photograph.method_7960()) {
            return;
        }
        List itemTooltip = class_437.method_25408((class_310)class_310.method_1551(), (class_1799)photograph);
        itemTooltip.add(class_2561.method_43471((String)"gui.exposure.album.left_click_or_scroll_up_to_view"));
        if (this.isEditable) {
            itemTooltip.add(class_2561.method_43471((String)"gui.exposure.album.right_click_to_remove"));
        }
        if (this.method_25370()) {
            guiGraphics.method_51436(class_310.method_1551().field_1772, Lists.transform((List)itemTooltip, class_2561::method_30937), this.method_47937(), mouseX, mouseY);
        } else {
            guiGraphics.method_51437(class_310.method_1551().field_1772, itemTooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!(this.field_22763 && this.field_22764 && this.method_25361(mouseX, mouseY))) {
            return false;
        }
        if (button == 0) {
            this.field_22767.onPress((class_4185)this);
        } else if (button == 1) {
            this.onRightButtonPress.onPress((class_4185)this);
        } else {
            return false;
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta > 0.0 && this.method_25361(mouseX, mouseY) && this.hasPhotograph) {
            this.field_22767.onPress((class_4185)this);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22763 && this.field_22764 && class_437.method_25442() && class_8494.method_51255((int)keyCode)) {
            this.onRightButtonPress.onPress((class_4185)this);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

