/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.album;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.gui.screen.album.AlbumPhotographScreen;
import io.github.mortuusars.exposure.gui.screen.album.AlbumSigningScreen;
import io.github.mortuusars.exposure.gui.screen.album.PhotographSlotButton;
import io.github.mortuusars.exposure.gui.screen.element.Pager;
import io.github.mortuusars.exposure.gui.screen.element.TextBlock;
import io.github.mortuusars.exposure.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.gui.screen.element.textbox.TextBox;
import io.github.mortuusars.exposure.item.AlbumPage;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.menu.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.AlbumSyncNoteC2SP;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.util.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_636;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlbumScreen
extends class_465<AlbumMenu> {
    public static final class_2960 TEXTURE = Exposure.resource("textures/gui/album.png");
    public static final int MAIN_FONT_COLOR = -4876428;
    public static final int SECONDARY_FONT_COLOR = -1055542;
    public static final int SELECTION_COLOR = -7829249;
    public static final int SELECTION_UNFOCUSED_COLOR = -4473857;
    @NotNull
    protected final class_310 minecraft;
    @NotNull
    protected final class_1657 player;
    @NotNull
    protected final class_636 gameMode;
    protected final Pager pager = new Pager(class_3417.field_17481){

        @Override
        public void onPageChanged(PagingDirection pagingDirection, int prevPage, int currentPage) {
            super.onPageChanged(pagingDirection, prevPage, currentPage);
            AlbumScreen.this.sendButtonClick(pagingDirection == PagingDirection.PREVIOUS ? 0 : 1);
        }
    };
    protected final List<Page> pages = new ArrayList<Page>();
    @Nullable
    protected class_4185 enterSignModeButton;

    public AlbumScreen(AlbumMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.minecraft = class_310.method_1551();
        this.player = (class_1657)Objects.requireNonNull(this.minecraft.field_1724);
        this.gameMode = Objects.requireNonNull(this.minecraft.field_1761);
    }

    protected void method_37432() {
        this.forEachPage(page -> page.noteWidget.ifLeft(TextBox::tick));
    }

    protected void method_25426() {
        this.field_2792 = 298;
        this.field_2779 = 188;
        super.method_25426();
        this.field_25268 = -999;
        this.field_25269 = 69;
        this.field_25270 = -999;
        this.pages.clear();
        Page leftPage = this.createPage(Side.LEFT, 0);
        this.pages.add(leftPage);
        class_344 previousButton = new class_344(this.field_2776 + 12, this.field_2800 + 164, 13, 15, 216, 188, 15, TEXTURE, 512, 512, button -> this.pager.changePage(PagingDirection.PREVIOUS), (class_2561)class_2561.method_43471((String)"gui.exposure.previous_page"));
        previousButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.previous_page")));
        this.method_37063((class_364)previousButton);
        Page rightPage = this.createPage(Side.RIGHT, 140);
        this.pages.add(rightPage);
        class_344 nextButton = new class_344(this.field_2776 + 273, this.field_2800 + 164, 13, 15, 229, 188, 15, TEXTURE, 512, 512, button -> this.pager.changePage(PagingDirection.NEXT), (class_2561)class_2561.method_43471((String)"gui.exposure.next_page"));
        nextButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.next_page")));
        this.method_37063((class_364)nextButton);
        if (((AlbumMenu)this.method_17577()).isAlbumEditable()) {
            this.enterSignModeButton = new class_344(this.field_2776 - 23, this.field_2800 + 17, 22, 22, 242, 188, 22, TEXTURE, 512, 512, b -> this.enterSignMode(), (class_2561)class_2561.method_43471((String)"gui.exposure.album.sign"));
            this.enterSignModeButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.album.sign")));
            this.method_37063((class_364)this.enterSignModeButton);
        }
        int spreadsCount = (int)Math.ceil((float)((AlbumMenu)this.method_17577()).getPages().size() / 2.0f);
        this.pager.init(spreadsCount, false, (class_4264)previousButton, (class_4264)nextButton);
    }

    protected Page createPage(Side side, int xOffset) {
        Either noteWidget;
        int x = this.field_2776 + xOffset;
        int y = this.field_2800;
        class_768 page = new class_768(x, y, 149, 188);
        class_768 photo = new class_768(x + 25, y + 21, 108, 108);
        class_768 exposure = new class_768(x + 31, y + 27, 96, 96);
        class_768 note = new class_768(x + 22, y + 133, 114, 27);
        PhotographSlotButton photographButton = new PhotographSlotButton(exposure, photo.method_3321(), photo.method_3322(), photo.method_3319(), photo.method_3320(), 0, 188, 108, TEXTURE, 512, 512, b -> {
            PhotographSlotButton button = (PhotographSlotButton)b;
            class_1799 photograph = button.getPhotograph();
            if (photograph.method_7960()) {
                if (button.isEditable) {
                    this.sendButtonClick(side == Side.LEFT ? 2 : 3);
                    button.method_25354(this.minecraft.method_1483());
                }
            } else {
                this.inspectPhotograph(photograph);
            }
        }, b -> {
            PhotographSlotButton button = (PhotographSlotButton)b;
            if (button.isEditable && !button.getPhotograph().method_7960()) {
                this.sendButtonClick(side == Side.LEFT ? 2 : 3);
                this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Exposure.SoundEvents.PHOTOGRAPH_PLACE.get(), (float)0.7f, (float)1.1f));
            }
        }, () -> ((AlbumMenu)this.method_17577()).getPhotograph(side), ((AlbumMenu)this.method_17577()).isAlbumEditable()){

            @Override
            public boolean method_25402(double mouseX, double mouseY, int button) {
                return !AlbumScreen.this.isInAddingMode() && super.method_25402(mouseX, mouseY, button);
            }

            public boolean method_49606() {
                return !AlbumScreen.this.isInAddingMode() && super.method_49606();
            }
        };
        this.method_37063((class_364)photographButton);
        if (((AlbumMenu)this.method_17577()).isAlbumEditable()) {
            TextBox textBox = new TextBox(this.field_22793, note.method_3321(), note.method_3322(), note.method_3319(), note.method_3320(), () -> ((AlbumMenu)this.method_17577()).getPage(side).map(p -> (String)p.getNote().left().orElseThrow()).orElse(""), text -> this.onNoteChanged(side, (String)text)).setFontColor(-4876428, -4876428).setSelectionColor(-7829249, -4473857);
            textBox.horizontalAlignment = HorizontalAlignment.CENTER;
            this.method_37063((class_364)textBox);
            noteWidget = Either.left((Object)((Object)textBox));
        } else {
            TextBlock textBlock = new TextBlock(this.field_22793, note.method_3321(), note.method_3322(), note.method_3319(), note.method_3320(), this.getNoteComponent(side), this::method_25430);
            textBlock.fontColor = -4876428;
            textBlock.alignment = HorizontalAlignment.CENTER;
            textBlock.drawShadow = false;
            noteWidget = Either.right((Object)((Object)textBlock));
        }
        return new Page(side, page, photo, exposure, note, photographButton, (Either<TextBox, TextBlock>)noteWidget);
    }

    protected void onNoteChanged(Side side, String noteText) {
        ((AlbumMenu)this.method_17577()).getPage(side).ifPresent(page -> {
            page.setNote((Either<String, class_2561>)Either.left((Object)noteText));
            int pageIndex = ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex() * 2 + side.getIndex();
            Packets.sendToServer(new AlbumSyncNoteC2SP(pageIndex, noteText));
        });
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.pager.update();
        if (this.enterSignModeButton != null) {
            this.enterSignModeButton.field_22764 = ((AlbumMenu)this.method_17577()).canSignAlbum();
        }
        boolean isInAddingPhotographMode = this.isInAddingMode();
        this.forEachPage(page -> {
            page.getNoteWidget().field_22764 = !isInAddingPhotographMode;
        });
        for (Page page2 : this.pages) {
            page2.photographButton.field_22764 = !((AlbumMenu)this.method_17577()).getPhotograph(page2.side).method_7960() || !isInAddingPhotographMode && ((AlbumMenu)this.method_17577()).isAlbumEditable();
        }
        this.field_25270 = isInAddingPhotographMode ? ((AlbumMenu)this.method_17577()).getPlayerInventorySlots().get((int)0).field_7872 - 12 : -999;
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        for (Page page2 : this.pages) {
            class_339 noteWidget = page2.getNoteWidget();
            if (!(noteWidget instanceof TextBlock)) continue;
            TextBlock textBlock = (TextBlock)noteWidget;
            textBlock.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (isInAddingPhotographMode) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (class_1735 slot : ((AlbumMenu)this.method_17577()).field_7761) {
                if (slot.method_7677().method_7960() || slot.method_7677().method_7909() instanceof PhotographItem) continue;
                guiGraphics.method_25291(TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 350, 176.0f, 404.0f, 18, 18, 512, 512);
            }
            RenderSystem.disableBlend();
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 15.0f);
        super.method_2388(guiGraphics, mouseX, mouseY);
        guiGraphics.method_51448().method_22909();
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        if (this.isInAddingMode() && this.field_2787 != null && !this.field_2787.method_7677().method_7960() && !(this.field_2787.method_7677().method_7909() instanceof PhotographItem)) {
            return;
        }
        if (!this.isInAddingMode()) {
            for (Page page : this.pages) {
                boolean hasText;
                if (page.photographButton.method_25367()) {
                    page.photographButton.renderTooltip(guiGraphics, x, y);
                    return;
                }
                if (!((AlbumMenu)this.method_17577()).isAlbumEditable() || !page.isMouseOver(page.noteArea, x, y)) continue;
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                tooltip.add(class_2561.method_43471((String)"gui.exposure.album.note"));
                if (!page.getNoteWidget().method_25370()) {
                    tooltip.add(class_2561.method_43471((String)"gui.exposure.album.left_click_to_edit"));
                }
                if (hasText = page.noteWidget.left().map(box -> !box.getText().isEmpty()).orElse(false).booleanValue()) {
                    tooltip.add(class_2561.method_43471((String)"gui.exposure.album.right_click_to_clear"));
                }
                guiGraphics.method_51437(this.field_22793, tooltip, Optional.empty(), x, y);
                return;
            }
        }
        super.method_2380(guiGraphics, x, y);
    }

    @NotNull
    protected List<class_2561> method_51454(class_1799 stack) {
        List tooltipLines = super.method_51454(stack);
        if (this.isInAddingMode() && this.field_2787 != null && this.field_2787.method_7677() == stack && stack.method_7909() instanceof PhotographItem) {
            tooltipLines.add(class_2561.method_43473());
            tooltipLines.add(class_2561.method_43471((String)"gui.exposure.album.left_click_to_add"));
        }
        return tooltipLines;
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25291(TEXTURE, this.field_2776, this.field_2800, 0, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 512);
        if (this.enterSignModeButton != null && this.enterSignModeButton.field_22764) {
            guiGraphics.method_25290(TEXTURE, this.field_2776 - 27, this.field_2800 + 14, 447.0f, 0.0f, 27, 28, 512, 512);
        }
        int currentSpreadIndex = ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex();
        this.drawPageNumbers(guiGraphics, currentSpreadIndex);
        if (this.isInAddingMode()) {
            @Nullable Side pageBeingAddedTo = ((AlbumMenu)this.method_17577()).getSideBeingAddedTo();
            for (Page page : this.pages) {
                if (page.side != pageBeingAddedTo) continue;
                guiGraphics.method_25291(TEXTURE, page.photoArea.method_3321(), page.photoArea.method_3322(), 10, 0.0f, 296.0f, page.photoArea.method_3319(), page.photoArea.method_3320(), 512, 512);
                break;
            }
            AlbumPlayerInventorySlot firstSlot = ((AlbumMenu)this.method_17577()).getPlayerInventorySlots().get(0);
            int x = firstSlot.field_7873 - 8;
            int y = firstSlot.field_7872 - 18;
            guiGraphics.method_25291(TEXTURE, this.field_2776 + x, this.field_2800 + y, 10, 0.0f, 404.0f, 176, 100, 512, 512);
        }
    }

    protected void drawPageNumbers(class_332 guiGraphics, int currentSpreadIndex) {
        class_327 font = this.minecraft.field_1772;
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.method_51433(font, leftPageNumber, this.field_2776 + 71 + (8 - font.method_1727(leftPageNumber) / 2), this.field_2800 + 167, -1055542, false);
        guiGraphics.method_51433(font, rightPageNumber, this.field_2776 + 212 + (8 - font.method_1727(rightPageNumber) / 2), this.field_2800 + 167, -1055542, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isInAddingMode()) {
            if (!(this.isHoveringOverInventory(mouseX, mouseY) || this.method_2381(mouseX, mouseY, this.field_2776, this.field_2800, button) && !((AlbumMenu)this.method_17577()).method_34255().method_7960())) {
                this.sendButtonClick(-1);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
        for (Page page : this.pages) {
            if (!((AlbumMenu)this.method_17577()).isAlbumEditable() || button != 1 || !page.isMouseOver(page.noteArea, mouseX, mouseY)) continue;
            page.noteWidget.ifLeft(box -> box.setText(""));
            return true;
        }
        boolean handled = super.method_25402(mouseX, mouseY, button);
        for (Page page : this.pages) {
            TextBlock textBlock;
            class_339 noteWidget = page.getNoteWidget();
            if (!(noteWidget instanceof TextBlock) || !(textBlock = (TextBlock)noteWidget).method_25402(mouseX, mouseY, button)) continue;
            handled = true;
            break;
        }
        for (Page page : this.pages) {
            if (!page.getNoteWidget().method_25370() || page.isMouseOver(page.noteArea, mouseX, mouseY)) continue;
            this.method_25395(null);
            return true;
        }
        if (!(this.method_25399() instanceof TextBox)) {
            this.method_25395(null);
        }
        return handled;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.field_2794 && !((AlbumMenu)this.method_17577()).method_34255().method_7960() && ((AlbumMenu)this.method_17577()).method_34255().method_7947() == 1) {
            this.field_2794 = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25430(@Nullable class_2583 style) {
        if (style == null) {
            return false;
        }
        class_2558 clickEvent = style.method_10970();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
            String pageIndexStr = clickEvent.method_10844();
            int pageIndex = Integer.parseInt(pageIndexStr) - 1;
            this.forcePage(pageIndex);
            return true;
        }
        boolean handled = super.method_25430(style);
        if (handled && clickEvent.method_10845() == class_2558.class_2559.field_11750) {
            this.method_25419();
        }
        return handled;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isInAddingMode()) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return this.method_25399() != null && this.method_25397() && button == 0 && this.method_25399().method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    protected void sendButtonClick(int buttonId) {
        ((AlbumMenu)this.method_17577()).method_7604(this.player, buttonId);
        this.gameMode.method_2900(((AlbumMenu)this.method_17577()).field_7763, buttonId);
        if (buttonId == -1) {
            this.method_25395(null);
        }
        if (buttonId == 0 || buttonId == 1) {
            for (Page page : this.pages) {
                page.noteWidget.ifLeft(TextBox::setCursorToEnd).ifRight(textBlock -> textBlock.method_25355(this.getNoteComponent(page.side)));
            }
        }
    }

    protected boolean isHoveringOverInventory(double mouseX, double mouseY) {
        if (!this.isInAddingMode()) {
            return false;
        }
        AlbumPlayerInventorySlot firstSlot = ((AlbumMenu)this.method_17577()).getPlayerInventorySlots().get(0);
        int x = firstSlot.field_7873 - 8;
        int y = firstSlot.field_7872 - 18;
        return this.method_2378(x, y, 176, 100, mouseX, mouseY);
    }

    protected boolean isHoveringOverSignElement(double mouseX, double mouseY) {
        return this.enterSignModeButton == null || this.enterSignModeButton.field_22764 && this.method_2378(this.field_2776 - 27, this.field_2800 + 14, 27, 28, mouseX, mouseY);
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.isHoveringOverInventory(mouseX, mouseY) && !this.isHoveringOverSignElement(mouseX, mouseY);
    }

    protected boolean forcePage(int pageIndex) {
        try {
            int newSpreadIndex = pageIndex / 2;
            if (newSpreadIndex == ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex() || newSpreadIndex < 0 || newSpreadIndex > ((AlbumMenu)this.method_17577()).getPages().size() / 2) {
                return false;
            }
            PagingDirection pagingDirection = newSpreadIndex < ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex() ? PagingDirection.PREVIOUS : PagingDirection.NEXT;
            for (int pageChanges = 0; !(newSpreadIndex == ((AlbumMenu)this.method_17577()).getCurrentSpreadIndex() && this.pager.canChangePage(pagingDirection) || pageChanges > 16); ++pageChanges) {
                this.pager.changePage(pagingDirection);
            }
            return true;
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Cannot force page: " + e);
            return false;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        for (Page page : this.pages) {
            class_339 widget = (class_339)page.noteWidget.map(box -> box, block -> block);
            if (!widget.method_25370()) continue;
            if (keyCode == 256) {
                this.method_25395(null);
                return true;
            }
            return widget.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.isInAddingMode() && (this.minecraft.field_1690.field_1822.method_1417(keyCode, scanCode) || keyCode == 256)) {
            this.sendButtonClick(-1);
            return true;
        }
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        for (Page page : this.pages) {
            if (!((class_339)page.noteWidget.map(box -> box, block -> block)).method_25370()) continue;
            return super.method_16803(keyCode, scanCode, modifiers);
        }
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }

    protected void inspectPhotograph(class_1799 photograph) {
        if (!(photograph.method_7909() instanceof PhotographItem)) {
            return;
        }
        this.minecraft.method_1507((class_437)new AlbumPhotographScreen((class_437)this, List.of(new ItemAndStack(photograph))));
        this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), (float)(this.player.method_37908().method_8409().method_43057() * 0.2f + 1.3f), (float)0.75f));
    }

    @NotNull
    protected class_2561 getNoteComponent(Side page) {
        return ((AlbumMenu)this.method_17577()).getPage(page).map(AlbumPage::getNote).map(n -> (class_2561)n.map(class_2561::method_43470, comp -> comp)).orElse((class_2561)class_2561.method_43473());
    }

    protected void enterSignMode() {
        if (this.isInAddingMode()) {
            this.sendButtonClick(-1);
        }
        this.minecraft.method_1507((class_437)new AlbumSigningScreen((class_437)this, TEXTURE, 512, 512));
    }

    protected boolean isInAddingMode() {
        return ((AlbumMenu)this.method_17577()).isInAddingPhotographMode();
    }

    protected void forEachPage(Consumer<Page> pageAction) {
        for (Page page : this.pages) {
            pageAction.accept(page);
        }
    }

    protected class Page {
        public final Side side;
        public final class_768 pageArea;
        public final class_768 photoArea;
        public final class_768 exposureArea;
        public final class_768 noteArea;
        public final PhotographSlotButton photographButton;
        public final Either<TextBox, TextBlock> noteWidget;

        private Page(Side side, class_768 pageArea, class_768 photoArea, class_768 exposureArea, class_768 noteArea, PhotographSlotButton photographButton, Either<TextBox, TextBlock> noteWidget) {
            this.side = side;
            this.pageArea = pageArea;
            this.photoArea = photoArea;
            this.exposureArea = exposureArea;
            this.noteArea = noteArea;
            this.photographButton = photographButton;
            this.noteWidget = noteWidget;
        }

        public boolean isMouseOver(class_768 area, double mouseX, double mouseY) {
            return AlbumScreen.this.method_2378(area.method_3321() - AlbumScreen.this.field_2776, area.method_3322() - AlbumScreen.this.field_2800, area.method_3319(), area.method_3320(), mouseX, mouseY);
        }

        public class_339 getNoteWidget() {
            return (class_339)this.noteWidget.map(box -> box, block -> block);
        }
    }
}

