/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.storage.ExposureExporter;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.gui.screen.element.Pager;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.render.PhotographRenderProperties;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import io.github.mortuusars.exposure.util.ClientsideWorldNameGetter;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.PagingDirection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographScreen
extends ZoomableScreen {
    public static final class_2960 WIDGETS_TEXTURE = Exposure.resource("textures/gui/widgets.png");
    private final List<ItemAndStack<PhotographItem>> photographs;
    private final List<String> savedExposures = new ArrayList<String>();
    private final Pager pager = new Pager(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());

    public PhotographScreen(List<ItemAndStack<PhotographItem>> photographs) {
        super((class_2561)class_2561.method_43473());
        Preconditions.checkState((!photographs.isEmpty() ? 1 : 0) != 0, (Object)"No photographs to display.");
        this.photographs = photographs;
        for (ItemAndStack<PhotographItem> photograph : photographs) {
            @Nullable Either<String, class_2960> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
            if (idOrTexture == null) continue;
            idOrTexture.ifLeft(id -> ExposureClient.getExposureStorage().getOrQuery((String)id));
        }
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.zoomFactor = (float)this.field_22790 / (float)ExposureClient.getExposureRenderer().getSize();
        class_344 previousButton = new class_344(0, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, 0, 0, 16, WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.PREVIOUS), (class_2561)class_2561.method_43471((String)"gui.exposure.previous_page"));
        this.method_37063((class_364)previousButton);
        class_344 nextButton = new class_344(this.field_22789 - 16, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, 16, 0, 16, WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.NEXT), (class_2561)class_2561.method_43471((String)"gui.exposure.next_page"));
        this.method_37063((class_364)nextButton);
        this.pager.init(this.photographs.size(), true, (class_4264)previousButton, (class_4264)nextButton);
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.pager.update();
        this.method_25420(guiGraphics);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.x, this.y, 0.0f);
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22905(this.scale, this.scale, this.scale);
        guiGraphics.method_51448().method_46416((float)ExposureClient.getExposureRenderer().getSize() / -2.0f, (float)ExposureClient.getExposureRenderer().getSize() / -2.0f, 0.0f);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        ArrayList<ItemAndStack<PhotographItem>> photos = new ArrayList<ItemAndStack<PhotographItem>>(this.photographs);
        Collections.rotate(photos, -this.pager.getCurrentPage());
        PhotographRenderer.renderStackedPhotographs(photos, guiGraphics.method_51448(), (class_4597)bufferSource, 0xF000F0, 255, 255, 255, 255);
        bufferSource.method_22993();
        guiGraphics.method_51448().method_22909();
        ItemAndStack<PhotographItem> photograph = this.photographs.get(this.pager.getCurrentPage());
        Either<String, class_2960> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
        if (this.minecraft.field_1724 != null && this.minecraft.field_1724.method_7337() && idOrTexture != null) {
            guiGraphics.method_25303(this.field_22793, "?", this.field_22789 - this.field_22793.method_1727("?") - 10, 10, -1);
            if (mouseX > this.field_22789 - 20 && mouseX < this.field_22789 && mouseY < 20) {
                ArrayList<Object> lines = new ArrayList<Object>();
                String exposureName = (String)idOrTexture.map(id -> id, class_2960::toString);
                lines.add(class_2561.method_43470((String)exposureName));
                lines.add(class_2561.method_43469((String)"gui.exposure.photograph_screen.drop_as_item_tooltip", (Object[])new Object[]{class_2561.method_43470((String)"CTRL + I")}));
                lines.add((class_2561)idOrTexture.map(id -> class_2561.method_43469((String)"gui.exposure.photograph_screen.copy_id_tooltip", (Object[])new Object[]{"CTRL + C"}), texture -> class_2561.method_43469((String)"gui.exposure.photograph_screen.copy_texture_path_tooltip", (Object[])new Object[]{"CTRL + C"})));
                guiGraphics.method_51437(this.field_22793, lines, Optional.empty(), mouseX, mouseY + 20);
            }
        }
        if (((Boolean)Config.Client.SAVE_EXPOSURE_TO_FILE_WHEN_VIEWED.get()).booleanValue()) {
            this.trySaveToFile(photograph);
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_746 player = class_310.method_1551().field_1724;
        if (class_437.method_25441() && player != null && player.method_7337()) {
            ItemAndStack<PhotographItem> photograph = this.photographs.get(this.pager.getCurrentPage());
            if (keyCode == 67) {
                @Nullable Either<String, class_2960> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
                if (idOrTexture != null) {
                    String text = (String)idOrTexture.map(id -> id, class_2960::toString);
                    class_310.method_1551().field_1774.method_1455(text);
                    player.method_7353((class_2561)class_2561.method_43469((String)"gui.exposure.photograph_screen.copied_message", (Object[])new Object[]{text}), false);
                }
                return true;
            }
            if (keyCode == 73) {
                if (class_310.method_1551().field_1761 != null) {
                    class_310.method_1551().field_1761.method_2915(photograph.getStack().method_7972());
                    player.method_7353((class_2561)class_2561.method_43469((String)"gui.exposure.photograph_screen.item_dropped_message", (Object[])new Object[]{photograph.getStack().toString()}), false);
                }
                return true;
            }
        }
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }

    private void trySaveToFile(ItemAndStack<PhotographItem> photograph) {
        if (class_310.method_1551().field_1724 == null || photograph.getStack().method_7969() == null) {
            return;
        }
        class_2487 tag = photograph.getStack().method_7969();
        if (tag == null || class_310.method_1551().field_1724 == null || !tag.method_10573("PhotographerId", 11) || !tag.method_25926("PhotographerId").equals(class_310.method_1551().field_1724.method_5667())) {
            return;
        }
        @Nullable Either<String, class_2960> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
        if (idOrTexture == null) {
            return;
        }
        idOrTexture.ifLeft(id -> {
            String filename;
            PhotographRenderProperties properties = PhotographRenderProperties.get(photograph.getStack());
            String string = filename = properties != PhotographRenderProperties.DEFAULT ? id + "_" + properties.getId() : id;
            if (this.savedExposures.contains(filename)) {
                return;
            }
            ExposureClient.getExposureStorage().getOrQuery((String)id).ifPresent(exposure -> {
                this.savedExposures.add(filename);
                new Thread(() -> new ExposureExporter(filename).withDefaultFolder().organizeByWorld((Boolean)Config.Client.EXPOSURE_SAVING_LEVEL_SUBFOLDER.get(), ClientsideWorldNameGetter::getWorldName).withModifier(properties.getModifier()).withSize((ExposureSize)((Object)((Object)((Object)((Object)Config.Client.EXPOSURE_SAVING_SIZE.get()))))).save((ExposureSavedData)((Object)((Object)exposure))), "ExposureSaving").start();
            });
        });
    }
}

