/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.camera.infrastructure.FrameData;
import io.github.mortuusars.exposure.gui.screen.FilmFrameInspectScreen;
import io.github.mortuusars.exposure.gui.screen.element.ChromaticProcessToggleButton;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.util.ColorChannel;
import io.github.mortuusars.exposure.util.PagingDirection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomScreen
extends class_465<LightroomMenu> {
    public static final class_2960 MAIN_TEXTURE = Exposure.resource("textures/gui/lightroom.png");
    public static final class_2960 FILM_OVERLAYS_TEXTURE = Exposure.resource("textures/gui/lightroom_film_overlays.png");
    public static final int FRAME_SIZE = 54;
    protected class_1657 player;
    protected class_4185 printButton;
    protected ChromaticProcessToggleButton processToggleButton;

    public LightroomScreen(LightroomMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.player = playerInventory.field_7546;
    }

    protected void method_25426() {
        this.field_2792 = 176;
        this.field_2779 = 210;
        super.method_25426();
        this.field_25270 = 116;
        this.printButton = new class_344(this.field_2776 + 117, this.field_2800 + 89, 22, 22, 176, 17, 22, MAIN_TEXTURE, 256, 256, this::onPrintButtonPressed, (class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.print"));
        class_5250 tooltip = class_2561.method_43471((String)"gui.exposure.lightroom.print");
        if (this.player.method_7337()) {
            tooltip.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.print.creative_tooltip"));
        }
        this.printButton.method_47400(class_7919.method_47407((class_2561)tooltip));
        this.method_37063((class_364)this.printButton);
        this.processToggleButton = new ChromaticProcessToggleButton(this.field_2776 - 19, this.field_2800 + 91, this::onProcessToggleButtonPressed, () -> ((LightroomMenu)this.method_17577()).getBlockEntity().getProcess());
        this.processToggleButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.current_frame")));
        this.method_37063((class_364)this.processToggleButton);
        this.updateButtons();
    }

    protected void onPrintButtonPressed(class_4185 button) {
        if (class_310.method_1551().field_1761 != null) {
            if (class_437.method_25442() && this.player.method_7337()) {
                class_310.method_1551().field_1761.method_2900(((LightroomMenu)this.method_17577()).field_7763, 1);
            } else {
                class_310.method_1551().field_1761.method_2900(((LightroomMenu)this.method_17577()).field_7763, 0);
            }
        }
    }

    protected void onProcessToggleButtonPressed(class_4185 button) {
        if (class_310.method_1551().field_1761 != null) {
            class_310.method_1551().field_1761.method_2900(((LightroomMenu)this.method_17577()).field_7763, 4);
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void updateButtons() {
        this.printButton.field_22763 = ((LightroomMenu)this.method_17577()).getBlockEntity().canPrint() || this.player.method_7337() && class_437.method_25442() && ((LightroomMenu)this.method_17577()).getBlockEntity().canPrintInCreativeMode();
        this.printButton.field_22764 = !((LightroomMenu)this.method_17577()).isPrinting();
        this.processToggleButton.field_22763 = true;
        this.processToggleButton.field_22764 = ((LightroomMenu)this.method_17577()).getExposedFrames().method_10602(((LightroomMenu)this.method_17577()).getSelectedFrame()).method_10577("Chromatic");
    }

    protected void method_2389(@NotNull class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        class_2499 frames;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 - 27, this.field_2800 + 34, 0, 208, 28, 31);
        if (!((class_1735)((LightroomMenu)this.method_17577()).field_7761.get(0)).method_7681()) {
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 - 21, this.field_2800 + 41, 238, 0, 18, 18);
        }
        if (!((class_1735)((LightroomMenu)this.method_17577()).field_7761.get(1)).method_7681()) {
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 7, this.field_2800 + 91, 238, 18, 18, 18);
        }
        if (!((class_1735)((LightroomMenu)this.method_17577()).field_7761.get(2)).method_7681()) {
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 41, this.field_2800 + 91, 238, 36, 18, 18);
        }
        if (!((class_1735)((LightroomMenu)this.method_17577()).field_7761.get(3)).method_7681()) {
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 59, this.field_2800 + 91, 238, 54, 18, 18);
        }
        if (!((class_1735)((LightroomMenu)this.method_17577()).field_7761.get(4)).method_7681()) {
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 77, this.field_2800 + 91, 238, 72, 18, 18);
        }
        if (!((class_1735)((LightroomMenu)this.method_17577()).field_7761.get(5)).method_7681()) {
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 95, this.field_2800 + 91, 238, 90, 18, 18);
        }
        if (((LightroomMenu)this.method_17577()).isPrinting()) {
            int progress = ((LightroomMenu)this.method_17577()).getData().method_17390(0);
            int time = ((LightroomMenu)this.method_17577()).getData().method_17390(1);
            int width = progress != 0 && time != 0 ? progress * 24 / time : 0;
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 116, this.field_2800 + 91, 176, 0, width, 17);
        }
        if ((frames = ((LightroomMenu)this.method_17577()).getExposedFrames()).isEmpty()) {
            guiGraphics.method_25302(FILM_OVERLAYS_TEXTURE, this.field_2776 + 4, this.field_2800 + 15, 0, 136, 168, 68);
            return;
        }
        class_1799 filmStack = ((LightroomMenu)this.method_17577()).method_7611(0).method_7677();
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem film = (DevelopedFilmItem)class_17922;
        FilmType negative = film.getType();
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        @Nullable class_2487 leftFrame = ((LightroomMenu)this.method_17577()).getFrameIdByIndex(selectedFrame - 1);
        @Nullable class_2487 centerFrame = ((LightroomMenu)this.method_17577()).getFrameIdByIndex(selectedFrame);
        @Nullable class_2487 rightFrame = ((LightroomMenu)this.method_17577()).getFrameIdByIndex(selectedFrame + 1);
        RenderSystem.setShaderColor((float)negative.filmR, (float)negative.filmG, (float)negative.filmB, (float)negative.filmA);
        guiGraphics.method_25302(FILM_OVERLAYS_TEXTURE, this.field_2776 + 1, this.field_2800 + 15, 0, leftFrame != null ? 68 : 0, 54, 68);
        guiGraphics.method_25302(FILM_OVERLAYS_TEXTURE, this.field_2776 + 55, this.field_2800 + 15, 55, rightFrame != null ? 0 : 68, 64, 68);
        if (rightFrame != null) {
            boolean hasMoreFrames = selectedFrame + 2 < frames.size();
            guiGraphics.method_25302(FILM_OVERLAYS_TEXTURE, this.field_2776 + 119, this.field_2800 + 15, 120, hasMoreFrames ? 68 : 0, 56, 68);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 poseStack = guiGraphics.method_51448();
        if (leftFrame != null) {
            this.renderFrame(leftFrame, poseStack, this.field_2776 + 6, this.field_2800 + 22, 54.0f, this.isOverLeftFrame(mouseX, mouseY) ? 0.8f : 0.25f, negative);
        }
        if (centerFrame != null) {
            this.renderFrame(centerFrame, poseStack, this.field_2776 + 61, this.field_2800 + 22, 54.0f, 0.9f, negative);
        }
        if (rightFrame != null) {
            this.renderFrame(rightFrame, poseStack, this.field_2776 + 116, this.field_2800 + 22, 54.0f, this.isOverRightFrame(mouseX, mouseY) ? 0.8f : 0.25f, negative);
        }
        RenderSystem.setShaderColor((float)negative.filmR, (float)negative.filmG, (float)negative.filmB, (float)negative.filmA);
        if (((LightroomMenu)this.method_17577()).getBlockEntity().isAdvancingFrameOnPrint()) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 800.0f);
            if (selectedFrame < ((LightroomMenu)this.method_17577()).getTotalFrames() - 1) {
                guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 111, this.field_2800 + 44, 200, 0, 10, 10);
            } else {
                guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 111, this.field_2800 + 44, 210, 0, 10, 10);
            }
            poseStack.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void method_2380(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        boolean advancedTooltips = class_310.method_1551().field_1690.field_1827;
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
        int hoveredFrameIndex = -1;
        if (this.isOverLeftFrame(mouseX, mouseY)) {
            hoveredFrameIndex = selectedFrame - 1;
            tooltipLines.add((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.previous_frame"));
        } else if (this.isOverCenterFrame(mouseX, mouseY)) {
            hoveredFrameIndex = selectedFrame;
            tooltipLines.add((class_2561)class_2561.method_43469((String)"gui.exposure.lightroom.current_frame", (Object[])new Object[]{Integer.toString(((LightroomMenu)this.method_17577()).getSelectedFrame() + 1)}));
        } else if (this.isOverRightFrame(mouseX, mouseY)) {
            hoveredFrameIndex = selectedFrame + 1;
            tooltipLines.add((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.next_frame"));
        }
        if (hoveredFrameIndex != -1) {
            this.addFrameInfoTooltipLines(tooltipLines, hoveredFrameIndex, advancedTooltips);
        }
        guiGraphics.method_51437(class_310.method_1551().field_1772, tooltipLines, Optional.empty(), mouseX, mouseY);
    }

    private void addFrameInfoTooltipLines(List<class_2561> tooltipLines, int frameIndex, boolean isAdvancedTooltips) {
        @Nullable class_2487 frame = ((LightroomMenu)this.method_17577()).getFrameIdByIndex(frameIndex);
        if (frame != null) {
            ColorChannel.fromString(frame.method_10558("ChromaticChannel")).ifPresent(c -> tooltipLines.add((class_2561)class_2561.method_43471((String)("gui.exposure.channel." + c.method_15434())).method_27696(class_2583.field_24360.method_36139(c.getRepresentationColor()))));
            if (isAdvancedTooltips) {
                Either<String, class_2960> idOrTexture = FrameData.getIdOrTexture(frame);
                class_5250 component = ((class_5250)idOrTexture.map(id -> !id.isEmpty() ? class_2561.method_43469((String)"gui.exposure.frame.id", (Object[])new Object[]{class_2561.method_43470((String)id).method_27692(class_124.field_1080)}) : class_2561.method_43473(), texture -> class_2561.method_43469((String)"gui.exposure.frame.texture", (Object[])new Object[]{class_2561.method_43470((String)texture.toString()).method_27692(class_124.field_1080)}))).method_27692(class_124.field_1063);
                tooltipLines.add((class_2561)component);
            }
        }
    }

    private boolean isOverLeftFrame(int mouseX, int mouseY) {
        class_2499 frames = ((LightroomMenu)this.method_17577()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        return selectedFrame - 1 >= 0 && selectedFrame - 1 < frames.size() && this.method_2378(6, 22, 54, 54, mouseX, mouseY);
    }

    private boolean isOverCenterFrame(int mouseX, int mouseY) {
        class_2499 frames = ((LightroomMenu)this.method_17577()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        return selectedFrame >= 0 && selectedFrame < frames.size() && this.method_2378(61, 22, 54, 54, mouseX, mouseY);
    }

    private boolean isOverRightFrame(int mouseX, int mouseY) {
        class_2499 frames = ((LightroomMenu)this.method_17577()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        return selectedFrame + 1 >= 0 && selectedFrame + 1 < frames.size() && this.method_2378(116, 22, 54, 54, mouseX, mouseY);
    }

    public void renderFrame(@Nullable class_2487 frame, class_4587 poseStack, float x, float y, float size, float alpha, FilmType negative) {
        if (frame == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416(x, y, 0.0f);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        Either<String, class_2960> idOrTexture = FrameData.getIdOrTexture(frame);
        ExposureClient.getExposureRenderer().render(idOrTexture, ExposurePixelModifiers.NEGATIVE_FILM, poseStack, (class_4597)bufferSource, 0.0f, 0.0f, size, size, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, negative.frameR, negative.frameG, negative.frameB, class_3532.method_15340((int)((int)Math.ceil(alpha * 255.0f)), (int)0, (int)255));
        bufferSource.method_22993();
        poseStack.method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Preconditions.checkState((this.field_22787 != null ? 1 : 0) != 0);
        Preconditions.checkState((this.field_22787.field_1761 != null ? 1 : 0) != 0);
        if (this.field_22787.field_1690.field_1913.method_1417(keyCode, scanCode) || keyCode == 263) {
            this.changeFrame(PagingDirection.PREVIOUS);
            return true;
        }
        if (this.field_22787.field_1690.field_1849.method_1417(keyCode, scanCode) || keyCode == 262) {
            this.changeFrame(PagingDirection.NEXT);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        boolean handled = super.method_25401(mouseX, mouseY, delta);
        if (!handled && delta >= 0.0 && this.isOverCenterFrame((int)mouseX, (int)mouseY)) {
            this.enterFrameInspectMode();
        }
        return handled;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            Preconditions.checkState((this.field_22787 != null ? 1 : 0) != 0);
            Preconditions.checkState((this.field_22787.field_1761 != null ? 1 : 0) != 0);
            if (this.isOverCenterFrame((int)mouseX, (int)mouseY)) {
                this.enterFrameInspectMode();
                return true;
            }
            if (this.isOverLeftFrame((int)mouseX, (int)mouseY)) {
                this.changeFrame(PagingDirection.PREVIOUS);
                return true;
            }
            if (this.isOverRightFrame((int)mouseX, (int)mouseY)) {
                this.changeFrame(PagingDirection.NEXT);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void changeFrame(PagingDirection navigation) {
        if (navigation == PagingDirection.PREVIOUS && ((LightroomMenu)this.method_17577()).getSelectedFrame() == 0 || navigation == PagingDirection.NEXT && ((LightroomMenu)this.method_17577()).getSelectedFrame() == ((LightroomMenu)this.method_17577()).getTotalFrames() - 1) {
            return;
        }
        Preconditions.checkState((this.field_22787 != null ? 1 : 0) != 0);
        Preconditions.checkState((this.field_22787.field_1724 != null ? 1 : 0) != 0);
        Preconditions.checkState((this.field_22787.field_1761 != null ? 1 : 0) != 0);
        int buttonId = navigation == PagingDirection.NEXT ? 3 : 2;
        this.field_22787.field_1761.method_2900(((LightroomMenu)this.method_17577()).field_7763, buttonId);
        this.player.method_5783(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 1.0f, this.field_22787.field_1724.method_37908().method_8409().method_43057() * 0.4f + 0.8f);
        ((LightroomMenu)this.method_17577()).getBlockEntity().setSelectedFrame(((LightroomMenu)this.method_17577()).getBlockEntity().getSelectedFrameIndex() + (navigation == PagingDirection.NEXT ? 1 : -1));
    }

    private void enterFrameInspectMode() {
        class_310.method_1551().method_1507((class_437)new FilmFrameInspectScreen(this, (LightroomMenu)this.method_17577()));
        this.player.method_5783(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 1.0f, 1.3f);
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeft, guiTop, mouseButton) && this.field_2787 == null;
    }
}

