/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.fabric;

import com.mojang.brigadier.CommandDispatcher;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.command.ExposureCommand;
import io.github.mortuusars.exposure.command.ShaderCommand;
import io.github.mortuusars.exposure.command.TestCommand;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.fabric.integration.create.CreateFilmDeveloping;
import io.github.mortuusars.exposure.fabric.resources.FabricLensesDataLoader;
import io.github.mortuusars.exposure.network.fabric.PacketsImpl;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_3264;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ExposureFabric
implements ModInitializer {
    public void onInitialize() {
        Exposure.init();
        ModConfigEvents.reloading((String)"exposure").register(config -> {
            if (config.getType() == ModConfig.Type.COMMON && FabricLoader.getInstance().isModLoaded("create")) {
                CreateFilmDeveloping.clearCachedData();
            }
        });
        ForgeConfigRegistry.INSTANCE.register("exposure", ModConfig.Type.COMMON, (IConfigSpec)Config.Common.SPEC);
        ForgeConfigRegistry.INSTANCE.register("exposure", ModConfig.Type.CLIENT, (IConfigSpec)Config.Client.SPEC);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            ExposureCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ShaderCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TestCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> {
            content.prepend((class_1935)Exposure.Items.CAMERA.get());
            content.prepend((class_1935)Exposure.Items.BLACK_AND_WHITE_FILM.get());
            content.prepend((class_1935)Exposure.Items.COLOR_FILM.get());
            content.prepend((class_1935)Exposure.Items.DEVELOPED_BLACK_AND_WHITE_FILM.get());
            content.prepend((class_1935)Exposure.Items.DEVELOPED_COLOR_FILM.get());
            content.prepend((class_1935)Exposure.Items.PHOTOGRAPH.get());
            content.prepend((class_1935)Exposure.Items.AGED_PHOTOGRAPH.get());
            content.prepend((class_1935)Exposure.Items.STACKED_PHOTOGRAPHS.get());
            content.prepend((class_1935)Exposure.Items.ALBUM.get());
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(content -> content.prepend((class_1935)Exposure.Items.LIGHTROOM.get()));
        Exposure.Advancements.register();
        Exposure.Stats.register();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricLensesDataLoader());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Exposure.initServer(server);
            PacketsImpl.onServerStarting(server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(PacketsImpl::onServerStopped);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> Lenses.onDatapackSync(player));
        PacketsImpl.registerC2SPackets();
    }
}

