/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.storage.IServersideExposureStorage;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.ExposureChangedS2CP;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_18;
import net.minecraft.class_26;
import org.jetbrains.annotations.Nullable;

public class ServersideExposureStorage
implements IServersideExposureStorage {
    private static final String EXPOSURE_DIR = "exposures";
    private final Supplier<class_26> levelStorageSupplier;
    private final Supplier<Path> worldPathSupplier;

    public ServersideExposureStorage(Supplier<class_26> levelStorageSupplier, Supplier<Path> worldPathSupplier) {
        this.levelStorageSupplier = levelStorageSupplier;
        this.worldPathSupplier = worldPathSupplier;
    }

    @Override
    public Optional<ExposureSavedData> getOrQuery(String id) {
        class_26 dataStorage = this.levelStorageSupplier.get();
        @Nullable ExposureSavedData loadedExposureData = (ExposureSavedData)dataStorage.method_20786(ExposureSavedData::load, this.getSaveId(id));
        if (loadedExposureData == null) {
            LogUtils.getLogger().error("Exposure '" + id + "' was not loaded. File does not exist or some error occurred.");
        }
        return Optional.ofNullable(loadedExposureData);
    }

    @Override
    public void put(String id, ExposureSavedData data) {
        if (this.createStorageDirectory()) {
            class_26 dataStorage = this.levelStorageSupplier.get();
            dataStorage.method_123(this.getSaveId(id), (class_18)data);
            data.method_80();
        }
    }

    @Override
    public List<String> getAllIds() {
        this.levelStorageSupplier.get().method_125();
        Path path = this.worldPathSupplier.get().resolve("data/exposures");
        File folder = path.toFile();
        @Nullable File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (File file : listOfFiles) {
            if (file == null || !file.isFile()) continue;
            ids.add(com.google.common.io.Files.getNameWithoutExtension((String)file.getName()));
        }
        return ids;
    }

    @Override
    public void clear() {
        LogUtils.getLogger().warn("Clearing Server Exposure Storage is not implemented.");
    }

    @Override
    public void sendExposureChanged(String exposureId) {
        Packets.sendToAllClients(new ExposureChangedS2CP(exposureId));
    }

    private String getSaveId(String id) {
        return "exposures/" + id;
    }

    private boolean createStorageDirectory() {
        try {
            Path path = this.worldPathSupplier.get().resolve("data/exposures");
            return Files.exists(path, new LinkOption[0]) || path.toFile().mkdirs();
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Failed to create exposure storage directory: " + e);
            return false;
        }
    }
}

