/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.data.Filters;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class FiltersResourceLoader
extends class_4309 {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String DIRECTORY = "filters";

    public FiltersResourceLoader() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<class_2960, JsonElement> content, class_3300 resourceManager, class_3695 profiler) {
        ConcurrentHashMap<class_1856, class_2960> filters = new ConcurrentHashMap<class_1856, class_2960>();
        LogUtils.getLogger().info("Loading exposure filters:");
        for (Map.Entry<class_2960, JsonElement> entry : content.entrySet()) {
            if (!entry.getKey().method_12836().equals("exposure")) continue;
            try {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                JsonElement item = jsonObject.get("item");
                class_1856 ingredient = class_1856.method_52177((JsonElement)item);
                if (ingredient.method_8103()) {
                    throw new IllegalArgumentException("'item' cannot be empty.");
                }
                String shader = jsonObject.get("shader").getAsString();
                filters.put(ingredient, new class_2960(shader));
                LogUtils.getLogger().info("Filter [" + entry.getKey() + ", " + shader + "] added.");
            }
            catch (Exception e) {
                LogUtils.getLogger().error(e.toString());
            }
        }
        if (filters.isEmpty()) {
            LogUtils.getLogger().info("No filters have been loaded.");
        }
        Filters.reload(filters);
    }
}

