/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.viewfinder;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.camera.infrastructure.SynchronizedCameraInHandActions;
import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.camera.viewfinder.SelfieClient;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderOverlay;
import io.github.mortuusars.exposure.data.Filters;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.CameraInHand;
import io.github.mortuusars.exposure.util.Fov;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ViewfinderClient {
    public static final float ZOOM_STEP = 8.0f;
    public static final float ZOOM_PRECISE_MODIFIER = 0.25f;
    private static boolean isOpen;
    private static FocalRange focalRange;
    private static double targetFov;
    private static double currentFov;
    private static boolean shouldRestoreFov;
    @Nullable
    private static String previousShaderEffect;

    public static boolean isOpen() {
        return isOpen;
    }

    public static boolean isLookingThrough() {
        return ViewfinderClient.isOpen() && (class_310.method_1551().field_1690.method_31044() == class_5498.field_26664 || class_310.method_1551().field_1690.method_31044() == class_5498.field_26666);
    }

    public static void open() {
        class_746 player = class_310.method_1551().field_1724;
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Player should not be null");
        Preconditions.checkState((boolean)player.method_37908().method_8608(), (Object)"This should be called only client-side.");
        if (ViewfinderClient.isOpen()) {
            return;
        }
        @Nullable class_1268 activeHand = CameraInHand.getActiveHand((class_1657)player);
        Preconditions.checkState((activeHand != null ? 1 : 0) != 0, (Object)"Player should have active camera in hand.");
        ItemAndStack<CameraItem> camera = new ItemAndStack<CameraItem>(player.method_5998(activeHand));
        focalRange = ((CameraItem)((Object)camera.getItem())).getFocalRange(camera.getStack());
        targetFov = Fov.focalLengthToFov(class_3532.method_15363((float)((CameraItem)((Object)camera.getItem())).getFocalLength(camera.getStack()), (float)focalRange.min(), (float)focalRange.max()));
        isOpen = true;
        ((CameraItem)((Object)camera.getItem())).getAttachment(camera.getStack(), CameraItem.FILTER_ATTACHMENT).flatMap(Filters::getShaderOf).ifPresent(shaderLocation -> {
            class_279 effect = class_310.method_1551().field_1773.method_3183();
            if (effect != null) {
                previousShaderEffect = effect.method_1260();
            }
            class_310.method_1551().field_1773.method_3168(shaderLocation);
        });
        SelfieClient.update(camera, activeHand, false);
        ViewfinderOverlay.setup();
    }

    public static void close() {
        isOpen = false;
        targetFov = ((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue();
        class_310.method_1551().field_1773.method_3207();
        if (ViewfinderClient.shouldRestorePreviousShaderEffect() && previousShaderEffect != null) {
            class_310.method_1551().field_1773.method_3168(new class_2960(previousShaderEffect));
        }
        previousShaderEffect = null;
    }

    private static boolean shouldRestorePreviousShaderEffect() {
        if (PlatformHelper.isModLoaded("cold_sweat") && previousShaderEffect != null && previousShaderEffect.equals("minecraft:shaders/post/blobs2.json")) {
            return false;
        }
        return previousShaderEffect != null;
    }

    public static FocalRange getFocalRange() {
        return focalRange;
    }

    public static double getCurrentFov() {
        return currentFov;
    }

    public static float getSelfieCameraDistance() {
        return 1.75f;
    }

    public static void zoom(ZoomDirection direction, boolean precise) {
        double fov;
        double prevFov;
        double step = 8.0 * (1.0 - class_3532.method_15350((double)(((double)focalRange.min() - currentFov) / (double)focalRange.min()), (double)0.3f, (double)1.0));
        double inertia = Math.abs(targetFov - currentFov) * (double)0.8f;
        double change = step + inertia;
        if (precise) {
            change *= 0.25;
        }
        if (Math.abs((prevFov = targetFov) - (fov = class_3532.method_15350((double)(targetFov + (direction == ZoomDirection.IN ? -change : change)), (double)Fov.focalLengthToFov(focalRange.max()), (double)Fov.focalLengthToFov(focalRange.min())))) > (double)0.01f) {
            Objects.requireNonNull(class_310.method_1551().field_1724).method_43077(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());
        }
        targetFov = fov;
        SynchronizedCameraInHandActions.setZoom(Fov.fovToFocalLength(fov));
    }

    public static double modifyMouseSensitivity(double sensitivity) {
        if (!ViewfinderClient.isLookingThrough()) {
            return sensitivity;
        }
        double modifier = class_3532.method_15350((double)(1.0 - (Double)Config.Client.VIEWFINDER_ZOOM_SENSITIVITY_MODIFIER.get() * (((double)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue() - currentFov) / 5.0)), (double)0.01, (double)2.0);
        return sensitivity * modifier;
    }

    public static void onPlayerTick(class_1657 player) {
        if (!player.equals((Object)class_310.method_1551().field_1724)) {
            return;
        }
        boolean cameraActive = CameraInHand.isActive(player);
        if (cameraActive && !ViewfinderClient.isOpen()) {
            ViewfinderClient.open();
        } else if (!cameraActive && ViewfinderClient.isOpen()) {
            ViewfinderClient.close();
        }
    }

    public static boolean handleMouseScroll(ZoomDirection direction) {
        if (ViewfinderClient.isLookingThrough()) {
            ViewfinderClient.zoom(direction, false);
            return true;
        }
        return false;
    }

    public static double modifyFov(double fov) {
        if (ViewfinderClient.isLookingThrough()) {
            currentFov = class_3532.method_16436((double)Math.min(0.6f * class_310.method_1551().method_1534(), 0.6f), (double)currentFov, (double)targetFov);
            shouldRestoreFov = true;
            return currentFov;
        }
        if (shouldRestoreFov && Math.abs(currentFov - fov) > 1.0E-5) {
            currentFov = class_3532.method_16436((double)Math.min(0.8f * class_310.method_1551().method_1534(), 0.8f), (double)currentFov, (double)fov);
            return currentFov;
        }
        currentFov = fov;
        shouldRestoreFov = false;
        return fov;
    }

    static {
        focalRange = new FocalRange(18, 55);
        currentFov = targetFov = 90.0;
    }
}

