/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.processing;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_3620;

public class RGBToMapColorConverter {
    private static final double[] shadeCoeffs = new double[]{0.71, 0.86, 1.0, 0.53};

    public static byte[] convert(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        class_3620[] mapColors = (class_3620[])Arrays.stream(RGBToMapColorConverter.getMapColors()).filter(Objects::nonNull).toArray(class_3620[]::new);
        byte[] bytes = new byte[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                byte mapColorIndex;
                Color imageColor = new Color(image.getRGB(x, y), false);
                bytes[x + y * width] = mapColorIndex = (byte)RGBToMapColorConverter.nearestColor(mapColors, imageColor);
            }
        }
        return bytes;
    }

    public static class_3620[] getMapColors() {
        class_3620[] colors = new class_3620[64];
        for (int i = 0; i <= 63; ++i) {
            colors[i] = class_3620.method_38479((int)i);
        }
        return colors;
    }

    private static double[] applyShade(double[] color, int ind) {
        double coeff = shadeCoeffs[ind];
        return new double[]{color[0] * coeff, color[1] * coeff, color[2] * coeff};
    }

    private static int nearestColor(class_3620[] colors, Color imageColor) {
        double[] imageVec = new double[]{(double)imageColor.getRed() / 255.0, (double)imageColor.getGreen() / 255.0, (double)imageColor.getBlue() / 255.0};
        int best_color = 0;
        double lowest_distance = 10000.0;
        for (int k = 0; k < colors.length; ++k) {
            Color mcColor = new Color(colors[k].field_16011);
            double[] mcColorVec = new double[]{(double)mcColor.getRed() / 255.0, (double)mcColor.getGreen() / 255.0, (double)mcColor.getBlue() / 255.0};
            for (int shadeInd = 0; shadeInd < shadeCoeffs.length; ++shadeInd) {
                double distance = RGBToMapColorConverter.distance(imageVec, RGBToMapColorConverter.applyShade(mcColorVec, shadeInd));
                if (!(distance < lowest_distance)) continue;
                lowest_distance = distance;
                best_color = k == 0 && imageColor.getAlpha() == 255 ? 119 : k * shadeCoeffs.length + shadeInd;
            }
        }
        return best_color;
    }

    private static double distance(double[] vectorA, double[] vectorB) {
        return Math.sqrt(Math.pow(vectorA[0] - vectorB[0], 2.0) + Math.pow(vectorA[1] - vectorB[1], 2.0) + Math.pow(vectorA[2] - vectorB[2], 2.0));
    }
}

