/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.block.entity;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.block.LightroomBlock;
import io.github.mortuusars.exposure.block.entity.Lightroom;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.item.IFilmItem;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomBlockEntity
extends class_2624
implements class_1278 {
    public static final int CONTAINER_DATA_SIZE = 3;
    public static final int CONTAINER_DATA_PROGRESS_ID = 0;
    public static final int CONTAINER_DATA_PRINT_TIME_ID = 1;
    public static final int CONTAINER_DATA_SELECTED_FRAME_ID = 2;
    protected final class_3913 containerData = new class_3913(){

        public int method_17390(int id) {
            return switch (id) {
                case 0 -> LightroomBlockEntity.this.progress;
                case 1 -> LightroomBlockEntity.this.printTime;
                case 2 -> LightroomBlockEntity.this.getSelectedFrameIndex();
                default -> 0;
            };
        }

        public void method_17391(int id, int value) {
            if (id == 0) {
                LightroomBlockEntity.this.progress = value;
            } else if (id == 1) {
                LightroomBlockEntity.this.printTime = value;
            } else if (id == 2) {
                LightroomBlockEntity.this.setSelectedFrame(value);
            }
            LightroomBlockEntity.this.method_5431();
        }

        public int method_17389() {
            return 3;
        }
    };
    protected class_2371<class_1799> items = class_2371.method_10213((int)7, (Object)class_1799.field_8037);
    protected int selectedFrame;
    protected int progress;
    protected int printTime;
    protected int storedExperience;
    protected boolean advanceFrame;
    protected Lightroom.Process process = Lightroom.Process.REGULAR;

    public LightroomBlockEntity(class_2338 pos, class_2680 blockState) {
        super(Exposure.BlockEntityTypes.LIGHTROOM.get(), pos, blockState);
    }

    public static <T extends class_2586> void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, T blockEntity) {
        if (blockEntity instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
            lightroomBlockEntity.tick();
        }
    }

    protected void tick() {
        if (this.printTime <= 0 || !this.canPrint()) {
            this.stopPrintingProcess();
            return;
        }
        if (this.progress < this.printTime) {
            ++this.progress;
            if (this.progress % 55 == 0 && this.printTime - this.progress > 12 && this.field_11863 != null) {
                this.field_11863.method_8396(null, this.method_11016(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), class_3419.field_15245, 1.0f, this.field_11863.method_8409().method_43057() * 0.3f + 1.0f);
            }
            return;
        }
        if (this.tryPrint()) {
            this.onFramePrinted();
        }
        this.stopPrintingProcess();
    }

    public float getProgressPercentage() {
        if (this.progress < 1 || this.printTime < 1) {
            return 0.0f;
        }
        return (float)this.progress / (float)this.printTime;
    }

    protected void onFramePrinted() {
        if (this.advanceFrame) {
            this.advanceFrame();
        }
    }

    protected void advanceFrame() {
        ItemAndStack film = new ItemAndStack(this.method_5438(0));
        int frames = ((DevelopedFilmItem)film.getItem()).getExposedFramesCount(film.getStack());
        if (this.getSelectedFrameIndex() >= frames - 1) {
            if (this.canEjectFilm()) {
                this.ejectFilm();
            }
        } else {
            this.setSelectedFrame(this.getSelectedFrameIndex() + 1);
            this.method_5431();
        }
    }

    public boolean isAdvancingFrameOnPrint() {
        return this.advanceFrame;
    }

    protected boolean canEjectFilm() {
        class_2350 facing;
        if (this.field_11863 == null || this.field_11863.field_9236 || this.method_5438(0).method_7960()) {
            return false;
        }
        class_2338 pos = this.method_11016();
        return !this.field_11863.method_8320(pos.method_10093(facing = (class_2350)this.field_11863.method_8320(pos).method_11654((class_2769)LightroomBlock.FACING))).method_26225();
    }

    protected void ejectFilm() {
        if (this.field_11863 == null || this.field_11863.field_9236 || this.method_5438(0).method_7960()) {
            return;
        }
        class_2338 pos = this.method_11016();
        class_2350 facing = (class_2350)this.field_11863.method_8320(pos).method_11654((class_2769)LightroomBlock.FACING);
        class_1799 filmStack = this.method_5434(0, 1);
        class_2382 normal = facing.method_10163();
        class_243 point = class_243.method_24953((class_2382)pos).method_1031((double)((float)normal.method_10263() * 0.75f), (double)((float)normal.method_10264() * 0.75f), (double)((float)normal.method_10260() * 0.75f));
        class_1542 itemEntity = new class_1542(this.field_11863, point.field_1352, point.field_1351, point.field_1350, filmStack);
        itemEntity.method_18800((double)((float)normal.method_10263() * 0.05f), (double)((float)normal.method_10264() * 0.05f + 0.15f), (double)((float)normal.method_10260() * 0.05f));
        itemEntity.method_6988();
        this.field_11863.method_8649((class_1297)itemEntity);
        this.inventoryContentsChanged(0);
    }

    public int getSelectedFrameIndex() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(int index) {
        if (this.selectedFrame != index) {
            this.selectedFrame = index;
            this.stopPrintingProcess();
        }
    }

    public Lightroom.Process getProcess() {
        return this.process;
    }

    public Lightroom.Process getActualProcess(class_1799 filmStack) {
        class_1799 film = this.method_5438(0);
        if (!this.isSelectedFrameChromatic(film, this.getSelectedFrameIndex())) {
            return Lightroom.Process.REGULAR;
        }
        return this.process;
    }

    public void setProcess(Lightroom.Process process) {
        this.process = process;
        this.stopPrintingProcess();
        this.method_5431();
    }

    public Optional<class_2487> getSelectedFrame(class_1799 film) {
        DevelopedFilmItem developedFilm;
        class_2499 frames;
        class_1792 class_17922;
        if (!film.method_7960() && (class_17922 = film.method_7909()) instanceof DevelopedFilmItem && (frames = (developedFilm = (DevelopedFilmItem)class_17922).getExposedFrames(film)).size() > this.getSelectedFrameIndex()) {
            return Optional.of(frames.method_10602(this.selectedFrame));
        }
        return Optional.empty();
    }

    public boolean isSelectedFrameChromatic(class_1799 film, int selectedFrame) {
        return this.getSelectedFrame(film).map(frame -> frame.method_10577("Chromatic")).orElse(false);
    }

    public void startPrintingProcess(boolean advanceFrameOnFinish) {
        if (!this.canPrint()) {
            return;
        }
        class_1799 filmStack = this.method_5438(0);
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem film = (DevelopedFilmItem)class_17922;
        this.printTime = this.getActualProcess(filmStack) == Lightroom.Process.CHROMATIC ? (Integer)Config.Common.LIGHTROOM_CHROMATIC_PRINT_TIME.get() : (film.getType() == FilmType.BLACK_AND_WHITE ? ((Integer)Config.Common.LIGHTROOM_BW_PRINT_TIME.get()).intValue() : ((Integer)Config.Common.LIGHTROOM_COLOR_PRINT_TIME.get()).intValue());
        this.advanceFrame = advanceFrameOnFinish;
        if (this.field_11863 != null) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.field_11863.method_8320(this.method_11016()).method_11657((class_2769)LightroomBlock.LIT, (Comparable)Boolean.valueOf(true)), 2);
            this.field_11863.method_8396(null, this.method_11016(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), class_3419.field_15245, 1.0f, this.field_11863.method_8409().method_43057() * 0.3f + 1.0f);
        }
    }

    public void stopPrintingProcess() {
        this.progress = 0;
        this.printTime = 0;
        this.advanceFrame = false;
        if (this.field_11863 != null && this.field_11863.method_8320(this.method_11016()).method_26204() instanceof LightroomBlock) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.field_11863.method_8320(this.method_11016()).method_11657((class_2769)LightroomBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean isPrinting() {
        return this.printTime > 0;
    }

    public boolean canPrint() {
        DevelopedFilmItem developedFilm;
        if (this.getSelectedFrameIndex() < 0) {
            return false;
        }
        class_1799 filmStack = this.method_5438(0);
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof DevelopedFilmItem) || !(developedFilm = (DevelopedFilmItem)class_17922).hasExposedFrame(filmStack, this.getSelectedFrameIndex())) {
            return false;
        }
        Lightroom.Process process = this.getActualProcess(filmStack);
        class_1799 paperStack = this.method_5438(1);
        return this.isPaperValidForPrint(paperStack, filmStack, process) && this.hasDyesForPrint(filmStack, paperStack, process) && this.canOutputToResultSlot(this.method_5438(6), filmStack, process);
    }

    public boolean canPrintInCreativeMode() {
        DevelopedFilmItem developedFilm;
        if (this.getSelectedFrameIndex() < 0) {
            return false;
        }
        class_1799 filmStack = this.method_5438(0);
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof DevelopedFilmItem) || !(developedFilm = (DevelopedFilmItem)class_17922).hasExposedFrame(filmStack, this.getSelectedFrameIndex())) {
            return false;
        }
        return this.canOutputToResultSlot(this.method_5438(6), filmStack, this.getActualProcess(filmStack));
    }

    protected boolean isPaperValidForPrint(class_1799 paperStack, class_1799 filmStack, Lightroom.Process process) {
        if (paperStack.method_7960()) {
            return false;
        }
        return process != Lightroom.Process.REGULAR || paperStack.method_31573(Exposure.Tags.Items.PHOTO_PAPERS);
    }

    protected boolean hasDyesForPrint(class_1799 film, class_1799 paper, Lightroom.Process process) {
        int[] dyeSlots;
        for (int slot : dyeSlots = this.getRequiredDyeSlotsForPrint(film, paper, process)) {
            if (!this.method_5438(slot).method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean canOutputToResultSlot(class_1799 resultStack, class_1799 filmStack, Lightroom.Process process) {
        StackedPhotographsItem stackedPhotographsItem;
        class_1792 class_17922;
        if (this.isSelectedFrameChromatic(filmStack, this.getSelectedFrameIndex()) && process == Lightroom.Process.CHROMATIC) {
            return resultStack.method_7960();
        }
        return resultStack.method_7960() || resultStack.method_7909() instanceof PhotographItem || (class_17922 = resultStack.method_7909()) instanceof StackedPhotographsItem && (stackedPhotographsItem = (StackedPhotographsItem)class_17922).canAddPhotograph(resultStack);
    }

    protected int[] getRequiredDyeSlotsForPrint(class_1799 film, class_1799 paper, Lightroom.Process process) {
        class_1792 class_17922 = film.method_7909();
        if (!(class_17922 instanceof IFilmItem)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        IFilmItem filmItem = (IFilmItem)class_17922;
        if (process == Lightroom.Process.REGULAR) {
            return filmItem.getType() == FilmType.COLOR ? Lightroom.DYES_FOR_COLOR : Lightroom.DYES_FOR_BW;
        }
        if (process == Lightroom.Process.CHROMATIC) {
            int chromaticStep = this.getChromaticStep(paper);
            if (chromaticStep == 0) {
                return Lightroom.DYES_FOR_CHROMATIC_RED;
            }
            if (chromaticStep == 1) {
                return Lightroom.DYES_FOR_CHROMATIC_GREEN;
            }
            if (chromaticStep == 2) {
                return Lightroom.DYES_FOR_CHROMATIC_BLUE;
            }
        }
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    protected int getChromaticStep(class_1799 paper) {
        class_1792 class_17922 = paper.method_7909();
        if (!(class_17922 instanceof ChromaticSheetItem)) {
            return 0;
        }
        ChromaticSheetItem chromaticFragment = (ChromaticSheetItem)class_17922;
        return chromaticFragment.getExposures(paper).size();
    }

    public boolean tryPrint() {
        String id;
        int[] dyesSlots;
        Preconditions.checkState((this.field_11863 != null && !this.field_11863.field_9236 ? 1 : 0) != 0, (Object)"Cannot be called clientside.");
        if (!this.canPrint()) {
            return false;
        }
        class_1799 filmStack = this.method_5438(0);
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof DevelopedFilmItem)) {
            return false;
        }
        DevelopedFilmItem developedFilm = (DevelopedFilmItem)class_17922;
        Optional<class_2487> selectedFrame = this.getSelectedFrame(filmStack);
        if (selectedFrame.isEmpty()) {
            LogUtils.getLogger().error("Unable to get selected frame '{}' : {}", (Object)this.getSelectedFrameIndex(), (Object)filmStack);
            return false;
        }
        class_2487 frame = selectedFrame.get().method_10553();
        Lightroom.Process process = this.getActualProcess(filmStack);
        class_1799 paperStack = this.method_5438(1);
        class_1799 printResult = this.createPrintResult(frame, filmStack, paperStack, process);
        this.putPrintResultInOutputSlot(printResult);
        for (int slot : dyesSlots = this.getRequiredDyeSlotsForPrint(filmStack, paperStack, process)) {
            this.method_5438(slot).method_7934(1);
        }
        this.method_5438(1).method_7934(1);
        this.field_11863.method_8396(null, this.method_11016(), Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), class_3419.field_15248, 0.8f, 1.0f);
        this.storeExperienceForPrint(filmStack, frame, process, printResult);
        if (process != Lightroom.Process.CHROMATIC && !(id = frame.method_10558("Id")).isEmpty()) {
            ExposureServer.getExposureStorage().getOrQuery(id).ifPresent(exposure -> {
                class_2487 properties = exposure.getProperties();
                if (!properties.method_10577("WasPrinted")) {
                    properties.method_10556("WasPrinted", true);
                    exposure.method_80();
                }
            });
        }
        return true;
    }

    protected void storeExperienceForPrint(class_1799 film, class_2487 frame, Lightroom.Process process, class_1799 result) {
        if (this.field_11863 == null) {
            return;
        }
        int xp = 0;
        if (process == Lightroom.Process.CHROMATIC) {
            xp = result.method_7909() instanceof ChromaticSheetItem ? 0 : (Integer)Config.Common.LIGHTROOM_EXPERIENCE_PER_PRINT_CHROMATIC.get();
        } else {
            class_1792 class_17922 = film.method_7909();
            if (class_17922 instanceof IFilmItem) {
                IFilmItem filmItem = (IFilmItem)class_17922;
                xp = filmItem.getType() == FilmType.COLOR ? (Integer)Config.Common.LIGHTROOM_EXPERIENCE_PER_PRINT_COLOR.get() : (Integer)Config.Common.LIGHTROOM_EXPERIENCE_PER_PRINT_BW.get();
            }
        }
        if (xp > 0) {
            float variability = this.field_11863.method_8409().method_43057() * 0.3f + 1.0f;
            int variableXp = (int)Math.max(1.0, Math.ceil((float)xp * variability));
            this.storedExperience += variableXp;
        }
    }

    public void printInCreativeMode() {
        String id;
        Preconditions.checkState((this.field_11863 != null && !this.field_11863.field_9236 ? 1 : 0) != 0, (Object)"Cannot be called clientside.");
        if (!this.canPrintInCreativeMode()) {
            return;
        }
        class_1799 filmStack = this.method_5438(0);
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem developedFilm = (DevelopedFilmItem)class_17922;
        Optional<class_2487> selectedFrame = this.getSelectedFrame(filmStack);
        if (selectedFrame.isEmpty()) {
            LogUtils.getLogger().error("Unable to get selected frame '{}' : {}", (Object)this.getSelectedFrameIndex(), (Object)filmStack);
            return;
        }
        class_2487 frame = selectedFrame.get().method_10553();
        Lightroom.Process process = this.getActualProcess(filmStack);
        class_1799 paperStack = this.method_5438(1);
        class_1799 printResult = this.createPrintResult(frame, filmStack, paperStack, process);
        this.putPrintResultInOutputSlot(printResult);
        if (process == Lightroom.Process.CHROMATIC) {
            this.method_5438(1).method_7934(1);
        }
        this.field_11863.method_8396(null, this.method_11016(), Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), class_3419.field_15248, 0.8f, 1.0f);
        if (process != Lightroom.Process.CHROMATIC && !(id = frame.method_10558("Id")).isEmpty()) {
            ExposureServer.getExposureStorage().getOrQuery(id).ifPresent(exposure -> {
                class_2487 properties = exposure.getProperties();
                if (!properties.method_10577("WasPrinted")) {
                    properties.method_10556("WasPrinted", true);
                    exposure.method_80();
                }
            });
        }
    }

    protected void putPrintResultInOutputSlot(class_1799 printResult) {
        class_1799 resultStack = this.method_5438(6);
        if (resultStack.method_7960()) {
            resultStack = printResult;
        } else if (resultStack.method_7909() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            class_1799 newStackedPhotographs = new class_1799((class_1935)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, resultStack);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, printResult);
            resultStack = newStackedPhotographs;
        } else {
            class_1792 class_17922 = resultStack.method_7909();
            if (class_17922 instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)class_17922;
                stackedPhotographsItem.addPhotographOnTop(resultStack, printResult);
            } else {
                LogUtils.getLogger().error("Unexpected item in result slot: " + resultStack);
                return;
            }
        }
        this.method_5447(6, resultStack);
    }

    protected class_1799 createPrintResult(class_2487 frame, class_1799 film, class_1799 paper, Lightroom.Process process) {
        class_1792 class_17922 = film.method_7909();
        if (!(class_17922 instanceof IFilmItem)) {
            throw new IllegalStateException("Film stack is invalid: " + film);
        }
        IFilmItem filmItem = (IFilmItem)class_17922;
        paper = paper.method_7972();
        frame.method_10582("Type", process == Lightroom.Process.REGULAR ? filmItem.getType().method_15434() : FilmType.COLOR.method_15434());
        if (process == Lightroom.Process.CHROMATIC) {
            ItemAndStack chromaticFragment = new ItemAndStack(paper.method_7909() instanceof ChromaticSheetItem ? paper : new class_1799((class_1935)Exposure.Items.CHROMATIC_SHEET.get()));
            ((ChromaticSheetItem)((Object)chromaticFragment.getItem())).addExposure(chromaticFragment.getStack(), frame);
            if (((ChromaticSheetItem)((Object)chromaticFragment.getItem())).getExposures(chromaticFragment.getStack()).size() >= 3) {
                return ((ChromaticSheetItem)((Object)chromaticFragment.getItem())).finalize(Objects.requireNonNull(this.field_11863), chromaticFragment.getStack());
            }
            return chromaticFragment.getStack();
        }
        class_1799 photographStack = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
        photographStack.method_7980(frame);
        return photographStack;
    }

    public void dropStoredExperience(@Nullable class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.storedExperience > 0) {
                class_1303.method_31493((class_3218)serverLevel, (class_243)class_243.method_24953((class_2382)this.method_11016()), (int)this.storedExperience);
                this.storedExperience = 0;
                this.method_5431();
            }
        }
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.exposure.lightroom");
    }

    @NotNull
    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new LightroomMenu(containerId, inventory, this, this.containerData);
    }

    public boolean isItemValidForSlot(int slot, class_1799 stack) {
        if (slot == 0) {
            return stack.method_7909() instanceof DevelopedFilmItem;
        }
        if (slot == 2) {
            return stack.method_31573(Exposure.Tags.Items.CYAN_PRINTING_DYES);
        }
        if (slot == 3) {
            return stack.method_31573(Exposure.Tags.Items.MAGENTA_PRINTING_DYES);
        }
        if (slot == 4) {
            return stack.method_31573(Exposure.Tags.Items.YELLOW_PRINTING_DYES);
        }
        if (slot == 5) {
            return stack.method_31573(Exposure.Tags.Items.BLACK_PRINTING_DYES);
        }
        if (slot == 1) {
            ChromaticSheetItem chromatic;
            class_1792 class_17922;
            return stack.method_31573(Exposure.Tags.Items.PHOTO_PAPERS) || (class_17922 = stack.method_7909()) instanceof ChromaticSheetItem && (chromatic = (ChromaticSheetItem)class_17922).getExposures(stack).size() < 3;
        }
        if (slot == 6) {
            return stack.method_7909() instanceof PhotographItem || stack.method_7909() instanceof ChromaticSheetItem;
        }
        return false;
    }

    protected void inventoryContentsChanged(int slot) {
        if (slot == 0) {
            this.setSelectedFrame(0);
        }
        this.method_5431();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return this.field_11863 != null && this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 face) {
        return Lightroom.ALL_SLOTS;
    }

    public boolean method_5492(int index, @NotNull class_1799 itemStack, @Nullable class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return false;
        }
        return this.method_5437(index, itemStack);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return index != 6 && this.isItemValidForSlot(index, stack) && super.method_5437(index, stack);
    }

    public boolean method_5493(int index, @NotNull class_1799 pStack, @NotNull class_2350 direction) {
        for (int outputSlot : Lightroom.OUTPUT_SLOTS) {
            if (index != outputSlot) continue;
            return true;
        }
        return false;
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.items);
        if (tag.method_10573("Inventory", 10)) {
            class_2487 inventory = tag.method_10562("Inventory");
            class_2499 itemsList = inventory.method_10554("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                class_2487 itemTags = itemsList.method_10602(i);
                int slot = itemTags.method_10550("Slot");
                if (slot < 0 || slot >= this.items.size()) continue;
                this.items.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
            }
        }
        this.setSelectedFrame(tag.method_10550("SelectedFrame"));
        this.progress = tag.method_10550("Progress");
        this.printTime = tag.method_10550("PrintTime");
        this.storedExperience = tag.method_10550("PrintedPhotographsCount");
        this.advanceFrame = tag.method_10577("AdvanceFrame");
        this.process = Lightroom.Process.fromStringOrDefault(tag.method_10558("Process"), Lightroom.Process.REGULAR);
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        if (this.getSelectedFrameIndex() > 0) {
            tag.method_10569("SelectedFrame", this.getSelectedFrameIndex());
        }
        if (this.progress > 0) {
            tag.method_10569("Progress", this.progress);
        }
        if (this.printTime > 0) {
            tag.method_10569("PrintTime", this.printTime);
        }
        if (this.storedExperience > 0) {
            tag.method_10569("PrintedPhotographsCount", this.storedExperience);
        }
        if (this.advanceFrame) {
            tag.method_10556("AdvanceFrame", true);
        }
        if (this.process != Lightroom.Process.REGULAR) {
            tag.method_10582("Process", this.process.method_15434());
        }
    }

    protected class_2371<class_1799> getItems() {
        return this.items;
    }

    public int method_5439() {
        return 7;
    }

    public boolean method_5442() {
        return this.getItems().stream().allMatch(class_1799::method_7960);
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return (class_1799)this.getItems().get(slot);
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.getItems(), (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.inventoryContentsChanged(slot);
        }
        return itemStack;
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.getItems(), (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.inventoryContentsChanged(slot);
    }

    public void method_5448() {
        this.getItems().clear();
        this.inventoryContentsChanged(-1);
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }
}

