/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.advancement.predicate.ExposurePredicate;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import net.minecraft.class_195;
import net.minecraft.class_2090;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

public class CameraFilmFrameExposedTrigger
extends class_4558<TriggerInstance> {
    public static final class_2960 ID = Exposure.resource("frame_exposed");

    @NotNull
    public class_2960 method_794() {
        return ID;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject json, @NotNull class_5258 predicate, @NotNull class_5257 deserializationContext) {
        class_2090 location = class_2090.method_9021((JsonElement)json.get("location"));
        ExposurePredicate exposure = ExposurePredicate.fromJson(json.get("exposure"));
        return new TriggerInstance(predicate, location, exposure);
    }

    public void trigger(class_3222 player, ItemAndStack<CameraItem> camera, class_2487 frame) {
        this.method_22510(player, triggerInstance -> triggerInstance.matches(player, camera, frame));
    }

    public static class TriggerInstance
    extends class_195 {
        private final class_2090 locationPredicate;
        private final ExposurePredicate exposurePredicate;

        public TriggerInstance(class_5258 predicate, class_2090 locationPredicate, ExposurePredicate exposurePredicate) {
            super(ID, predicate);
            this.locationPredicate = locationPredicate;
            this.exposurePredicate = exposurePredicate;
        }

        public boolean matches(class_3222 player, ItemAndStack<CameraItem> camera, class_2487 frame) {
            if (!this.locationPredicate.method_9018(player.method_51469(), player.method_23317(), player.method_23318(), player.method_23321())) {
                return false;
            }
            return this.exposurePredicate.matches(player, frame);
        }

        @NotNull
        public JsonObject method_807(@NotNull class_5267 conditions) {
            JsonObject jsonobject = super.method_807(conditions);
            if (this.exposurePredicate != ExposurePredicate.ANY) {
                jsonobject.add("exposure", this.exposurePredicate.serializeToJson());
            }
            if (this.locationPredicate != class_2090.field_9685) {
                jsonobject.add("location", this.locationPredicate.method_9019());
            }
            return jsonobject;
        }
    }
}

