/*
 * Decompiled with CFR 0.152.
 */
package net.msymbios.monsters_girls.entity.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.msymbios.monsters_girls.block.MonstersGirlsBlocks;
import net.msymbios.monsters_girls.entity.enums.EntityAnimation;
import net.msymbios.monsters_girls.entity.enums.EntityAnimator;
import net.msymbios.monsters_girls.entity.enums.EntityAttribute;
import net.msymbios.monsters_girls.entity.enums.EntityCategory;
import net.msymbios.monsters_girls.entity.enums.EntityModel;
import net.msymbios.monsters_girls.entity.enums.EntitySetting;
import net.msymbios.monsters_girls.entity.enums.EntitySound;
import net.msymbios.monsters_girls.entity.enums.EntityTexture;
import net.msymbios.monsters_girls.entity.enums.EntityVariant;
import net.msymbios.monsters_girls.entity.internal.BlockPlanting;
import net.msymbios.monsters_girls.entity.internal.InternalData;
import net.msymbios.monsters_girls.entity.internal.InternalPlanting;
import net.msymbios.monsters_girls.item.MonstersGirlsItems;
import net.msymbios.monsters_girls.sounds.MonstersGirlsSounds;

public class InternalMetric {
    private static final Random rand = new Random();
    public static float LOOK_RANGE;
    public static int ATTACK_CHANCE;
    public static boolean GLOBAL_AUTO_HEAL;
    public static int GLOBAL_HEAL_INTERVAL;
    public static int WARY_TIME;
    public static Predicate<class_1309> AvoidAttackingEntities;
    public static HashMap<EntityVariant, List<class_1792>> ENTITY_TAMABLE_ITEM;
    public static HashMap<EntityAnimation, List<EntityCategory>> ENTITY_ANIMATION;
    public static HashMap<EntitySound, List<EntityVariant>> ENTITY_SOUND;
    public static HashMap<EntityCategory, HashMap<EntityVariant, EntityAnimator>> ENTITY_ANIMATOR;
    public static HashMap<EntityCategory, HashMap<EntityVariant, EntityModel>> ENTITY_MODEL;
    public static HashMap<EntityTexture, List<EntityVariant>> ENTITY_TEXTURE;
    public static HashMap<EntityVariant, HashMap<EntitySound, class_3414>> SOUND;
    public static HashMap<EntityAnimator, class_2960> ANIMATOR;
    public static HashMap<EntityModel, class_2960> MODEL;
    public static HashMap<EntityVariant, HashMap<EntityTexture, class_2960>> TEXTURE;
    public static List<HashMap<EntityTexture, class_2960>> BEE_TEXTURES;
    public static HashMap<EntityVariant, HashMap<EntityAttribute, Float>> ATTRIBUTES;
    public static HashMap<EntityVariant, HashMap<EntitySetting, InternalData>> SETTINGS;
    public static HashMap<EntityVariant, List<List<InternalData>>> HELPFUL_EFFECTS;
    public static HashMap<EntityVariant, List<List<InternalData>>> HARMFUL_EFFECTS;
    public static HashMap<EntityVariant, InternalPlanting> PLANTING;

    public static int getRandomBeeTextureID() {
        if (!BEE_TEXTURES.isEmpty()) {
            return rand.nextInt(BEE_TEXTURES.size());
        }
        return -1;
    }

    public static int getRandomBeeBellyLevelID(int value) {
        if (!BEE_TEXTURES.isEmpty()) {
            return rand.nextInt(BEE_TEXTURES.get(value).size());
        }
        return -1;
    }

    public static boolean getAnimation(EntityCategory category, EntityAnimation animation) {
        return ENTITY_ANIMATION.containsKey((Object)animation) && ENTITY_ANIMATION.get((Object)animation).contains((Object)category);
    }

    public static class_3414 getSound(EntityVariant variant) {
        EntitySound defaultSound = EntitySound.DEFAULT;
        if (ENTITY_SOUND.containsKey((Object)defaultSound) && ENTITY_SOUND.get((Object)defaultSound).contains((Object)variant) && SOUND.containsKey((Object)variant) && SOUND.get((Object)variant).containsKey((Object)defaultSound)) {
            return SOUND.get((Object)variant).get((Object)defaultSound);
        }
        return null;
    }

    public static class_3414 getSound(EntityVariant variant, EntitySound sound) {
        if (ENTITY_SOUND.containsKey((Object)sound) && ENTITY_SOUND.get((Object)sound).contains((Object)variant) && SOUND.containsKey((Object)variant) && SOUND.get((Object)variant).containsKey((Object)sound)) {
            return SOUND.get((Object)variant).get((Object)sound);
        }
        if (SOUND.containsKey((Object)variant) && SOUND.get((Object)variant).containsKey((Object)EntitySound.DEFAULT)) {
            return SOUND.get((Object)variant).get((Object)EntitySound.DEFAULT);
        }
        return null;
    }

    public static class_2960 getAnimator(EntityCategory entity, EntityVariant variant) {
        EntityAnimator selectedAnimator;
        HashMap<EntityVariant, EntityAnimator> variantMap = ENTITY_ANIMATOR.get((Object)entity);
        if (variantMap != null && (selectedAnimator = variantMap.get((Object)variant)) != null && ANIMATOR.containsKey((Object)selectedAnimator)) {
            return ANIMATOR.get((Object)selectedAnimator);
        }
        return null;
    }

    public static class_2960 getAnimator(EntityCategory entity, EntityVariant variant, EntityAnimator animator) {
        EntityAnimator selectedAnimator;
        HashMap<EntityVariant, EntityAnimator> variantMap = ENTITY_ANIMATOR.get((Object)entity);
        if (variantMap != null && (selectedAnimator = variantMap.get((Object)variant)) != null && selectedAnimator == animator) {
            return ANIMATOR.get((Object)animator);
        }
        return null;
    }

    public static class_2960 getModel(EntityCategory entity, EntityVariant variant) {
        EntityModel model;
        if (ENTITY_MODEL.containsKey((Object)entity) && ENTITY_MODEL.get((Object)entity).containsKey((Object)variant) && MODEL.containsKey((Object)(model = ENTITY_MODEL.get((Object)entity).get((Object)variant)))) {
            return MODEL.get((Object)model);
        }
        return new class_2960("monsters_girls", "geo/mandrake_girl_default.geo.json");
    }

    public static class_2960 getModel(EntityCategory entity, EntityVariant variant, EntityModel model) {
        EntityModel actualModel;
        if (ENTITY_MODEL.containsKey((Object)entity) && ENTITY_MODEL.get((Object)entity).containsKey((Object)variant) && (actualModel = ENTITY_MODEL.get((Object)entity).get((Object)variant)) == model && MODEL.containsKey((Object)model)) {
            return MODEL.get((Object)model);
        }
        return new class_2960("monsters_girls", "geo/mandrake_girl_default.geo.json");
    }

    public static class_2960 getTexture(EntityVariant variant) {
        class_2960 defaultTexture = null;
        EntityTexture randomTexture = EntityTexture.byId(InternalMetric.getRandomTextureID(variant));
        if (ENTITY_TEXTURE.containsKey((Object)randomTexture) && ENTITY_TEXTURE.get((Object)randomTexture).contains((Object)variant) && TEXTURE.containsKey((Object)variant) && TEXTURE.get((Object)variant).containsKey((Object)randomTexture)) {
            defaultTexture = TEXTURE.get((Object)variant).get((Object)randomTexture);
        }
        return defaultTexture;
    }

    public static class_2960 getTexture(EntityVariant variant, EntityTexture texture) {
        class_2960 defaultTexture = null;
        if (ENTITY_TEXTURE.containsKey((Object)texture) && ENTITY_TEXTURE.get((Object)texture).contains((Object)variant) && TEXTURE.containsKey((Object)variant) && TEXTURE.get((Object)variant).containsKey((Object)texture)) {
            defaultTexture = TEXTURE.get((Object)variant).get((Object)texture);
        }
        if (TEXTURE.containsKey((Object)variant) && TEXTURE.get((Object)variant).containsKey((Object)EntityTexture.DEFAULT)) {
            defaultTexture = TEXTURE.get((Object)variant).get((Object)EntityTexture.byId(InternalMetric.getRandomTextureID(variant)));
        }
        return defaultTexture;
    }

    public static boolean checkTextureID(EntityVariant variant, EntityTexture texture) {
        if (ENTITY_TEXTURE.containsKey((Object)texture) && ENTITY_TEXTURE.get((Object)texture).contains((Object)variant)) {
            return TEXTURE.containsKey((Object)variant) && TEXTURE.get((Object)variant).containsKey((Object)texture);
        }
        return false;
    }

    public static int getRandomTextureID(EntityVariant variant) {
        List<EntityTexture> textures = ENTITY_TEXTURE.keySet().stream().filter(entityTexture -> ENTITY_TEXTURE.get(entityTexture).contains((Object)variant)).toList();
        if (!textures.isEmpty()) {
            EntityTexture randomTexture = textures.get(rand.nextInt(textures.size()));
            return randomTexture.getId();
        }
        return -1;
    }

    private static HashMap<EntityTexture, class_2960> setTexture(final String suffix, final boolean overrideDefault, final boolean slim, final boolean tummy, final boolean inflated, final boolean chunky) {
        final String path = "textures/entity/";
        return new HashMap<EntityTexture, class_2960>(){
            {
                if (slim) {
                    this.put(EntityTexture.SLIM, new class_2960("monsters_girls", path + suffix + "_slim.png"));
                }
                if (overrideDefault) {
                    this.put(EntityTexture.DEFAULT, new class_2960("monsters_girls", path + suffix + "_default.png"));
                } else {
                    this.put(EntityTexture.DEFAULT, new class_2960("monsters_girls", path + suffix + ".png"));
                }
                if (tummy) {
                    this.put(EntityTexture.TUMMY, new class_2960("monsters_girls", path + suffix + "_tummy.png"));
                }
                if (inflated) {
                    this.put(EntityTexture.INFLATED, new class_2960("monsters_girls", path + suffix + "_inflated.png"));
                }
                if (chunky) {
                    this.put(EntityTexture.CHUNKY, new class_2960("monsters_girls", path + suffix + "_chunky.png"));
                }
            }
        };
    }

    public static float getAttribute(EntityVariant variant, EntityAttribute attribute) {
        Float entityAttribute = ATTRIBUTES.get((Object)variant).get((Object)attribute);
        return entityAttribute == null ? 0.0f : entityAttribute.floatValue();
    }

    public static HashMap<EntitySetting, InternalData> setSetting(final int weight, final int minGroup, final int maxGroup, final List<class_5321<class_1959>> biomes, final Predicate<class_1309> avoidEntities) {
        return new HashMap<EntitySetting, InternalData>(){
            {
                this.put(EntitySetting.SpawnWeight, new InternalData(weight));
                this.put(EntitySetting.SpawnMinGroup, new InternalData(minGroup));
                this.put(EntitySetting.SpawnMaxGroup, new InternalData(maxGroup));
                this.put(EntitySetting.BiomesSelector, new InternalData(biomes));
                this.put(EntitySetting.PredicateEntitySelector, new InternalData(avoidEntities));
            }
        };
    }

    static {
        AvoidAttackingEntities = entity -> entity instanceof class_1569 && !(entity instanceof class_1548);
        ENTITY_TAMABLE_ITEM = new HashMap<EntityVariant, List<class_1792>>(){
            {
                ArrayList<class_1792> mushroomTamable = new ArrayList<class_1792>(List.of(class_1802.field_8511, class_1802.field_8423));
                ArrayList<class_1792> wispTamable = new ArrayList<class_1792>(List.of(class_1802.field_8397, class_1802.field_8695));
                ArrayList<class_1792> pumpkin = new ArrayList<class_1792>(List.of(class_1802.field_17534, class_1802.field_8324));
                ArrayList<class_1792> jackOLantern = new ArrayList<class_1792>(List.of(class_1802.field_17534, MonstersGirlsItems.CANDIES));
                this.put(EntityVariant.Bee, new ArrayList<class_1792>(List.of(class_1802.field_20417)));
                this.put(EntityVariant.JackOLantern, jackOLantern);
                this.put(EntityVariant.JackOLanternBig, jackOLantern);
                this.put(EntityVariant.JackOLanternMini, jackOLantern);
                this.put(EntityVariant.Pumpkin, pumpkin);
                this.put(EntityVariant.PumpkinBig, pumpkin);
                this.put(EntityVariant.PumpkinMini, pumpkin);
                this.put(EntityVariant.MandrakeBrown, new ArrayList<class_1792>(List.of(class_1802.field_8423, class_1802.field_8324)));
                this.put(EntityVariant.MandrakeGlowBerry, new ArrayList<class_1792>(List.of(class_1802.field_28659)));
                this.put(EntityVariant.MandrakeGreen, new ArrayList<class_1792>(List.of(class_1802.field_8423, class_1802.field_8324)));
                this.put(EntityVariant.MandrakeChorus, new ArrayList<class_1792>(List.of(class_1802.field_8233)));
                this.put(EntityVariant.MushroomBrown, mushroomTamable);
                this.put(EntityVariant.MushroomEnderPuffball, mushroomTamable);
                this.put(EntityVariant.MushroomCrimson, mushroomTamable);
                this.put(EntityVariant.MushroomCrimsonRare, mushroomTamable);
                this.put(EntityVariant.MushroomFlyAgaricYellow, mushroomTamable);
                this.put(EntityVariant.MushroomFlyAgaricRed, mushroomTamable);
                this.put(EntityVariant.MushroomInfernal, mushroomTamable);
                this.put(EntityVariant.FungusInkCap, mushroomTamable);
                this.put(EntityVariant.MushroomMolten, mushroomTamable);
                this.put(EntityVariant.MushroomWarped, mushroomTamable);
                this.put(EntityVariant.MushroomWarpedRare, mushroomTamable);
                this.put(EntityVariant.MushroomSoulWanderer, mushroomTamable);
                this.put(EntityVariant.MushroomSnowball, new ArrayList<class_1792>(List.of(class_1802.field_8543)));
                this.put(EntityVariant.SlimeBlue, new ArrayList<class_1792>(List.of(class_1802.field_8777)));
                this.put(EntityVariant.SpookTeal, new ArrayList<class_1792>(List.of(MonstersGirlsItems.SPECTRAL_CAKE)));
                this.put(EntityVariant.SpookPeach, new ArrayList<class_1792>(List.of(MonstersGirlsItems.SPECTRAL_CAKE)));
                this.put(EntityVariant.WispBlue, wispTamable);
                this.put(EntityVariant.WispGreen, wispTamable);
                this.put(EntityVariant.WispYellow, wispTamable);
            }
        };
        ENTITY_ANIMATION = new HashMap<EntityAnimation, List<EntityCategory>>(){
            {
                this.put(EntityAnimation.Idle, new ArrayList<EntityCategory>(List.of(EntityCategory.Bee, EntityCategory.Gourdragora, EntityCategory.Mandrake, EntityCategory.Mushroom, EntityCategory.Slime, EntityCategory.Spook, EntityCategory.Wisp)));
                this.put(EntityAnimation.Walk, new ArrayList<EntityCategory>(List.of(EntityCategory.Gourdragora, EntityCategory.Mandrake, EntityCategory.Mushroom, EntityCategory.Slime, EntityCategory.Spook, EntityCategory.Wisp)));
                this.put(EntityAnimation.Rest, new ArrayList<EntityCategory>(List.of(EntityCategory.Bee, EntityCategory.Gourdragora, EntityCategory.Mandrake, EntityCategory.Mushroom, EntityCategory.Slime, EntityCategory.Spook, EntityCategory.Wisp)));
                this.put(EntityAnimation.Attack, new ArrayList<EntityCategory>(List.of(EntityCategory.Gourdragora, EntityCategory.Mandrake, EntityCategory.Mushroom, EntityCategory.Slime, EntityCategory.Spook, EntityCategory.Wisp)));
            }
        };
        ENTITY_SOUND = new HashMap<EntitySound, List<EntityVariant>>(){
            {
                this.put(EntitySound.DEFAULT, new ArrayList<EntityVariant>(List.of(EntityVariant.JackOLantern, EntityVariant.JackOLanternBig, EntityVariant.JackOLanternMini, EntityVariant.Pumpkin, EntityVariant.PumpkinBig, EntityVariant.PumpkinMini, EntityVariant.MandrakeBrown, EntityVariant.MandrakeChorus, EntityVariant.MandrakeGreen, EntityVariant.MandrakeGlowBerry, EntityVariant.MushroomFlyAgaricYellow, EntityVariant.MushroomBrown, EntityVariant.MushroomCrimson, EntityVariant.MushroomCrimsonRare, EntityVariant.MushroomEnderPuffball, EntityVariant.MushroomInfernal, EntityVariant.FungusInkCap, EntityVariant.MushroomMolten, EntityVariant.MushroomFlyAgaricRed, EntityVariant.MushroomSoulWanderer, EntityVariant.MushroomWarped, EntityVariant.MushroomWarpedRare, EntityVariant.MushroomSnowball, EntityVariant.SlimeBlue, EntityVariant.SpookPeach, EntityVariant.SpookTeal, EntityVariant.WispBlue, EntityVariant.WispGreen, EntityVariant.WispYellow)));
                this.put(EntitySound.HURT, new ArrayList<EntityVariant>(List.of(EntityVariant.MandrakeBrown, EntityVariant.MandrakeChorus, EntityVariant.MandrakeGreen, EntityVariant.MandrakeGlowBerry, EntityVariant.SlimeBlue, EntityVariant.SpookPeach, EntityVariant.SpookTeal, EntityVariant.WispBlue, EntityVariant.WispGreen, EntityVariant.WispYellow)));
                this.put(EntitySound.DEATH, new ArrayList<EntityVariant>(List.of(EntityVariant.MandrakeBrown, EntityVariant.MandrakeChorus, EntityVariant.MandrakeGreen, EntityVariant.MandrakeGlowBerry, EntityVariant.WispBlue, EntityVariant.WispGreen, EntityVariant.WispYellow)));
                this.put(EntitySound.ATTACK, new ArrayList<EntityVariant>(List.of(EntityVariant.SpookPeach, EntityVariant.SpookTeal)));
            }
        };
        ENTITY_ANIMATOR = new HashMap<EntityCategory, HashMap<EntityVariant, EntityAnimator>>(){
            {
                this.put(EntityCategory.Bee, new HashMap<EntityVariant, EntityAnimator>(){
                    {
                        this.put(EntityVariant.Bee, EntityAnimator.Bee);
                    }
                });
                this.put(EntityCategory.Gourdragora, new HashMap<EntityVariant, EntityAnimator>(){
                    {
                        this.put(EntityVariant.JackOLantern, EntityAnimator.Gourdragora);
                        this.put(EntityVariant.JackOLanternBig, EntityAnimator.Gourdragora);
                        this.put(EntityVariant.JackOLanternMini, EntityAnimator.GourdragoraMini);
                        this.put(EntityVariant.Pumpkin, EntityAnimator.Gourdragora);
                        this.put(EntityVariant.PumpkinBig, EntityAnimator.Gourdragora);
                        this.put(EntityVariant.PumpkinMini, EntityAnimator.GourdragoraMini);
                    }
                });
                this.put(EntityCategory.Mandrake, new HashMap<EntityVariant, EntityAnimator>(){
                    {
                        this.put(EntityVariant.MandrakeBrown, EntityAnimator.Mandrake);
                        this.put(EntityVariant.MandrakeGreen, EntityAnimator.Mandrake);
                        this.put(EntityVariant.MandrakeGlowBerry, EntityAnimator.MandrakeFruity);
                        this.put(EntityVariant.MandrakeChorus, EntityAnimator.MandrakeFruityChorus);
                    }
                });
                this.put(EntityCategory.Mushroom, new HashMap<EntityVariant, EntityAnimator>(){
                    {
                        this.put(EntityVariant.MushroomFlyAgaricYellow, EntityAnimator.Mushroom);
                        this.put(EntityVariant.MushroomBrown, EntityAnimator.MushroomFat);
                        this.put(EntityVariant.MushroomCrimson, EntityAnimator.Mushroom);
                        this.put(EntityVariant.MushroomCrimsonRare, EntityAnimator.Mushroom);
                        this.put(EntityVariant.MushroomEnderPuffball, EntityAnimator.MushroomInflated);
                        this.put(EntityVariant.MushroomInfernal, EntityAnimator.MushroomFat);
                        this.put(EntityVariant.FungusInkCap, EntityAnimator.MushroomInkCap);
                        this.put(EntityVariant.MushroomMolten, EntityAnimator.MushroomFat);
                        this.put(EntityVariant.MushroomFlyAgaricRed, EntityAnimator.Mushroom);
                        this.put(EntityVariant.MushroomSoulWanderer, EntityAnimator.Mushroom);
                        this.put(EntityVariant.MushroomWarped, EntityAnimator.Mushroom);
                        this.put(EntityVariant.MushroomWarpedRare, EntityAnimator.Mushroom);
                        this.put(EntityVariant.MushroomSnowball, EntityAnimator.MushroomInflated);
                    }
                });
                this.put(EntityCategory.Slime, new HashMap<EntityVariant, EntityAnimator>(){
                    {
                        this.put(EntityVariant.SlimeBlue, EntityAnimator.Slime);
                    }
                });
                this.put(EntityCategory.Spook, new HashMap<EntityVariant, EntityAnimator>(){
                    {
                        this.put(EntityVariant.SpookPeach, EntityAnimator.Spook);
                        this.put(EntityVariant.SpookTeal, EntityAnimator.Spook);
                    }
                });
                this.put(EntityCategory.Wisp, new HashMap<EntityVariant, EntityAnimator>(){
                    {
                        this.put(EntityVariant.WispBlue, EntityAnimator.Wisp);
                        this.put(EntityVariant.WispGreen, EntityAnimator.Wisp);
                        this.put(EntityVariant.WispYellow, EntityAnimator.Wisp);
                    }
                });
            }
        };
        ENTITY_MODEL = new HashMap<EntityCategory, HashMap<EntityVariant, EntityModel>>(){
            {
                this.put(EntityCategory.Bee, new HashMap<EntityVariant, EntityModel>(){
                    {
                        this.put(EntityVariant.Bee, EntityModel.Bee);
                    }
                });
                this.put(EntityCategory.Gourdragora, new HashMap<EntityVariant, EntityModel>(){
                    {
                        this.put(EntityVariant.JackOLantern, EntityModel.Gourdragora);
                        this.put(EntityVariant.JackOLanternBig, EntityModel.Gourdragora);
                        this.put(EntityVariant.JackOLanternMini, EntityModel.GourdragoraMini);
                        this.put(EntityVariant.Pumpkin, EntityModel.Gourdragora);
                        this.put(EntityVariant.PumpkinBig, EntityModel.Gourdragora);
                        this.put(EntityVariant.PumpkinMini, EntityModel.GourdragoraMini);
                    }
                });
                this.put(EntityCategory.Mandrake, new HashMap<EntityVariant, EntityModel>(){
                    {
                        this.put(EntityVariant.MandrakeBrown, EntityModel.Mandrake);
                        this.put(EntityVariant.MandrakeGreen, EntityModel.Mandrake);
                        this.put(EntityVariant.MandrakeGlowBerry, EntityModel.MandrakeFruit);
                        this.put(EntityVariant.MandrakeChorus, EntityModel.MandrakeFruitChorus);
                    }
                });
                this.put(EntityCategory.Mushroom, new HashMap<EntityVariant, EntityModel>(){
                    {
                        this.put(EntityVariant.MushroomFlyAgaricYellow, EntityModel.Mushroom);
                        this.put(EntityVariant.MushroomBrown, EntityModel.MushroomFat);
                        this.put(EntityVariant.MushroomCrimson, EntityModel.Mushroom);
                        this.put(EntityVariant.MushroomCrimsonRare, EntityModel.Mushroom);
                        this.put(EntityVariant.MushroomEnderPuffball, EntityModel.MushroomInflated);
                        this.put(EntityVariant.MushroomInfernal, EntityModel.MushroomFat);
                        this.put(EntityVariant.FungusInkCap, EntityModel.MushroomFungus);
                        this.put(EntityVariant.MushroomMolten, EntityModel.MushroomFat);
                        this.put(EntityVariant.MushroomFlyAgaricRed, EntityModel.Mushroom);
                        this.put(EntityVariant.MushroomSoulWanderer, EntityModel.Mushroom);
                        this.put(EntityVariant.MushroomWarped, EntityModel.Mushroom);
                        this.put(EntityVariant.MushroomWarpedRare, EntityModel.Mushroom);
                        this.put(EntityVariant.MushroomSnowball, EntityModel.MushroomInflated);
                    }
                });
                this.put(EntityCategory.Slime, new HashMap<EntityVariant, EntityModel>(){
                    {
                        this.put(EntityVariant.SlimeBlue, EntityModel.Slime);
                    }
                });
                this.put(EntityCategory.Spook, new HashMap<EntityVariant, EntityModel>(){
                    {
                        this.put(EntityVariant.SpookPeach, EntityModel.Spook);
                        this.put(EntityVariant.SpookTeal, EntityModel.Spook);
                    }
                });
                this.put(EntityCategory.Wisp, new HashMap<EntityVariant, EntityModel>(){
                    {
                        this.put(EntityVariant.WispBlue, EntityModel.Wisp);
                        this.put(EntityVariant.WispGreen, EntityModel.Wisp);
                        this.put(EntityVariant.WispYellow, EntityModel.Wisp);
                    }
                });
            }
        };
        ENTITY_TEXTURE = new HashMap<EntityTexture, List<EntityVariant>>(){
            {
                this.put(EntityTexture.SLIM, new ArrayList<EntityVariant>(List.of(EntityVariant.Bee, EntityVariant.MushroomFlyAgaricYellow, EntityVariant.MushroomBrown, EntityVariant.MushroomCrimson, EntityVariant.MushroomCrimsonRare, EntityVariant.MushroomEnderPuffball, EntityVariant.MushroomInfernal, EntityVariant.FungusInkCap, EntityVariant.MushroomMolten, EntityVariant.MushroomFlyAgaricRed, EntityVariant.MushroomSoulWanderer, EntityVariant.MushroomWarped, EntityVariant.MushroomWarpedRare, EntityVariant.MushroomSnowball)));
                this.put(EntityTexture.DEFAULT, new ArrayList<EntityVariant>(List.of(EntityVariant.Bee, EntityVariant.JackOLantern, EntityVariant.JackOLanternBig, EntityVariant.JackOLanternMini, EntityVariant.Pumpkin, EntityVariant.PumpkinBig, EntityVariant.PumpkinMini, EntityVariant.MandrakeBrown, EntityVariant.MandrakeChorus, EntityVariant.MandrakeGreen, EntityVariant.MandrakeGlowBerry, EntityVariant.MushroomFlyAgaricYellow, EntityVariant.MushroomBrown, EntityVariant.MushroomCrimson, EntityVariant.MushroomCrimsonRare, EntityVariant.MushroomEnderPuffball, EntityVariant.MushroomInfernal, EntityVariant.FungusInkCap, EntityVariant.MushroomMolten, EntityVariant.MushroomFlyAgaricRed, EntityVariant.MushroomSoulWanderer, EntityVariant.MushroomWarped, EntityVariant.MushroomWarpedRare, EntityVariant.MushroomSnowball, EntityVariant.SlimeBlue, EntityVariant.SpookPeach, EntityVariant.SpookTeal, EntityVariant.WispBlue, EntityVariant.WispGreen, EntityVariant.WispYellow)));
                this.put(EntityTexture.TUMMY, new ArrayList<EntityVariant>(List.of(EntityVariant.Bee, EntityVariant.MushroomFlyAgaricYellow, EntityVariant.MushroomBrown, EntityVariant.MushroomCrimson, EntityVariant.MushroomCrimsonRare, EntityVariant.MushroomEnderPuffball, EntityVariant.MushroomInfernal, EntityVariant.FungusInkCap, EntityVariant.MushroomMolten, EntityVariant.MushroomFlyAgaricRed, EntityVariant.MushroomSoulWanderer, EntityVariant.MushroomWarped, EntityVariant.MushroomWarpedRare, EntityVariant.MushroomSnowball, EntityVariant.SpookPeach, EntityVariant.SpookTeal, EntityVariant.WispYellow)));
                this.put(EntityTexture.INFLATED, new ArrayList<EntityVariant>(List.of(EntityVariant.Bee, EntityVariant.MushroomEnderPuffball, EntityVariant.MushroomSnowball)));
                this.put(EntityTexture.CHUNKY, new ArrayList<EntityVariant>(List.of(EntityVariant.Bee)));
            }
        };
        SOUND = new HashMap<EntityVariant, HashMap<EntitySound, class_3414>>(){
            {
                HashMap<EntitySound, class_3414> mandrakeMap = new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.MANDRAKE_SOUND);
                        this.put(EntitySound.HURT, MonstersGirlsSounds.MANDRAKE_HURT);
                        this.put(EntitySound.DEATH, MonstersGirlsSounds.MANDRAKE_DEATH);
                    }
                };
                HashMap<EntitySound, class_3414> mushroomMap = new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.MUSHROOM_GIRL_SOUNDS);
                    }
                };
                HashMap<EntitySound, class_3414> spookMap = new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.ATTACK, MonstersGirlsSounds.SPOOK_ATTACK);
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.SPOOK_LAUGH);
                        this.put(EntitySound.HURT, MonstersGirlsSounds.SPOOK_HURT);
                    }
                };
                HashMap<EntitySound, class_3414> wispMap = new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.WISP_LAUGH);
                        this.put(EntitySound.HURT, MonstersGirlsSounds.WISP_HURT);
                        this.put(EntitySound.DEATH, MonstersGirlsSounds.WISP_DEATH);
                    }
                };
                HashMap<EntitySound, class_3414> slimeMap = new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.SLIME_GIRL_SOUNDS);
                        this.put(EntitySound.HURT, MonstersGirlsSounds.SLIME_GIRL_HURT);
                    }
                };
                this.put(EntityVariant.JackOLantern, new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.GOURDRAGORA_GIGGLES);
                    }
                });
                this.put(EntityVariant.JackOLanternBig, new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.GOURDRAGORA_ROAR);
                    }
                });
                this.put(EntityVariant.JackOLanternMini, new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.GOURDRAGORA_MINI_GIGGLES);
                    }
                });
                this.put(EntityVariant.Pumpkin, new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.GOURDRAGORA_GIGGLES);
                    }
                });
                this.put(EntityVariant.PumpkinBig, new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.GOURDRAGORA_ROAR);
                    }
                });
                this.put(EntityVariant.PumpkinMini, new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.GOURDRAGORA_MINI_GIGGLES);
                    }
                });
                this.put(EntityVariant.MandrakeBrown, mandrakeMap);
                this.put(EntityVariant.MandrakeChorus, mandrakeMap);
                this.put(EntityVariant.MandrakeGlowBerry, mandrakeMap);
                this.put(EntityVariant.MandrakeGreen, mandrakeMap);
                this.put(EntityVariant.MushroomFlyAgaricYellow, mushroomMap);
                this.put(EntityVariant.MushroomBrown, mushroomMap);
                this.put(EntityVariant.MushroomCrimson, mushroomMap);
                this.put(EntityVariant.MushroomCrimsonRare, mushroomMap);
                this.put(EntityVariant.MushroomEnderPuffball, new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.MUSHROOM_GIRL_ENDER);
                    }
                });
                this.put(EntityVariant.MushroomInfernal, mushroomMap);
                this.put(EntityVariant.FungusInkCap, mushroomMap);
                this.put(EntityVariant.MushroomMolten, mushroomMap);
                this.put(EntityVariant.MushroomFlyAgaricRed, mushroomMap);
                this.put(EntityVariant.MushroomSoulWanderer, mushroomMap);
                this.put(EntityVariant.MushroomWarped, mushroomMap);
                this.put(EntityVariant.MushroomWarpedRare, mushroomMap);
                this.put(EntityVariant.MushroomSnowball, new HashMap<EntitySound, class_3414>(){
                    {
                        this.put(EntitySound.DEFAULT, MonstersGirlsSounds.MUSHROOM_GIRL_ENDER);
                    }
                });
                this.put(EntityVariant.SlimeBlue, slimeMap);
                this.put(EntityVariant.SpookPeach, spookMap);
                this.put(EntityVariant.SpookTeal, spookMap);
                this.put(EntityVariant.WispBlue, wispMap);
                this.put(EntityVariant.WispGreen, wispMap);
                this.put(EntityVariant.WispYellow, wispMap);
            }
        };
        ANIMATOR = new HashMap<EntityAnimator, class_2960>(){
            {
                this.put(EntityAnimator.Bee, new class_2960("monsters_girls", "animations/bee_girl.animation.json"));
                this.put(EntityAnimator.Gourdragora, new class_2960("monsters_girls", "animations/gourdragora_girl.animation.json"));
                this.put(EntityAnimator.GourdragoraMini, new class_2960("monsters_girls", "animations/gourdragora_girl_mini.animation.json"));
                this.put(EntityAnimator.Mandrake, new class_2960("monsters_girls", "animations/mandrake_girl.animation.json"));
                this.put(EntityAnimator.MandrakeFruity, new class_2960("monsters_girls", "animations/mandrake_girl_fruity.animation.json"));
                this.put(EntityAnimator.MandrakeFruityChorus, new class_2960("monsters_girls", "animations/mandrake_girl_fruity_chorus.animation.json"));
                this.put(EntityAnimator.Mushroom, new class_2960("monsters_girls", "animations/mushroom_girl_default.animation.json"));
                this.put(EntityAnimator.MushroomFat, new class_2960("monsters_girls", "animations/mushroom_girl_tummy.animation.json"));
                this.put(EntityAnimator.MushroomInflated, new class_2960("monsters_girls", "animations/mushroom_girl_inflated.animation.json"));
                this.put(EntityAnimator.MushroomInkCap, new class_2960("monsters_girls", "animations/mushroom_girl_ink_cap.animation.json"));
                this.put(EntityAnimator.Slime, new class_2960("monsters_girls", "animations/slime_girl.animation.json"));
                this.put(EntityAnimator.Spook, new class_2960("monsters_girls", "animations/spook_girl.animation.json"));
                this.put(EntityAnimator.Wisp, new class_2960("monsters_girls", "animations/wisp_girl.animation.json"));
            }
        };
        MODEL = new HashMap<EntityModel, class_2960>(){
            {
                this.put(EntityModel.Bee, new class_2960("monsters_girls", "geo/bee_girl.geo.json"));
                this.put(EntityModel.Gourdragora, new class_2960("monsters_girls", "geo/gourdragora_girl.geo.json"));
                this.put(EntityModel.GourdragoraMini, new class_2960("monsters_girls", "geo/gourdragora_girl_mini.geo.json"));
                this.put(EntityModel.Mandrake, new class_2960("monsters_girls", "geo/mandrake_girl_default.geo.json"));
                this.put(EntityModel.MandrakeFruit, new class_2960("monsters_girls", "geo/mandrake_girl_fruit.geo.json"));
                this.put(EntityModel.MandrakeFruitChorus, new class_2960("monsters_girls", "geo/mandrake_girl_fruit_chorus.geo.json"));
                this.put(EntityModel.Mushroom, new class_2960("monsters_girls", "geo/mushroom_girl_default.geo.json"));
                this.put(EntityModel.MushroomFat, new class_2960("monsters_girls", "geo/mushroom_girl_tummy.geo.json"));
                this.put(EntityModel.MushroomInflated, new class_2960("monsters_girls", "geo/mushroom_girl_inflated.geo.json"));
                this.put(EntityModel.MushroomFungus, new class_2960("monsters_girls", "geo/mushroom_girl_ink_cap.geo.json"));
                this.put(EntityModel.Slime, new class_2960("monsters_girls", "geo/slime_girl.geo.json"));
                this.put(EntityModel.Spook, new class_2960("monsters_girls", "geo/spook_girl.geo.json"));
                this.put(EntityModel.Wisp, new class_2960("monsters_girls", "geo/wisp_girl.geo.json"));
            }
        };
        TEXTURE = new HashMap<EntityVariant, HashMap<EntityTexture, class_2960>>(){
            {
                this.put(EntityVariant.Bee, InternalMetric.setTexture("bee/bee_04", true, true, true, true, true));
                this.put(EntityVariant.JackOLantern, InternalMetric.setTexture("gourdragora/jacko_girl", false, false, false, false, false));
                this.put(EntityVariant.JackOLanternBig, InternalMetric.setTexture("gourdragora/jacko_girl_big", false, false, false, false, false));
                this.put(EntityVariant.JackOLanternMini, InternalMetric.setTexture("gourdragora/jacko_girl_mini", false, false, false, false, false));
                this.put(EntityVariant.Pumpkin, InternalMetric.setTexture("gourdragora/pumpkin_girl", false, false, false, false, false));
                this.put(EntityVariant.PumpkinBig, InternalMetric.setTexture("gourdragora/pumpkin_girl_big", false, false, false, false, false));
                this.put(EntityVariant.PumpkinMini, InternalMetric.setTexture("gourdragora/pumpkin_girl_mini", false, false, false, false, false));
                this.put(EntityVariant.MandrakeBrown, InternalMetric.setTexture("mandrake/mandrake_girl_brown", false, false, false, false, false));
                this.put(EntityVariant.MandrakeChorus, InternalMetric.setTexture("mandrake/mandrake_girl_chorus", false, false, false, false, false));
                this.put(EntityVariant.MandrakeGlowBerry, InternalMetric.setTexture("mandrake/mandrake_girl_glow_berry", false, false, false, false, false));
                this.put(EntityVariant.MandrakeGreen, InternalMetric.setTexture("mandrake/mandrake_girl_green", false, false, false, false, false));
                this.put(EntityVariant.MushroomFlyAgaricYellow, InternalMetric.setTexture("mushroom/mushroom_girl_yellow", true, true, true, false, false));
                this.put(EntityVariant.MushroomBrown, InternalMetric.setTexture("mushroom/mushroom_girl_brown", true, true, true, false, false));
                this.put(EntityVariant.MushroomCrimson, InternalMetric.setTexture("mushroom/mushroom_girl_crimson", true, true, true, false, false));
                this.put(EntityVariant.MushroomCrimsonRare, InternalMetric.setTexture("mushroom/mushroom_girl_crimson_rare", true, true, true, false, false));
                this.put(EntityVariant.MushroomEnderPuffball, InternalMetric.setTexture("mushroom/mushroom_girl_ender_puffball", true, true, true, true, false));
                this.put(EntityVariant.MushroomInfernal, InternalMetric.setTexture("mushroom/mushroom_girl_infernal", true, true, true, false, false));
                this.put(EntityVariant.FungusInkCap, InternalMetric.setTexture("mushroom/mushroom_girl_ink_cap", true, true, true, false, false));
                this.put(EntityVariant.MushroomMolten, InternalMetric.setTexture("mushroom/mushroom_girl_molten", true, true, true, false, false));
                this.put(EntityVariant.MushroomFlyAgaricRed, InternalMetric.setTexture("mushroom/mushroom_girl_red", true, true, true, false, false));
                this.put(EntityVariant.MushroomSoulWanderer, InternalMetric.setTexture("mushroom/mushroom_girl_soul_wanderer", true, true, true, false, false));
                this.put(EntityVariant.MushroomWarped, InternalMetric.setTexture("mushroom/mushroom_girl_warped", true, true, true, false, false));
                this.put(EntityVariant.MushroomWarpedRare, InternalMetric.setTexture("mushroom/mushroom_girl_warped_rare", true, true, true, false, false));
                this.put(EntityVariant.MushroomSnowball, InternalMetric.setTexture("mushroom/mushroom_girl_snowball", true, true, true, true, false));
                this.put(EntityVariant.SlimeBlue, InternalMetric.setTexture("slime/slime_girl", false, false, false, false, false));
                this.put(EntityVariant.SpookPeach, InternalMetric.setTexture("spook/spook_girl_peach", false, false, true, false, false));
                this.put(EntityVariant.SpookTeal, InternalMetric.setTexture("spook/spook_girl_teal", false, false, true, false, false));
                this.put(EntityVariant.WispBlue, InternalMetric.setTexture("wisp/wisp_girl_blue", false, false, false, false, false));
                this.put(EntityVariant.WispGreen, InternalMetric.setTexture("wisp/wisp_girl_green", false, false, false, false, false));
                this.put(EntityVariant.WispYellow, InternalMetric.setTexture("wisp/wisp_girl_yellow", false, false, true, false, false));
            }
        };
        BEE_TEXTURES = new ArrayList<HashMap<EntityTexture, class_2960>>(List.of(InternalMetric.setTexture("bee/bee_00", true, true, true, true, true), InternalMetric.setTexture("bee/bee_01", true, true, true, true, true), InternalMetric.setTexture("bee/bee_02", true, true, true, true, true), InternalMetric.setTexture("bee/bee_03", true, true, true, true, true), InternalMetric.setTexture("bee/bee_04", true, true, true, true, true), InternalMetric.setTexture("bee/bee_05", true, true, true, true, true)));
        ATTRIBUTES = new HashMap();
        SETTINGS = new HashMap();
        HELPFUL_EFFECTS = new HashMap<EntityVariant, List<List<InternalData>>>(){
            {
                ArrayList<InternalData> regeneration = new ArrayList<InternalData>(List.of(new InternalData(class_1802.field_8423), new InternalData(class_1294.field_5924), new InternalData(5000), new InternalData(1)));
                ArrayList<InternalData> strength = new ArrayList<InternalData>(List.of(new InternalData(class_1802.field_8324), new InternalData(class_1294.field_5910), new InternalData(5000), new InternalData(1)));
                ArrayList<InternalData> luck = new ArrayList<InternalData>(List.of(new InternalData(class_1802.field_8696), new InternalData(class_1294.field_5926), new InternalData(5000), new InternalData(1)));
                ArrayList<InternalData> healthBoost = new ArrayList<InternalData>(List.of(new InternalData(class_1802.field_8705), new InternalData(class_1294.field_5914), new InternalData(5000), new InternalData(2)));
                ArrayList<InternalData> nightVision = new ArrayList<InternalData>(List.of(new InternalData(class_1802.field_28659), new InternalData(class_1294.field_5925), new InternalData(5000), new InternalData(1)));
                ArrayList<InternalData> haste = new ArrayList<InternalData>(List.of(new InternalData(class_1802.field_8705), new InternalData(class_1294.field_5917), new InternalData(5000), new InternalData(2)));
                this.put(EntityVariant.MandrakeGreen, new ArrayList<ArrayList<InternalData>>(List.of(regeneration, strength, luck, healthBoost)));
                this.put(EntityVariant.MandrakeBrown, new ArrayList<ArrayList<InternalData>>(List.of(regeneration, strength, luck, healthBoost)));
                this.put(EntityVariant.MandrakeGlowBerry, new ArrayList<ArrayList<InternalData>>(List.of(nightVision, strength, luck, haste)));
            }
        };
        HARMFUL_EFFECTS = new HashMap<EntityVariant, List<List<InternalData>>>(){
            {
                ArrayList<InternalData> poison = new ArrayList<InternalData>(List.of(new InternalData(class_1294.field_5899), new InternalData(1000), new InternalData(2)));
                ArrayList<InternalData> weakness = new ArrayList<InternalData>(List.of(new InternalData(class_1294.field_5911), new InternalData(1000), new InternalData(2)));
                ArrayList<InternalData> unlucky = new ArrayList<InternalData>(List.of(new InternalData(class_1294.field_5908), new InternalData(1000), new InternalData(2)));
                ArrayList<InternalData> nausea = new ArrayList<InternalData>(List.of(new InternalData(class_1294.field_5916), new InternalData(1000), new InternalData(1)));
                ArrayList<InternalData> hunger = new ArrayList<InternalData>(List.of(new InternalData(class_1294.field_5903), new InternalData(1000), new InternalData(2)));
                ArrayList<InternalData> blindness = new ArrayList<InternalData>(List.of(new InternalData(class_1294.field_5919), new InternalData(1000), new InternalData(1)));
                ArrayList<InternalData> slowness = new ArrayList<InternalData>(List.of(new InternalData(class_1294.field_5909), new InternalData(1000), new InternalData(1)));
                ArrayList<InternalData> mining = new ArrayList<InternalData>(List.of(new InternalData(class_1294.field_5901), new InternalData(1000), new InternalData(2)));
                this.put(EntityVariant.MandrakeGreen, new ArrayList<ArrayList<InternalData>>(List.of(poison, weakness, unlucky, nausea, hunger, slowness)));
                this.put(EntityVariant.MandrakeBrown, new ArrayList<ArrayList<InternalData>>(List.of(poison, weakness, unlucky, nausea, hunger, slowness)));
                this.put(EntityVariant.MandrakeGlowBerry, new ArrayList<ArrayList<InternalData>>(List.of(blindness, weakness, unlucky, mining, hunger, slowness)));
            }
        };
        PLANTING = new HashMap<EntityVariant, InternalPlanting>(){
            {
                this.put(EntityVariant.MandrakeBrown, new InternalPlanting(List.of(class_2246.field_10219), List.of(new BlockPlanting(5.0E-4f, MonstersGirlsBlocks.MANDRAKE_FLOWER))));
                this.put(EntityVariant.MandrakeChorus, new InternalPlanting(List.of(class_2246.field_10471, MonstersGirlsBlocks.ENDER_MOSS), List.of(new BlockPlanting(5.0E-4f, class_2246.field_10021))));
                this.put(EntityVariant.MandrakeGlowBerry, new InternalPlanting(List.of(), List.of(new BlockPlanting(5.0E-4f, MonstersGirlsBlocks.GLOW_BERRY_BUSH))));
                this.put(EntityVariant.MandrakeGreen, new InternalPlanting(List.of(class_2246.field_10219), List.of(new BlockPlanting(5.0E-4f, MonstersGirlsBlocks.MANDRAKE_FLOWER))));
                this.put(EntityVariant.MushroomBrown, new InternalPlanting(List.of(class_2246.field_10219), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_BROWN_MUSHROOM), new BlockPlanting(5.0E-4f, class_2246.field_10251))));
                this.put(EntityVariant.MushroomFlyAgaricYellow, new InternalPlanting(List.of(class_2246.field_10219), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_BROWN_MUSHROOM), new BlockPlanting(5.0E-4f, class_2246.field_10251))));
                this.put(EntityVariant.MushroomCrimson, new InternalPlanting(List.of(class_2246.field_22120), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_CRIMSON_FUNGUS), new BlockPlanting(5.0E-4f, class_2246.field_22121))));
                this.put(EntityVariant.MushroomCrimsonRare, new InternalPlanting(List.of(class_2246.field_22120), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_CRIMSON_FUNGUS), new BlockPlanting(5.0E-4f, class_2246.field_22121))));
                this.put(EntityVariant.MushroomEnderPuffball, new InternalPlanting(List.of(class_2246.field_10471, MonstersGirlsBlocks.ENDER_MOSS), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_ENDER_PUFFBALL), new BlockPlanting(5.0E-4f, MonstersGirlsBlocks.ENDER_PUFFBALL_MUSHROOM))));
                this.put(EntityVariant.MushroomFlyAgaricRed, new InternalPlanting(List.of(class_2246.field_10219), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_FLY_RED_AGARIC), new BlockPlanting(5.0E-4f, class_2246.field_10559))));
                this.put(EntityVariant.MushroomInfernal, new InternalPlanting(List.of(class_2246.field_10219), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_INFERNAL_MUSHROOM), new BlockPlanting(5.0E-4f, class_2246.field_10559), new BlockPlanting(5.0E-4f, class_2246.field_10251))));
                this.put(EntityVariant.FungusInkCap, new InternalPlanting(List.of(class_2246.field_10219), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_INK_CAP_MUSHROOM), new BlockPlanting(5.0E-4f, MonstersGirlsBlocks.INK_CAP_MUSHROOM))));
                this.put(EntityVariant.MushroomMolten, new InternalPlanting(List.of(class_2246.field_22091, class_2246.field_23869, class_2246.field_10092), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_MOLTEN_FUNGUS), new BlockPlanting(5.0E-4f, MonstersGirlsBlocks.MOLTEN_FUNGUS))));
                this.put(EntityVariant.MushroomSoulWanderer, new InternalPlanting(List.of(class_2246.field_10114, class_2246.field_22090), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_SOUL_WANDERER), new BlockPlanting(5.0E-4f, MonstersGirlsBlocks.SOUL_WANDERER_FUNGUS))));
                this.put(EntityVariant.MushroomWarped, new InternalPlanting(List.of(class_2246.field_22113), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_WARPED_FUNGUS), new BlockPlanting(5.0E-4f, class_2246.field_22114))));
                this.put(EntityVariant.MushroomWarpedRare, new InternalPlanting(List.of(class_2246.field_22113), List.of(new BlockPlanting(5.0E-7f, MonstersGirlsBlocks.HUGE_WARPED_FUNGUS), new BlockPlanting(5.0E-4f, class_2246.field_22114))));
            }
        };
    }
}

